/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.invoker;

import com.google.cloud.functions.Context;
import com.google.cloud.functions.invoker.CloudFunction;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BackgroundCloudFunction
extends CloudFunction {
    BackgroundCloudFunction(Object o, Method m) {
        super(o, m);
    }

    void execute(JsonElement dataJson, Context context) throws InvocationTargetException {
        JsonElement data;
        Class<?> dataParameterType = this.functionMethod.getParameterTypes()[0];
        if (dataParameterType == JsonElement.class) {
            data = dataJson;
        } else {
            Gson gson = new Gson();
            try {
                data = gson.fromJson(dataJson, dataParameterType);
            }
            catch (JsonParseException e) {
                String string = String.valueOf(dataParameterType.getCanonicalName());
                throw new RuntimeException(string.length() != 0 ? "Could not parse received event payload into type ".concat(string) : new String("Could not parse received event payload into type "), e);
            }
        }
        if (this.functionMethod.getParameterCount() == 2) {
            this.rawExecute(data, context);
        } else {
            this.rawExecute(data);
        }
    }
}

