/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.AutoValue_AsyncWriteChannelOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import java.time.Duration;

@AutoValue
public abstract class AsyncWriteChannelOptions {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int PARALLEL_COMPOSITE_UPLOAD_BUFFER_COUNT = 1;
    private static final int PARALLEL_COMPOSITE_UPLOAD_BUFFER_CAPACITY = 0x2000000;
    private static final int UPLOAD_CHUNK_SIZE_GRANULARITY = 0x800000;
    private static final String PART_FILE_PREFIX = "";
    private static final int DEFAULT_UPLOAD_CHUNK_SIZE = Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x800000 : 0x1800000;
    public static final AsyncWriteChannelOptions DEFAULT = AsyncWriteChannelOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_AsyncWriteChannelOptions.Builder().setBufferSize(0x800000).setDirectUploadEnabled(false).setGrpcChecksumsEnabled(false).setGrpcWriteMessageTimeout(Duration.ofSeconds(3L)).setGrpcWriteTimeout(Duration.ofMinutes(10L)).setNumberOfBufferedRequests(20).setPipeBufferSize(0x100000).setPipeType(PipeType.IO_STREAM_PIPE).setUploadCacheSize(0).setUploadChunkSize(DEFAULT_UPLOAD_CHUNK_SIZE).setUploadType(UploadType.CHUNK_UPLOAD).setTemporaryPaths((ImmutableSet<String>)ImmutableSet.of()).setPCUBufferCount(1).setPCUBufferCapacity(0x2000000).setPartFileCleanupType(PartFileCleanupType.ALWAYS).setPartFileNamePrefix(PART_FILE_PREFIX).setRollingChecksumEnabled(true);
    }

    public abstract Builder toBuilder();

    public abstract int getBufferSize();

    public abstract int getPipeBufferSize();

    public abstract PipeType getPipeType();

    public abstract int getUploadChunkSize();

    public abstract int getUploadCacheSize();

    public abstract boolean isDirectUploadEnabled();

    public abstract boolean isGrpcChecksumsEnabled();

    public abstract boolean isRollingChecksumEnabled();

    public abstract Duration getGrpcWriteTimeout();

    public abstract int getNumberOfBufferedRequests();

    public abstract Duration getGrpcWriteMessageTimeout();

    public abstract UploadType getUploadType();

    public abstract PartFileCleanupType getPartFileCleanupType();

    public abstract ImmutableSet<String> getTemporaryPaths();

    public abstract int getPCUBufferCount();

    public abstract int getPCUBufferCapacity();

    public abstract String getPartFileNamePrefix();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBufferSize(int var1);

        public abstract Builder setPipeBufferSize(int var1);

        public abstract Builder setPipeType(PipeType var1);

        public abstract Builder setUploadChunkSize(int var1);

        public abstract Builder setUploadCacheSize(int var1);

        public abstract Builder setDirectUploadEnabled(boolean var1);

        public abstract Builder setRollingChecksumEnabled(boolean var1);

        public abstract Builder setGrpcWriteTimeout(Duration var1);

        public abstract Builder setNumberOfBufferedRequests(int var1);

        public abstract Builder setGrpcChecksumsEnabled(boolean var1);

        public abstract Builder setGrpcWriteMessageTimeout(Duration var1);

        public abstract Builder setUploadType(UploadType var1);

        public abstract Builder setPartFileCleanupType(PartFileCleanupType var1);

        public abstract Builder setTemporaryPaths(ImmutableSet<String> var1);

        public abstract Builder setPCUBufferCount(int var1);

        public abstract Builder setPCUBufferCapacity(int var1);

        public abstract Builder setPartFileNamePrefix(String var1);

        abstract AsyncWriteChannelOptions autoBuild();

        public AsyncWriteChannelOptions build() {
            AsyncWriteChannelOptions options = this.autoBuild();
            Builder.checkUploadChunkSize(options.getUploadChunkSize());
            return options;
        }

        private static void checkUploadChunkSize(int chunkSize) {
            Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (String)"Upload chunk size must be great than 0, but was $%s", (int)chunkSize);
            Preconditions.checkArgument((chunkSize % 262144 == 0 ? 1 : 0) != 0, (String)"Upload chunk size must be a multiple of %s", (int)262144);
            if (chunkSize > 0x800000 && chunkSize % 0x800000 != 0) {
                ((GoogleLogger.Api)logger.atWarning()).log("Upload chunk size should be a multiple of %s for the best performance, got %s", 0x800000, chunkSize);
            }
        }
    }

    public static enum PipeType {
        IO_STREAM_PIPE,
        NIO_CHANNEL_PIPE;

    }

    public static enum UploadType {
        CHUNK_UPLOAD,
        WRITE_TO_DISK_THEN_UPLOAD,
        JOURNALING,
        PARALLEL_COMPOSITE_UPLOAD;

    }

    public static enum PartFileCleanupType {
        ALWAYS,
        NEVER,
        ON_SUCCESS;

    }
}

