/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import java.io.IOException;
import java.util.UUID;

public class JsonIdempotencyTokenInterceptor
implements HttpExecuteInterceptor {
    public static final String IDEMPOTENCY_TOKEN_HEADER = "x-goog-gcs-idempotency-token";
    private final HttpExecuteInterceptor chainedInterceptor;

    public JsonIdempotencyTokenInterceptor(HttpExecuteInterceptor chainedInterceptor) {
        this.chainedInterceptor = chainedInterceptor;
    }

    public void intercept(HttpRequest request) throws IOException {
        if (!request.getHeaders().containsKey((Object)IDEMPOTENCY_TOKEN_HEADER)) {
            request.getHeaders().set(IDEMPOTENCY_TOKEN_HEADER, (Object)UUID.randomUUID().toString());
        }
        if (this.chainedInterceptor != null) {
            this.chainedInterceptor.intercept(request);
        }
    }
}

