package com.google.cloud.hadoop.util;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AsyncWriteChannelOptions extends AsyncWriteChannelOptions {

  private final int bufferSize;

  private final int pipeBufferSize;

  private final AsyncWriteChannelOptions.PipeType pipeType;

  private final int uploadChunkSize;

  private final int uploadCacheSize;

  private final boolean directUploadEnabled;

  private final boolean grpcChecksumsEnabled;

  private final long grpcWriteTimeout;

  private final long numberOfBufferedRequests;

  private final long grpcWriteMessageTimeoutMillis;

  private final AsyncWriteChannelOptions.UploadType uploadType;

  private final AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType;

  private final ImmutableSet<String> temporaryPaths;

  private final int PCUBufferCount;

  private final int PCUBufferCapacity;

  private final String partFileNamePrefix;

  private AutoValue_AsyncWriteChannelOptions(
      int bufferSize,
      int pipeBufferSize,
      AsyncWriteChannelOptions.PipeType pipeType,
      int uploadChunkSize,
      int uploadCacheSize,
      boolean directUploadEnabled,
      boolean grpcChecksumsEnabled,
      long grpcWriteTimeout,
      long numberOfBufferedRequests,
      long grpcWriteMessageTimeoutMillis,
      AsyncWriteChannelOptions.UploadType uploadType,
      AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType,
      ImmutableSet<String> temporaryPaths,
      int PCUBufferCount,
      int PCUBufferCapacity,
      String partFileNamePrefix) {
    this.bufferSize = bufferSize;
    this.pipeBufferSize = pipeBufferSize;
    this.pipeType = pipeType;
    this.uploadChunkSize = uploadChunkSize;
    this.uploadCacheSize = uploadCacheSize;
    this.directUploadEnabled = directUploadEnabled;
    this.grpcChecksumsEnabled = grpcChecksumsEnabled;
    this.grpcWriteTimeout = grpcWriteTimeout;
    this.numberOfBufferedRequests = numberOfBufferedRequests;
    this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
    this.uploadType = uploadType;
    this.partFileCleanupType = partFileCleanupType;
    this.temporaryPaths = temporaryPaths;
    this.PCUBufferCount = PCUBufferCount;
    this.PCUBufferCapacity = PCUBufferCapacity;
    this.partFileNamePrefix = partFileNamePrefix;
  }

  @Override
  public int getBufferSize() {
    return bufferSize;
  }

  @Override
  public int getPipeBufferSize() {
    return pipeBufferSize;
  }

  @Override
  public AsyncWriteChannelOptions.PipeType getPipeType() {
    return pipeType;
  }

  @Override
  public int getUploadChunkSize() {
    return uploadChunkSize;
  }

  @Override
  public int getUploadCacheSize() {
    return uploadCacheSize;
  }

  @Override
  public boolean isDirectUploadEnabled() {
    return directUploadEnabled;
  }

  @Override
  public boolean isGrpcChecksumsEnabled() {
    return grpcChecksumsEnabled;
  }

  @Override
  public long getGrpcWriteTimeout() {
    return grpcWriteTimeout;
  }

  @Override
  public long getNumberOfBufferedRequests() {
    return numberOfBufferedRequests;
  }

  @Override
  public long getGrpcWriteMessageTimeoutMillis() {
    return grpcWriteMessageTimeoutMillis;
  }

  @Override
  public AsyncWriteChannelOptions.UploadType getUploadType() {
    return uploadType;
  }

  @Override
  public AsyncWriteChannelOptions.PartFileCleanupType getPartFileCleanupType() {
    return partFileCleanupType;
  }

  @Override
  public ImmutableSet<String> getTemporaryPaths() {
    return temporaryPaths;
  }

  @Override
  public int getPCUBufferCount() {
    return PCUBufferCount;
  }

  @Override
  public int getPCUBufferCapacity() {
    return PCUBufferCapacity;
  }

  @Override
  public String getPartFileNamePrefix() {
    return partFileNamePrefix;
  }

  @Override
  public String toString() {
    return "AsyncWriteChannelOptions{"
        + "bufferSize=" + bufferSize + ", "
        + "pipeBufferSize=" + pipeBufferSize + ", "
        + "pipeType=" + pipeType + ", "
        + "uploadChunkSize=" + uploadChunkSize + ", "
        + "uploadCacheSize=" + uploadCacheSize + ", "
        + "directUploadEnabled=" + directUploadEnabled + ", "
        + "grpcChecksumsEnabled=" + grpcChecksumsEnabled + ", "
        + "grpcWriteTimeout=" + grpcWriteTimeout + ", "
        + "numberOfBufferedRequests=" + numberOfBufferedRequests + ", "
        + "grpcWriteMessageTimeoutMillis=" + grpcWriteMessageTimeoutMillis + ", "
        + "uploadType=" + uploadType + ", "
        + "partFileCleanupType=" + partFileCleanupType + ", "
        + "temporaryPaths=" + temporaryPaths + ", "
        + "PCUBufferCount=" + PCUBufferCount + ", "
        + "PCUBufferCapacity=" + PCUBufferCapacity + ", "
        + "partFileNamePrefix=" + partFileNamePrefix
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AsyncWriteChannelOptions) {
      AsyncWriteChannelOptions that = (AsyncWriteChannelOptions) o;
      return this.bufferSize == that.getBufferSize()
          && this.pipeBufferSize == that.getPipeBufferSize()
          && this.pipeType.equals(that.getPipeType())
          && this.uploadChunkSize == that.getUploadChunkSize()
          && this.uploadCacheSize == that.getUploadCacheSize()
          && this.directUploadEnabled == that.isDirectUploadEnabled()
          && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled()
          && this.grpcWriteTimeout == that.getGrpcWriteTimeout()
          && this.numberOfBufferedRequests == that.getNumberOfBufferedRequests()
          && this.grpcWriteMessageTimeoutMillis == that.getGrpcWriteMessageTimeoutMillis()
          && this.uploadType.equals(that.getUploadType())
          && this.partFileCleanupType.equals(that.getPartFileCleanupType())
          && this.temporaryPaths.equals(that.getTemporaryPaths())
          && this.PCUBufferCount == that.getPCUBufferCount()
          && this.PCUBufferCapacity == that.getPCUBufferCapacity()
          && this.partFileNamePrefix.equals(that.getPartFileNamePrefix());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= bufferSize;
    h$ *= 1000003;
    h$ ^= pipeBufferSize;
    h$ *= 1000003;
    h$ ^= pipeType.hashCode();
    h$ *= 1000003;
    h$ ^= uploadChunkSize;
    h$ *= 1000003;
    h$ ^= uploadCacheSize;
    h$ *= 1000003;
    h$ ^= directUploadEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcChecksumsEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((grpcWriteTimeout >>> 32) ^ grpcWriteTimeout);
    h$ *= 1000003;
    h$ ^= (int) ((numberOfBufferedRequests >>> 32) ^ numberOfBufferedRequests);
    h$ *= 1000003;
    h$ ^= (int) ((grpcWriteMessageTimeoutMillis >>> 32) ^ grpcWriteMessageTimeoutMillis);
    h$ *= 1000003;
    h$ ^= uploadType.hashCode();
    h$ *= 1000003;
    h$ ^= partFileCleanupType.hashCode();
    h$ *= 1000003;
    h$ ^= temporaryPaths.hashCode();
    h$ *= 1000003;
    h$ ^= PCUBufferCount;
    h$ *= 1000003;
    h$ ^= PCUBufferCapacity;
    h$ *= 1000003;
    h$ ^= partFileNamePrefix.hashCode();
    return h$;
  }

  @Override
  public AsyncWriteChannelOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AsyncWriteChannelOptions.Builder {
    private int bufferSize;
    private int pipeBufferSize;
    private AsyncWriteChannelOptions.PipeType pipeType;
    private int uploadChunkSize;
    private int uploadCacheSize;
    private boolean directUploadEnabled;
    private boolean grpcChecksumsEnabled;
    private long grpcWriteTimeout;
    private long numberOfBufferedRequests;
    private long grpcWriteMessageTimeoutMillis;
    private AsyncWriteChannelOptions.UploadType uploadType;
    private AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType;
    private ImmutableSet<String> temporaryPaths;
    private int PCUBufferCount;
    private int PCUBufferCapacity;
    private String partFileNamePrefix;
    private short set$0;
    Builder() {
    }
    private Builder(AsyncWriteChannelOptions source) {
      this.bufferSize = source.getBufferSize();
      this.pipeBufferSize = source.getPipeBufferSize();
      this.pipeType = source.getPipeType();
      this.uploadChunkSize = source.getUploadChunkSize();
      this.uploadCacheSize = source.getUploadCacheSize();
      this.directUploadEnabled = source.isDirectUploadEnabled();
      this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
      this.grpcWriteTimeout = source.getGrpcWriteTimeout();
      this.numberOfBufferedRequests = source.getNumberOfBufferedRequests();
      this.grpcWriteMessageTimeoutMillis = source.getGrpcWriteMessageTimeoutMillis();
      this.uploadType = source.getUploadType();
      this.partFileCleanupType = source.getPartFileCleanupType();
      this.temporaryPaths = source.getTemporaryPaths();
      this.PCUBufferCount = source.getPCUBufferCount();
      this.PCUBufferCapacity = source.getPCUBufferCapacity();
      this.partFileNamePrefix = source.getPartFileNamePrefix();
      set$0 = (short) 0x7ff;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
      this.bufferSize = bufferSize;
      set$0 |= (short) 1;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
      this.pipeBufferSize = pipeBufferSize;
      set$0 |= (short) 2;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPipeType(AsyncWriteChannelOptions.PipeType pipeType) {
      if (pipeType == null) {
        throw new NullPointerException("Null pipeType");
      }
      this.pipeType = pipeType;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
      this.uploadChunkSize = uploadChunkSize;
      set$0 |= (short) 4;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
      this.uploadCacheSize = uploadCacheSize;
      set$0 |= (short) 8;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
      this.directUploadEnabled = directUploadEnabled;
      set$0 |= (short) 0x10;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
      this.grpcChecksumsEnabled = grpcChecksumsEnabled;
      set$0 |= (short) 0x20;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcWriteTimeout(long grpcWriteTimeout) {
      this.grpcWriteTimeout = grpcWriteTimeout;
      set$0 |= (short) 0x40;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setNumberOfBufferedRequests(long numberOfBufferedRequests) {
      this.numberOfBufferedRequests = numberOfBufferedRequests;
      set$0 |= (short) 0x80;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcWriteMessageTimeoutMillis(long grpcWriteMessageTimeoutMillis) {
      this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
      set$0 |= (short) 0x100;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadType(AsyncWriteChannelOptions.UploadType uploadType) {
      if (uploadType == null) {
        throw new NullPointerException("Null uploadType");
      }
      this.uploadType = uploadType;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPartFileCleanupType(AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType) {
      if (partFileCleanupType == null) {
        throw new NullPointerException("Null partFileCleanupType");
      }
      this.partFileCleanupType = partFileCleanupType;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setTemporaryPaths(ImmutableSet<String> temporaryPaths) {
      if (temporaryPaths == null) {
        throw new NullPointerException("Null temporaryPaths");
      }
      this.temporaryPaths = temporaryPaths;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPCUBufferCount(int PCUBufferCount) {
      this.PCUBufferCount = PCUBufferCount;
      set$0 |= (short) 0x200;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPCUBufferCapacity(int PCUBufferCapacity) {
      this.PCUBufferCapacity = PCUBufferCapacity;
      set$0 |= (short) 0x400;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPartFileNamePrefix(String partFileNamePrefix) {
      if (partFileNamePrefix == null) {
        throw new NullPointerException("Null partFileNamePrefix");
      }
      this.partFileNamePrefix = partFileNamePrefix;
      return this;
    }
    @Override
    AsyncWriteChannelOptions autoBuild() {
      if (set$0 != 0x7ff
          || this.pipeType == null
          || this.uploadType == null
          || this.partFileCleanupType == null
          || this.temporaryPaths == null
          || this.partFileNamePrefix == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" bufferSize");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" pipeBufferSize");
        }
        if (this.pipeType == null) {
          missing.append(" pipeType");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" uploadChunkSize");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" uploadCacheSize");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" directUploadEnabled");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" grpcChecksumsEnabled");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" grpcWriteTimeout");
        }
        if ((set$0 & 0x80) == 0) {
          missing.append(" numberOfBufferedRequests");
        }
        if ((set$0 & 0x100) == 0) {
          missing.append(" grpcWriteMessageTimeoutMillis");
        }
        if (this.uploadType == null) {
          missing.append(" uploadType");
        }
        if (this.partFileCleanupType == null) {
          missing.append(" partFileCleanupType");
        }
        if (this.temporaryPaths == null) {
          missing.append(" temporaryPaths");
        }
        if ((set$0 & 0x200) == 0) {
          missing.append(" PCUBufferCount");
        }
        if ((set$0 & 0x400) == 0) {
          missing.append(" PCUBufferCapacity");
        }
        if (this.partFileNamePrefix == null) {
          missing.append(" partFileNamePrefix");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AsyncWriteChannelOptions(
          this.bufferSize,
          this.pipeBufferSize,
          this.pipeType,
          this.uploadChunkSize,
          this.uploadCacheSize,
          this.directUploadEnabled,
          this.grpcChecksumsEnabled,
          this.grpcWriteTimeout,
          this.numberOfBufferedRequests,
          this.grpcWriteMessageTimeoutMillis,
          this.uploadType,
          this.partFileCleanupType,
          this.temporaryPaths,
          this.PCUBufferCount,
          this.PCUBufferCapacity,
          this.partFileNamePrefix);
    }
  }

}
