package com.google.cloud.hadoop.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RequesterPaysOptions extends RequesterPaysOptions {

  private final RequesterPaysOptions.RequesterPaysMode mode;

  private final String projectId;

  private final ImmutableSet<String> buckets;

  private AutoValue_RequesterPaysOptions(
      RequesterPaysOptions.RequesterPaysMode mode,
      @Nullable String projectId,
      ImmutableSet<String> buckets) {
    this.mode = mode;
    this.projectId = projectId;
    this.buckets = buckets;
  }

  @Override
  public RequesterPaysOptions.RequesterPaysMode getMode() {
    return mode;
  }

  @Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @Override
  public ImmutableSet<String> getBuckets() {
    return buckets;
  }

  @Override
  public String toString() {
    return "RequesterPaysOptions{"
        + "mode=" + mode + ", "
        + "projectId=" + projectId + ", "
        + "buckets=" + buckets
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RequesterPaysOptions) {
      RequesterPaysOptions that = (RequesterPaysOptions) o;
      return this.mode.equals(that.getMode())
          && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId()))
          && this.buckets.equals(that.getBuckets());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= mode.hashCode();
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= buckets.hashCode();
    return h$;
  }

  @Override
  public RequesterPaysOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends RequesterPaysOptions.Builder {
    private RequesterPaysOptions.RequesterPaysMode mode;
    private String projectId;
    private ImmutableSet<String> buckets;
    Builder() {
    }
    private Builder(RequesterPaysOptions source) {
      this.mode = source.getMode();
      this.projectId = source.getProjectId();
      this.buckets = source.getBuckets();
    }
    @Override
    public RequesterPaysOptions.Builder setMode(RequesterPaysOptions.RequesterPaysMode mode) {
      if (mode == null) {
        throw new NullPointerException("Null mode");
      }
      this.mode = mode;
      return this;
    }
    @Override
    public RequesterPaysOptions.Builder setProjectId(@Nullable String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public RequesterPaysOptions.Builder setBuckets(Collection<String> buckets) {
      this.buckets = ImmutableSet.copyOf(buckets);
      return this;
    }
    @Override
    public RequesterPaysOptions.Builder setBuckets(String... buckets) {
      this.buckets = ImmutableSet.copyOf(buckets);
      return this;
    }
    @Override
    public RequesterPaysOptions build() {
      String missing = "";
      if (this.mode == null) {
        missing += " mode";
      }
      if (this.buckets == null) {
        missing += " buckets";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RequesterPaysOptions(
          this.mode,
          this.projectId,
          this.buckets);
    }
  }

}
