/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWriteChannelOptions {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncWriteChannelOptions.class);
    public static final boolean LIMIT_FILESIZE_TO_250GB_DEFAULT = false;
    public static final int UPLOAD_BUFFER_SIZE_DEFAULT = 0x4000000;
    public static final boolean DIRECT_UPLOAD_ENABLED_DEFAULT = false;
    private final boolean fileSizeLimitedTo250Gb;
    private final int uploadBufferSize;
    private final boolean directUploadEnabled;

    public static Builder newBuilder() {
        return new Builder();
    }

    public AsyncWriteChannelOptions(boolean fileSizeLimitedTo250Gb, int uploadBufferSize, boolean useDirectUpload) {
        this.fileSizeLimitedTo250Gb = fileSizeLimitedTo250Gb;
        this.uploadBufferSize = uploadBufferSize;
        this.directUploadEnabled = useDirectUpload;
        if (fileSizeLimitedTo250Gb) {
            LOG.warn("fileSizeLimitedTo250Gb now defaults to false. It is deprecated and will soon be removed. Files greater than 250Gb are allowed by default.");
        }
    }

    @Deprecated
    public boolean isFileSizeLimitedTo250Gb() {
        return this.fileSizeLimitedTo250Gb;
    }

    public int getUploadBufferSize() {
        return this.uploadBufferSize;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    public static class Builder {
        private boolean fileSizeLimitedTo250Gb = false;
        private int uploadBufferSize = 0x4000000;
        private boolean useDirectUpload = false;

        @Deprecated
        public Builder setFileSizeLimitedTo250Gb(boolean fileSizeLimitedTo250Gb) {
            this.fileSizeLimitedTo250Gb = fileSizeLimitedTo250Gb;
            return this;
        }

        public Builder setUploadBufferSize(int uploadBufferSize) {
            this.uploadBufferSize = uploadBufferSize;
            return this;
        }

        public Builder setDirectUploadEnabled(boolean useDirectUpload) {
            this.useDirectUpload = useDirectUpload;
            return this;
        }

        public AsyncWriteChannelOptions build() {
            return new AsyncWriteChannelOptions(this.fileSizeLimitedTo250Gb, this.uploadBufferSize, this.useDirectUpload);
        }
    }
}

