/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageStatistics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.StorageStatistics;

class GhfsThreadLocalStatistics
extends StorageStatistics {
    static final String NAME = "GhfsThreadLocalStatistics";
    private Map<String, Metric> metrics = new HashMap<String, Metric>();

    GhfsThreadLocalStatistics() {
        super(NAME);
        Arrays.stream(Metric.values()).forEach(x -> this.metrics.put(x.metricName, (Metric)((Object)x)));
    }

    public Long getLong(String s) {
        if (!this.metrics.containsKey(s)) {
            return 0L;
        }
        return this.metrics.get((Object)s).metricValue.getValue();
    }

    public boolean isTracked(String s) {
        return this.metrics.containsKey(s);
    }

    public void reset() {
        for (Metric s : this.metrics.values()) {
            s.reset();
        }
    }

    void increment(GhfsStatistic statistic, long count) {
        if (statistic == GhfsStatistic.GCS_CONNECTOR_TIME) {
            Metric.HADOOP_API_TIME.increment(count);
        } else if (statistic == GhfsStatistic.STREAM_READ_VECTORED_OPERATIONS) {
            Metric.STREAM_READ_VECTORED_COUNT.increment(count);
        } else if (statistic == GhfsStatistic.STREAM_READ_VECTORED_READ_COMBINED_RANGES) {
            Metric.STREAM_READ_VECTORED_RANGE_COUNT.increment(count);
        } else if (statistic.getIsHadoopApi()) {
            Metric.HADOOP_API_COUNT.increment(count);
        }
    }

    void increment(GoogleCloudStorageStatistics op, long count) {
        if (op == GoogleCloudStorageStatistics.GCS_API_TIME) {
            Metric.GCS_API_TIME.increment(count);
        } else if (op == GoogleCloudStorageStatistics.GCS_API_REQUEST_COUNT) {
            Metric.GCS_API_COUNT.increment(count);
        } else if (op == GoogleCloudStorageStatistics.GCS_BACKOFF_COUNT) {
            Metric.BACKOFF_COUNT.increment(count);
        } else if (op == GoogleCloudStorageStatistics.GCS_BACKOFF_TIME) {
            Metric.BACKOFF_TIME.increment(count);
        }
    }

    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return this.metrics.entrySet().stream().map(entry -> new StorageStatistics.LongStatistic((String)entry.getKey(), ((Metric)((Object)((Object)entry.getValue()))).metricValue.getValue().longValue())).iterator();
    }

    private static enum Metric {
        HADOOP_API_COUNT("hadoopApiCount"),
        HADOOP_API_TIME("hadoopApiTime"),
        GCS_API_COUNT("gcsApiCount"),
        GCS_API_TIME("gcsApiTime"),
        BACKOFF_COUNT("backoffCount"),
        BACKOFF_TIME("backoffTime"),
        STREAM_READ_VECTORED_COUNT("readVectoredCount"),
        STREAM_READ_VECTORED_RANGE_COUNT("readVectoredRangeCount");

        private final String metricName;
        private final ThreadLocalValue metricValue;

        private Metric(String metricName) {
            this.metricName = metricName;
            this.metricValue = new ThreadLocalValue();
        }

        void reset() {
            this.metricValue.reset();
        }

        void increment(long count) {
            this.metricValue.increment(count);
        }
    }

    private static class ThreadLocalValue {
        private ThreadLocal<Long> value = ThreadLocal.withInitial(() -> 0L);

        private ThreadLocalValue() {
        }

        void increment(long count) {
            this.value.set(this.value.get() + count);
        }

        Long getValue() {
            return this.value.get();
        }

        void reset() {
            this.value.set(0L);
        }
    }
}

