/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.apache.hadoop.conf.Configurable;

public interface AccessTokenProvider
extends Configurable {
    default public AccessTokenType getAccessTokenType() {
        return AccessTokenType.GENERIC;
    }

    public AccessToken getAccessToken();

    default public AccessToken getAccessToken(List<AccessBoundary> accessBoundaries) {
        throw new UnsupportedOperationException("Downscoped access tokens are not supported");
    }

    public void refresh() throws IOException;

    public static class AccessToken {
        private final String token;
        private final Instant expirationTime;

        public AccessToken(String token, Instant expirationTime) {
            this.token = token;
            this.expirationTime = expirationTime;
        }

        public String getToken() {
            return this.token;
        }

        public Instant getExpirationTime() {
            return this.expirationTime;
        }
    }

    public static enum AccessTokenType {
        GENERIC,
        DOWNSCOPED;

    }
}

