/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.resources;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributeKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributesBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.resources.Resource;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ResourceBuilder {
    private final AttributesBuilder attributesBuilder = Attributes.builder();
    @Nullable
    private String schemaUrl;

    public ResourceBuilder put(String key, String value) {
        if (key != null && value != null) {
            this.attributesBuilder.put(key, value);
        }
        return this;
    }

    public ResourceBuilder put(String key, long value) {
        if (key != null) {
            this.attributesBuilder.put(key, value);
        }
        return this;
    }

    public ResourceBuilder put(String key, double value) {
        if (key != null) {
            this.attributesBuilder.put(key, value);
        }
        return this;
    }

    public ResourceBuilder put(String key, boolean value) {
        if (key != null) {
            this.attributesBuilder.put(key, value);
        }
        return this;
    }

    public ResourceBuilder put(String key, String ... values) {
        if (key != null && values != null) {
            this.attributesBuilder.put(key, values);
        }
        return this;
    }

    public ResourceBuilder put(String key, long ... values) {
        if (key != null && values != null) {
            this.attributesBuilder.put(key, values);
        }
        return this;
    }

    public ResourceBuilder put(String key, double ... values) {
        if (key != null && values != null) {
            this.attributesBuilder.put(key, values);
        }
        return this;
    }

    public ResourceBuilder put(String key, boolean ... values) {
        if (key != null && values != null) {
            this.attributesBuilder.put(key, values);
        }
        return this;
    }

    public <T> ResourceBuilder put(AttributeKey<T> key, T value) {
        if (key != null && key.getKey() != null && !key.getKey().isEmpty() && value != null) {
            this.attributesBuilder.put(key, value);
        }
        return this;
    }

    public ResourceBuilder put(AttributeKey<Long> key, int value) {
        if (key != null && key.getKey() != null && !key.getKey().isEmpty()) {
            this.attributesBuilder.put(key, value);
        }
        return this;
    }

    public ResourceBuilder putAll(Attributes attributes) {
        if (attributes != null) {
            this.attributesBuilder.putAll(attributes);
        }
        return this;
    }

    public ResourceBuilder putAll(Resource resource) {
        if (resource != null) {
            this.attributesBuilder.putAll(resource.getAttributes());
        }
        return this;
    }

    public ResourceBuilder removeIf(Predicate<AttributeKey<?>> filter) {
        this.attributesBuilder.removeIf(filter);
        return this;
    }

    public ResourceBuilder setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    public Resource build() {
        return Resource.create(this.attributesBuilder.build(), this.schemaUrl);
    }
}

