/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.EnvoyServerProtoData;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.client.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.CommonTlsContextUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.ReferenceCountingMap;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.SslContextProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.certprovider.CertProviderClientSslContextProviderFactory;

final class ClientSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderClientSslContextProviderFactory certProviderClientSslContextProviderFactory;

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderClientSslContextProviderFactory.getInstance());
    }

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderClientSslContextProviderFactory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderClientSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
        Preconditions.checkNotNull(upstreamTlsContext.getCommonTlsContext(), "upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(upstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderClientSslContextProviderFactory.getProvider(upstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in UpstreamTlsContext!");
    }
}

