/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.ProtectedPromise;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiFrameProtector;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelException;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.PendingWriteQueue;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TsiFrameHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final Logger logger = Logger.getLogger(TsiFrameHandler.class.getName());
    private TsiFrameProtector protector;
    private PendingWriteQueue pendingUnprotectedWrites;
    private boolean closeInitiated;

    public TsiFrameHandler(TsiFrameProtector protector) {
        this.protector = Preconditions.checkNotNull(protector, "protector");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        assert (this.pendingUnprotectedWrites == null);
        this.pendingUnprotectedWrites = new PendingWriteQueue(Preconditions.checkNotNull(ctx));
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Preconditions.checkState(this.protector != null, "decode() called after close()");
        this.protector.unprotect(in, out, ctx.alloc());
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) {
        if (this.protector == null) {
            promise.setFailure(new IllegalStateException("write() called after close()"));
            return;
        }
        ByteBuf msg = (ByteBuf)message;
        if (!msg.isReadable()) {
            promise.setSuccess();
            return;
        }
        this.pendingUnprotectedWrites.add(msg, promise);
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.destroyProtectorAndWrites();
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.doClose(ctx);
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.doClose(ctx);
        ctx.close(promise);
    }

    private void doClose(ChannelHandlerContext ctx) {
        if (this.closeInitiated) {
            return;
        }
        this.closeInitiated = true;
        try {
            if (!this.pendingUnprotectedWrites.isEmpty()) {
                this.flush(ctx);
            }
        }
        catch (GeneralSecurityException e) {
            logger.log(Level.FINE, "Ignored error on flush before close", e);
        }
        finally {
            this.destroyProtectorAndWrites();
        }
    }

    @Override
    public void flush(final ChannelHandlerContext ctx) throws GeneralSecurityException {
        if (this.pendingUnprotectedWrites == null || this.pendingUnprotectedWrites.isEmpty()) {
            return;
        }
        Preconditions.checkState(this.protector != null, "flush() called after close()");
        final ProtectedPromise aggregatePromise = new ProtectedPromise(ctx.channel(), ctx.executor(), this.pendingUnprotectedWrites.size());
        ArrayList<ByteBuf> bufs = new ArrayList<ByteBuf>(this.pendingUnprotectedWrites.size());
        while (!this.pendingUnprotectedWrites.isEmpty()) {
            ByteBuf in = (ByteBuf)this.pendingUnprotectedWrites.current();
            bufs.add(in.retain());
            aggregatePromise.addUnprotectedPromise(this.pendingUnprotectedWrites.remove());
        }
        final class ProtectedFrameWriteFlusher
        implements TsiFrameProtector.Consumer<ByteBuf> {
            ProtectedFrameWriteFlusher() {
            }

            @Override
            public void accept(ByteBuf byteBuf) {
                ctx.writeAndFlush(byteBuf, aggregatePromise.newPromise());
            }
        }
        this.protector.protectFlush(bufs, new ProtectedFrameWriteFlusher(), ctx.alloc());
        aggregatePromise.doneAllocatingPromises();
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    private void destroyProtectorAndWrites() {
        try {
            if (this.pendingUnprotectedWrites != null && !this.pendingUnprotectedWrites.isEmpty()) {
                this.pendingUnprotectedWrites.removeAndFailAll(new ChannelException("Pending write on teardown of TSI handler"));
            }
        }
        finally {
            this.pendingUnprotectedWrites = null;
        }
        if (this.protector != null) {
            try {
                this.protector.destroy();
            }
            finally {
                this.protector = null;
            }
        }
    }
}

