/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.Distribution;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.LabelDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.Metric;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.MetricDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3.DroppedLabels;
import com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3.SpanContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3.TimeInterval;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Any;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Timestamp;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributeKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.HistogramData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.MetricData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.MetricDataType;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.SumData;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricTranslator {
    private static final Logger logger = LoggerFactory.getLogger(MetricTranslator.class);
    private static final int MIN_TIMESTAMP_INTERVAL_NANOS = 1000000;
    static final String CUSTOM_PREFIX = "custom.googleapis.com";
    static final Set<String> KNOWN_DOMAINS = ImmutableSet.of("googleapis.com", "kubernetes.io", "istio.io", "knative.dev");
    static final long NANO_PER_SECOND = 1000000000L;
    static final String METRIC_DESCRIPTOR_TIME_UNIT = "ns";

    static Metric mapMetric(Attributes attributes, String type) {
        Metric.Builder metricBuilder = Metric.newBuilder().setType(type);
        attributes.forEach((key, value) -> metricBuilder.putLabels(MetricTranslator.cleanAttributeKey(key.getKey()), value.toString()));
        return metricBuilder.build();
    }

    static MetricDescriptor mapMetricDescriptor(String prefix, MetricData metric, PointData metricPoint, Attributes extraLabels) {
        MetricDescriptor.Builder builder = MetricDescriptor.newBuilder().setDisplayName(metric.getName()).setDescription(metric.getDescription()).setType(MetricTranslator.mapMetricType(metric.getName(), prefix)).setUnit(metric.getUnit());
        extraLabels.forEach((key, value) -> builder.addLabels(MetricTranslator.mapAttribute(key, prefix)));
        metricPoint.getAttributes().forEach((key, value) -> builder.addLabels(MetricTranslator.mapAttribute(key, prefix)));
        MetricDataType metricType = metric.getType();
        switch (metricType) {
            case LONG_GAUGE: {
                builder.setMetricKind(MetricDescriptor.MetricKind.GAUGE);
                builder.setValueType(MetricDescriptor.ValueType.INT64);
                return builder.build();
            }
            case DOUBLE_GAUGE: {
                builder.setMetricKind(MetricDescriptor.MetricKind.GAUGE);
                builder.setValueType(MetricDescriptor.ValueType.DOUBLE);
                return builder.build();
            }
            case LONG_SUM: {
                builder.setValueType(MetricDescriptor.ValueType.INT64);
                return MetricTranslator.fillSumType(metric.getLongSumData(), builder);
            }
            case DOUBLE_SUM: {
                builder.setValueType(MetricDescriptor.ValueType.DOUBLE);
                return MetricTranslator.fillSumType(metric.getDoubleSumData(), builder);
            }
            case HISTOGRAM: {
                return MetricTranslator.fillHistogramType(metric.getHistogramData(), builder);
            }
        }
        logger.error("Metric type {} not supported. Only gauge and cumulative types are supported.", (Object)metricType);
        return null;
    }

    static boolean isGauge(MetricData metric) {
        switch (metric.getType()) {
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return true;
            }
            case LONG_SUM: {
                return !metric.getLongSumData().isMonotonic();
            }
            case DOUBLE_SUM: {
                return !metric.getDoubleSumData().isMonotonic();
            }
        }
        return false;
    }

    static TimeInterval mapInterval(PointData point, MetricData metric) {
        Timestamp startTime = MetricTranslator.mapTimestamp(point.getStartEpochNanos());
        Timestamp endTime = MetricTranslator.mapTimestamp(point.getEpochNanos());
        if (MetricTranslator.isGauge(metric)) {
            startTime = endTime;
        } else if (TimeUnit.SECONDS.toNanos(startTime.getSeconds()) + (long)startTime.getNanos() == TimeUnit.SECONDS.toNanos(endTime.getSeconds()) + (long)endTime.getNanos()) {
            endTime = Timestamp.newBuilder().setSeconds(endTime.getSeconds()).setNanos(endTime.getNanos() + 1000000).build();
        }
        return TimeInterval.newBuilder().setStartTime(startTime).setEndTime(endTime).build();
    }

    static Distribution.Builder mapDistribution(HistogramPointData point, String projectId) {
        return Distribution.newBuilder().setCount(point.getCount()).setMean(point.getSum() / (double)point.getCount()).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addAllBounds(point.getBoundaries()))).addAllBucketCounts(point.getCounts()).addAllExemplars(point.getExemplars().stream().map(e -> MetricTranslator.mapExemplar(e, projectId)).collect(Collectors.toList()));
    }

    @VisibleForTesting
    static <T> LabelDescriptor mapAttribute(AttributeKey<T> key, String descriptorTypePrefix) {
        LabelDescriptor.Builder builder = LabelDescriptor.newBuilder().setKey(MetricTranslator.cleanAttributeKey(key.getKey()));
        if (descriptorTypePrefix.equals(CUSTOM_PREFIX)) {
            switch (key.getType()) {
                case BOOLEAN: {
                    builder.setValueType(LabelDescriptor.ValueType.BOOL);
                    break;
                }
                case LONG: {
                    builder.setValueType(LabelDescriptor.ValueType.INT64);
                    break;
                }
                default: {
                    builder.setValueType(LabelDescriptor.ValueType.STRING);
                    break;
                }
            }
        } else {
            builder.setValueType(LabelDescriptor.ValueType.STRING);
        }
        return builder.build();
    }

    private static String cleanAttributeKey(String key) {
        return key.replace('.', '_');
    }

    private static Timestamp mapTimestamp(long epochNanos) {
        return Timestamp.newBuilder().setSeconds(epochNanos / 1000000000L).setNanos((int)(epochNanos % 1000000000L)).build();
    }

    private static MetricDescriptor fillHistogramType(HistogramData histogram, MetricDescriptor.Builder builder) {
        builder.setValueType(MetricDescriptor.ValueType.DISTRIBUTION);
        switch (histogram.getAggregationTemporality()) {
            case CUMULATIVE: {
                builder.setMetricKind(MetricDescriptor.MetricKind.CUMULATIVE);
                return builder.build();
            }
        }
        logger.error("Histogram type {} not supported. Only cumulative types are supported.", (Object)histogram);
        return null;
    }

    private static MetricDescriptor fillSumType(SumData<?> sum, MetricDescriptor.Builder builder) {
        if (!sum.isMonotonic()) {
            builder.setMetricKind(MetricDescriptor.MetricKind.GAUGE);
            return builder.build();
        }
        switch (sum.getAggregationTemporality()) {
            case CUMULATIVE: {
                builder.setMetricKind(MetricDescriptor.MetricKind.CUMULATIVE);
                return builder.build();
            }
        }
        logger.error("Sum type {} not supported. Only cumulative types are supported.", sum);
        return null;
    }

    private static String mapMetricType(String instrumentName, String prefix) {
        for (String domain : KNOWN_DOMAINS) {
            if (!instrumentName.contains(domain)) continue;
            return instrumentName;
        }
        return String.join((CharSequence)"/", prefix, instrumentName);
    }

    private static Distribution.Exemplar mapExemplar(ExemplarData exemplar, String projectId) {
        double value = 0.0;
        if (exemplar instanceof DoubleExemplarData) {
            value = ((DoubleExemplarData)exemplar).getValue();
        } else if (exemplar instanceof LongExemplarData) {
            value = ((LongExemplarData)exemplar).getValue();
        }
        Distribution.Exemplar.Builder exemplarBuilder = Distribution.Exemplar.newBuilder().setValue(value).setTimestamp(MetricTranslator.mapTimestamp(exemplar.getEpochNanos()));
        if (exemplar.getSpanContext().isValid()) {
            exemplarBuilder.addAttachments(Any.pack(SpanContext.newBuilder().setSpanName(MetricTranslator.makeSpanName(projectId, exemplar.getSpanContext().getTraceId(), exemplar.getSpanContext().getSpanId())).build()));
        }
        if (!exemplar.getFilteredAttributes().isEmpty()) {
            exemplarBuilder.addAttachments(Any.pack(MetricTranslator.mapFilteredAttributes(exemplar.getFilteredAttributes())));
        }
        return exemplarBuilder.build();
    }

    private static String makeSpanName(String projectId, String traceId, String spanId) {
        return String.format("projects/%s/traces/%s/spans/%s", projectId, traceId, spanId);
    }

    private static DroppedLabels mapFilteredAttributes(Attributes attributes) {
        DroppedLabels.Builder labels = DroppedLabels.newBuilder();
        attributes.forEach((k, v) -> labels.putLabel(MetricTranslator.cleanAttributeKey(k.getKey()), v.toString()));
        return labels.build();
    }
}

