/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.MetricDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.MetricTimeSeriesBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.MetricTranslator;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.MetricWithLabels;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.ResourceTranslator;
import com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3.Point;
import com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3.TimeSeries;
import com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3.TypedValue;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributeKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributesBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.DoublePointData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.LongPointData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.MetricData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class AggregateByLabelMetricTimeSeriesBuilder
implements MetricTimeSeriesBuilder {
    public static final String LABEL_INSTRUMENTATION_SOURCE = "instrumentation_source";
    public static final String LABEL_INSTRUMENTATION_VERSION = "instrumentation_version";
    private final Map<String, MetricDescriptor> descriptors = new HashMap<String, MetricDescriptor>();
    private final Map<MetricWithLabels, TimeSeries.Builder> pendingTimeSeries = new HashMap<MetricWithLabels, TimeSeries.Builder>();
    private final String projectId;
    private final String prefix;
    private final Predicate<AttributeKey<?>> resourceAttributeFilter;
    private final MonitoredResourceDescription monitoredResourceDescription;
    private final boolean instrumentationLibraryLabelsEnabled;

    @Deprecated
    public AggregateByLabelMetricTimeSeriesBuilder(String projectId, String prefix) {
        this.projectId = projectId;
        this.prefix = prefix;
        this.resourceAttributeFilter = MetricConfiguration.NO_RESOURCE_ATTRIBUTES;
        this.monitoredResourceDescription = MetricConfiguration.EMPTY_MONITORED_RESOURCE_DESCRIPTION;
        this.instrumentationLibraryLabelsEnabled = true;
    }

    @Deprecated
    public AggregateByLabelMetricTimeSeriesBuilder(String projectId, String prefix, Predicate<AttributeKey<?>> resourceAttributeFilter) {
        this.projectId = projectId;
        this.prefix = prefix;
        this.resourceAttributeFilter = resourceAttributeFilter;
        this.monitoredResourceDescription = MetricConfiguration.EMPTY_MONITORED_RESOURCE_DESCRIPTION;
        this.instrumentationLibraryLabelsEnabled = true;
    }

    @Deprecated
    public AggregateByLabelMetricTimeSeriesBuilder(String projectId, String prefix, Predicate<AttributeKey<?>> resourceAttributeFilter, MonitoredResourceDescription monitoredResourceDescription) {
        this.projectId = projectId;
        this.prefix = prefix;
        this.resourceAttributeFilter = resourceAttributeFilter;
        this.monitoredResourceDescription = monitoredResourceDescription;
        this.instrumentationLibraryLabelsEnabled = true;
    }

    public AggregateByLabelMetricTimeSeriesBuilder(String projectId, String prefix, Predicate<AttributeKey<?>> resourceAttributeFilter, MonitoredResourceDescription monitoredResourceDescription, boolean instrumentationLibraryLabelsEnabled) {
        this.projectId = projectId;
        this.prefix = prefix;
        this.resourceAttributeFilter = resourceAttributeFilter;
        this.monitoredResourceDescription = monitoredResourceDescription;
        this.instrumentationLibraryLabelsEnabled = instrumentationLibraryLabelsEnabled;
    }

    @Override
    public void recordPoint(MetricData metricData, LongPointData pointData) {
        this.recordPointInTimeSeries(metricData, pointData, Point.newBuilder().setValue(TypedValue.newBuilder().setInt64Value(pointData.getValue())).setInterval(MetricTranslator.mapInterval(pointData, metricData)).build());
    }

    @Override
    public void recordPoint(MetricData metricData, DoublePointData pointData) {
        this.recordPointInTimeSeries(metricData, pointData, Point.newBuilder().setValue(TypedValue.newBuilder().setDoubleValue(pointData.getValue())).setInterval(MetricTranslator.mapInterval(pointData, metricData)).build());
    }

    @Override
    public void recordPoint(MetricData metricData, HistogramPointData pointData) {
        this.recordPointInTimeSeries(metricData, pointData, Point.newBuilder().setValue(TypedValue.newBuilder().setDistributionValue(MetricTranslator.mapDistribution(pointData, this.projectId))).setInterval(MetricTranslator.mapInterval(pointData, metricData)).build());
    }

    private void recordPointInTimeSeries(MetricData metric, PointData point, Point builtPoint) {
        MetricDescriptor descriptor = MetricTranslator.mapMetricDescriptor(this.prefix, metric, point, this.extraLabelsFromResource(metric.getResource()));
        if (descriptor == null) {
            return;
        }
        this.descriptors.putIfAbsent(descriptor.getType(), descriptor);
        Attributes metricAttributes = Attributes.builder().putAll(this.instrumentationLibraryLabels(point.getAttributes(), metric.getInstrumentationScopeInfo())).putAll(this.extraLabelsFromResource(metric.getResource())).build();
        MetricWithLabels key = new MetricWithLabels(descriptor.getType(), metricAttributes);
        this.pendingTimeSeries.computeIfAbsent(key, k -> this.makeTimeSeriesHeader(metric, metricAttributes, descriptor)).addPoints(builtPoint);
    }

    private TimeSeries.Builder makeTimeSeriesHeader(MetricData metric, Attributes attributes, MetricDescriptor descriptor) {
        return TimeSeries.newBuilder().setMetric(MetricTranslator.mapMetric(attributes, descriptor.getType())).setMetricKind(descriptor.getMetricKind()).setResource(ResourceTranslator.mapResource(metric.getResource(), this.monitoredResourceDescription));
    }

    private Attributes extraLabelsFromResource(Resource resource) {
        AttributesBuilder attrBuilder = resource.getAttributes().toBuilder();
        attrBuilder.removeIf(this.resourceAttributeFilter.negate());
        return attrBuilder.build();
    }

    private Attributes instrumentationLibraryLabels(Attributes attributes, InstrumentationScopeInfo instrumentationScopeInfo) {
        if (!this.instrumentationLibraryLabelsEnabled) {
            return attributes;
        }
        return attributes.toBuilder().put(AttributeKey.stringKey(LABEL_INSTRUMENTATION_SOURCE), instrumentationScopeInfo.getName()).put(AttributeKey.stringKey(LABEL_INSTRUMENTATION_VERSION), Optional.ofNullable(instrumentationScopeInfo.getVersion()).orElse("")).build();
    }

    @Override
    public Collection<MetricDescriptor> getDescriptors() {
        return this.descriptors.values();
    }

    @Override
    public List<TimeSeries> getTimeSeries() {
        return this.pendingTimeSeries.values().stream().map(TimeSeries.Builder::build).collect(Collectors.toList());
    }
}

