/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.detection;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.detection.EnvironmentVariables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class GoogleServerlessCompute
implements DetectedPlatform {
    private final EnvironmentVariables environmentVariables;
    private final GCPMetadataConfig metadataConfig;
    private final Map<String, String> availableAttributes;

    GoogleServerlessCompute(EnvironmentVariables environmentVariables, GCPMetadataConfig metadataConfig) {
        this.environmentVariables = environmentVariables;
        this.metadataConfig = metadataConfig;
        this.availableAttributes = this.prepareAttributes();
    }

    private Map<String, String> prepareAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("serverless_compute_name", this.environmentVariables.get("K_SERVICE"));
        map.put("serverless_compute_revision", this.environmentVariables.get("K_REVISION"));
        map.put("availability_zone", this.metadataConfig.getZone());
        map.put("cloud_region", this.metadataConfig.getRegionFromZone());
        map.put("instance_id", this.metadataConfig.getInstanceId());
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String getProjectId() {
        return this.metadataConfig.getProjectId();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.availableAttributes;
    }
}

