/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.extensions.appengine.http;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.LowLevelHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;

final class UrlFetchResponse
extends LowLevelHttpResponse {
    private final ArrayList<String> headerNames = new ArrayList();
    private final ArrayList<String> headerValues = new ArrayList();
    private final HTTPResponse fetchResponse;
    private String contentEncoding;
    private String contentType;
    private long contentLength;

    UrlFetchResponse(HTTPResponse fetchResponse) {
        this.fetchResponse = fetchResponse;
        for (HTTPHeader header : fetchResponse.getHeadersUncombined()) {
            String name = header.getName();
            String value = header.getValue();
            if (name == null || value == null) continue;
            this.headerNames.add(name);
            this.headerValues.add(value);
            if ("content-type".equalsIgnoreCase(name)) {
                this.contentType = value;
                continue;
            }
            if ("content-encoding".equalsIgnoreCase(name)) {
                this.contentEncoding = value;
                continue;
            }
            if (!"content-length".equalsIgnoreCase(name)) continue;
            try {
                this.contentLength = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public int getStatusCode() {
        return this.fetchResponse.getResponseCode();
    }

    @Override
    public InputStream getContent() {
        byte[] content = this.fetchResponse.getContent();
        return content == null ? null : new ByteArrayInputStream(content);
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getReasonPhrase() {
        return null;
    }

    @Override
    public String getStatusLine() {
        return null;
    }

    @Override
    public int getHeaderCount() {
        return this.headerNames.size();
    }

    @Override
    public String getHeaderName(int index) {
        return this.headerNames.get(index);
    }

    @Override
    public String getHeaderValue(int index) {
        return this.headerValues.get(index);
    }
}

