/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsGlobalStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsInputStreamStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStreamStats;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.VectoredIOImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ITraceFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.functional.CallableRaisingIOE;

class GoogleHadoopFSInputStream
extends FSInputStream
implements IOStatisticsSource {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final byte[] singleReadBuf = new byte[1];
    private final URI gcsPath;
    private final FileInfo fileInfo;
    private final SeekableByteChannel channel;
    private long totalBytesRead = 0L;
    private volatile boolean closed;
    private final ITraceFactory traceFactory;
    private final FileSystem.Statistics statistics;
    private final GhfsGlobalStorageStatistics storageStatistics;
    private final GhfsStreamStats streamStats;
    private final GhfsStreamStats seekStreamStats;
    private final GhfsStreamStats vectoredReadStats;
    private final GhfsInputStreamStatistics streamStatistics;
    private final Supplier<VectoredIOImpl> vectoredIOSupplier;
    private final GoogleCloudStorageFileSystem gcsFs;

    static GoogleHadoopFSInputStream create(GoogleHadoopFileSystem ghfs, URI gcsPath, FileSystem.Statistics statistics) throws IOException {
        SeekableByteChannel channel;
        ((GoogleLogger.Api)logger.atFiner()).log("create(gcsPath: %s)", gcsPath);
        GoogleCloudStorageFileSystem gcsFs = ghfs.getGcsFs();
        FileInfo fileInfo = null;
        if (GoogleHadoopFSInputStream.shouldPreFetchFileInfo(gcsFs.getOptions())) {
            fileInfo = gcsFs.getFileInfoObject(gcsPath);
            channel = gcsFs.open(fileInfo, gcsFs.getOptions().getCloudStorageOptions().getReadChannelOptions());
        } else {
            channel = gcsFs.open(gcsPath, gcsFs.getOptions().getCloudStorageOptions().getReadChannelOptions());
        }
        return new GoogleHadoopFSInputStream(ghfs, gcsPath, fileInfo, channel, statistics);
    }

    private static boolean shouldPreFetchFileInfo(GoogleCloudStorageFileSystemOptions gcsFSOptions) {
        return gcsFSOptions.getClientType() == GoogleCloudStorageFileSystemOptions.ClientType.STORAGE_CLIENT || gcsFSOptions.getCloudStorageOptions().getReadChannelOptions().isFastFailOnNotFoundEnabled();
    }

    static GoogleHadoopFSInputStream create(GoogleHadoopFileSystem ghfs, FileInfo fileInfo, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(fileInfo: %s)", fileInfo);
        GoogleCloudStorageFileSystem gcsFs = ghfs.getGcsFs();
        SeekableByteChannel channel = gcsFs.open(fileInfo, gcsFs.getOptions().getCloudStorageOptions().getReadChannelOptions());
        return new GoogleHadoopFSInputStream(ghfs, fileInfo.getPath(), fileInfo, channel, statistics);
    }

    private GoogleHadoopFSInputStream(GoogleHadoopFileSystem ghfs, URI gcsPath, FileInfo fileInfo, SeekableByteChannel channel, FileSystem.Statistics statistics) {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopFSInputStream(gcsPath: %s)", gcsPath);
        this.gcsPath = gcsPath;
        this.channel = channel;
        this.fileInfo = fileInfo;
        this.gcsFs = ghfs.getGcsFs();
        this.statistics = statistics;
        this.storageStatistics = ghfs.getGlobalGcsStorageStatistics();
        this.streamStatistics = ghfs.getInstrumentation().newInputStreamStatistics(statistics);
        this.streamStats = new GhfsStreamStats(this.storageStatistics, GhfsStatistic.STREAM_READ_OPERATIONS, gcsPath);
        this.seekStreamStats = new GhfsStreamStats(this.storageStatistics, GhfsStatistic.STREAM_READ_SEEK_OPERATIONS, gcsPath);
        this.vectoredReadStats = new GhfsStreamStats(this.storageStatistics, GhfsStatistic.STREAM_READ_VECTORED_OPERATIONS, gcsPath);
        this.traceFactory = ghfs.getTraceFactory();
        this.vectoredIOSupplier = ghfs.getVectoredIOSupplier();
    }

    public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate) throws IOException {
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_READ_VECTORED_OPERATIONS.getSymbol(), () -> {
            long startTimeNs = System.nanoTime();
            this.vectoredIOSupplier.get().readVectored(ranges, allocate, this.gcsFs, this.fileInfo, this.gcsPath, this.streamStatistics);
            this.statistics.incrementReadOps(1);
            this.vectoredReadStats.updateVectoredReadStreamStats(startTimeNs);
            return null;
        });
    }

    public synchronized int read() throws IOException {
        this.checkNotClosed();
        int numRead = this.read(this.singleReadBuf, 0, 1);
        Preconditions.checkState(numRead == -1 || numRead == 1, "Read %s bytes using single-byte buffer for path %s ending in position %s", (Object)numRead, (Object)this.gcsPath, (Object)this.channel.position());
        return numRead > 0 ? this.singleReadBuf[0] & 0xFF : numRead;
    }

    public synchronized int read(@Nonnull byte[] buf, int offset, int length) throws IOException {
        return (Integer)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_READ_OPERATIONS.getSymbol(), () -> {
            long startTimeNs = System.nanoTime();
            this.checkNotClosed();
            Preconditions.checkNotNull(buf, "buf must not be null");
            if (offset < 0 || length < 0 || length > buf.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            int response = 0;
            try {
                int numRead = this.channel.read(ByteBuffer.wrap(buf, offset, length));
                if (numRead > 0) {
                    this.totalBytesRead += (long)numRead;
                    this.statistics.incrementReadOps(1);
                    this.streamStats.updateReadStreamStats(numRead, startTimeNs);
                }
                this.storageStatistics.streamReadOperationInComplete(length, Math.max(numRead, 0));
                response = numRead;
            }
            catch (IOException e) {
                this.streamStatistics.readException();
                throw e;
            }
            this.streamStatistics.bytesRead(Math.max(response, 0));
            this.streamStatistics.readOperationCompleted(length, Math.max(response, 0));
            return response;
        });
    }

    public synchronized void seek(long pos) throws IOException {
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.streamStatistics, (String)GhfsStatistic.STREAM_READ_SEEK_OPERATIONS.getSymbol(), () -> {
            long startTimeNs = System.nanoTime();
            this.checkNotClosed();
            ((GoogleLogger.Api)logger.atFiner()).log("seek(%d)", pos);
            long curPos = this.getPos();
            long diff = pos - curPos;
            if (diff > 0L) {
                this.streamStatistics.seekForwards(diff);
                this.storageStatistics.streamReadSeekForward(diff);
            } else {
                this.streamStatistics.seekBackwards(diff);
                this.storageStatistics.streamReadSeekBackward(diff);
            }
            try {
                this.channel.position(pos);
            }
            catch (IllegalArgumentException e) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException(e);
            }
            this.seekStreamStats.updateReadStreamSeekStats(startTimeNs);
            return null;
        });
    }

    public synchronized void close() throws IOException {
        boolean isClosed = this.closed;
        this.trackDurationWithTracing(this.streamStatistics, this.storageStatistics, GhfsStatistic.STREAM_READ_CLOSE_OPERATIONS, this.gcsPath, this.traceFactory, () -> {
            if (!this.closed) {
                this.closed = true;
                try {
                    ((GoogleLogger.Api)logger.atFiner()).log("close(): %s", this.gcsPath);
                    try {
                        if (this.channel != null) {
                            ((GoogleLogger.Api)logger.atFiner()).log("Closing '%s' file with %d total bytes read", (Object)this.gcsPath, this.totalBytesRead);
                            this.channel.close();
                        }
                    }
                    catch (Exception e) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error while closing underneath read channel resources for path: %s", this.gcsPath);
                    }
                }
                finally {
                    this.statistics.incrementBytesRead(this.streamStatistics.getBytesRead());
                    this.streamStats.close();
                    this.seekStreamStats.close();
                    this.vectoredReadStats.close();
                }
            }
            return null;
        });
        if (!isClosed) {
            this.streamStatistics.close();
        }
    }

    private <B> B trackDurationWithTracing(DurationTrackerFactory durationTracker, @Nonnull GhfsGlobalStorageStatistics stats, GhfsStatistic statistic, Object context, ITraceFactory traceFactory, CallableRaisingIOE<B> operation) throws IOException {
        return GhfsGlobalStorageStatistics.trackDuration(durationTracker, stats, statistic, context, traceFactory, operation);
    }

    public synchronized long getPos() throws IOException {
        this.checkNotClosed();
        long pos = this.channel.position();
        ((GoogleLogger.Api)logger.atFiner()).log("getPos(): %d", pos);
        return pos;
    }

    public boolean seekToNewSource(long targetPos) {
        ((GoogleLogger.Api)logger.atFiner()).log("seekToNewSource(%d): false", targetPos);
        return false;
    }

    public int available() throws IOException {
        if (!this.channel.isOpen()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new ClosedChannelException();
        }
        return super.available();
    }

    public IOStatistics getIOStatistics() {
        return this.streamStatistics.getIOStatistics();
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(this.gcsPath + ": Stream is closed!");
        }
    }
}

