/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.common.base.$Strings;
import autovalue.shaded.com.google$.common.base.$Throwables;
import autovalue.shaded.com.google$.common.collect.$BiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableListMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$Sets;
import autovalue.shaded.net.ltgt.gradle.incap$.$IncrementalAnnotationProcessorType;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.processor.AutoValueOrOneOfProcessor;
import com.google.auto.value.processor.AutoValueTemplateVars;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.ExtensionContext;
import com.google.auto.value.processor.GwtCompatibility;
import com.google.auto.value.processor.GwtSerialization;
import com.google.auto.value.processor.Reformatter;
import com.google.auto.value.processor.SimpleMethod;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"com.google.auto.value.AutoValue"})
public class AutoValueProcessor
extends AutoValueOrOneOfProcessor {
    private static final String OMIT_IDENTIFIERS_OPTION = "com.google.auto.value.OmitIdentifiers";
    private static final String OLD_MEMOIZE_EXTENSION = "com.google.auto.value.extension.memoized.MemoizeExtension";
    private $ImmutableList<AutoValueExtension> extensions;
    private final ClassLoader loaderForExtensions;

    public AutoValueProcessor() {
        this(AutoValueProcessor.class.getClassLoader());
    }

    @google..VisibleForTesting
    AutoValueProcessor(ClassLoader loaderForExtensions) {
        super("com.google.auto.value.AutoValue");
        this.extensions = null;
        this.loaderForExtensions = loaderForExtensions;
    }

    @google..VisibleForTesting
    public AutoValueProcessor(Iterable<? extends AutoValueExtension> extensions) {
        super("com.google.auto.value.AutoValue");
        this.extensions = $ImmutableList.copyOf(extensions);
        this.loaderForExtensions = null;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (this.extensions == null) {
            try {
                ServiceLoader<AutoValueExtension> serviceLoader = ServiceLoader.load(AutoValueExtension.class, this.loaderForExtensions);
                this.extensions = $ImmutableList.copyOf($Iterables.filter(serviceLoader, ext -> !ext.getClass().getName().equals(OLD_MEMOIZE_EXTENSION)));
            }
            catch (Throwable t) {
                StringBuilder warning = new StringBuilder();
                warning.append("An exception occurred while looking for AutoValue extensions. No extensions will function.");
                if (t instanceof ServiceConfigurationError) {
                    warning.append(" This may be due to a corrupt jar file in the compiler's classpath.");
                }
                warning.append("\n").append($Throwables.getStackTraceAsString(t));
                this.errorReporter().reportWarning(warning.toString(), null);
                this.extensions = $ImmutableList.of();
            }
        }
    }

    @Override
    public Set<String> getSupportedOptions() {
        $ImmutableSet.Builder builder = $ImmutableSet.builder();
        AutoValueExtension.IncrementalExtensionType incrementalType = this.extensions.stream().map(e -> e.incrementalType(this.processingEnv)).min(Comparator.naturalOrder()).orElse(AutoValueExtension.IncrementalExtensionType.ISOLATING);
        (($ImmutableSet.Builder)builder.add(OMIT_IDENTIFIERS_OPTION)).addAll(AutoValueProcessor.optionsFor(incrementalType));
        for (AutoValueExtension extension : this.extensions) {
            builder.addAll(extension.getSupportedOptions());
        }
        return builder.build();
    }

    private static $ImmutableSet<String> optionsFor(AutoValueExtension.IncrementalExtensionType incrementalType) {
        switch (incrementalType) {
            case ISOLATING: {
                return $ImmutableSet.of($IncrementalAnnotationProcessorType.ISOLATING.getProcessorOption());
            }
            case AGGREGATING: {
                return $ImmutableSet.of($IncrementalAnnotationProcessorType.AGGREGATING.getProcessorOption());
            }
            case UNKNOWN: {
                return $ImmutableSet.of();
            }
        }
        throw new AssertionError((Object)incrementalType);
    }

    private static String generatedSubclassName(TypeElement type, int depth) {
        return AutoValueProcessor.generatedClassName(type, $Strings.repeat("$", depth) + "AutoValue_");
    }

    @Override
    void processType(TypeElement type) {
        if (!AutoValueProcessor.hasAnnotationMirror(type, "com.google.auto.value.AutoValue")) {
            this.errorReporter().abortWithError("annotation processor for @AutoValue was invoked with a type that does not have that annotation; this is probably a compiler bug", type);
        }
        if (type.getKind() != ElementKind.CLASS) {
            this.errorReporter().abortWithError("@AutoValue only applies to classes", type);
        }
        if (this.ancestorIsAutoValue(type)) {
            this.errorReporter().abortWithError("One @AutoValue class may not extend another", type);
        }
        if (this.implementsAnnotation(type)) {
            this.errorReporter().abortWithError("@AutoValue may not be used to implement an annotation interface; try using @AutoAnnotation instead", type);
        }
        this.checkModifiersIfNested(type);
        $ImmutableSet<ExecutableElement> methods = $MoreElements.getLocalAndInheritedMethods(type, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        $ImmutableSet<ExecutableElement> abstractMethods = AutoValueProcessor.abstractMethodsIn(methods);
        BuilderSpec builderSpec = new BuilderSpec(type, this.processingEnv, this.errorReporter());
        Optional<BuilderSpec.Builder> builder = builderSpec.getBuilder();
        $ImmutableSet<ExecutableElement> toBuilderMethods = builder.isPresent() ? builder.get().toBuilderMethods(this.typeUtils(), abstractMethods) : $ImmutableSet.of();
        $ImmutableSet<ExecutableElement> propertyMethods = AutoValueProcessor.propertyMethodsIn(AutoValueProcessor.immutableSetDifference(abstractMethods, toBuilderMethods));
        $ImmutableBiMap<String, ExecutableElement> properties = this.propertyNameToMethodMap(propertyMethods);
        ExtensionContext context = new ExtensionContext(this.processingEnv, type, properties, abstractMethods);
        $ImmutableList<AutoValueExtension> applicableExtensions = this.applicableExtensions(type, context);
        $ImmutableSet<ExecutableElement> consumedMethods = this.methodsConsumedByExtensions(type, applicableExtensions, context, abstractMethods, properties);
        if (!consumedMethods.isEmpty()) {
            $ImmutableSet<ExecutableElement> allAbstractMethods = abstractMethods;
            abstractMethods = AutoValueProcessor.immutableSetDifference(abstractMethods, consumedMethods);
            toBuilderMethods = AutoValueProcessor.immutableSetDifference(toBuilderMethods, consumedMethods);
            propertyMethods = AutoValueProcessor.propertyMethodsIn(AutoValueProcessor.immutableSetDifference(abstractMethods, toBuilderMethods));
            properties = this.propertyNameToMethodMap(propertyMethods);
            context = new ExtensionContext(this.processingEnv, type, properties, allAbstractMethods);
        }
        boolean extensionsPresent = !applicableExtensions.isEmpty();
        this.validateMethods(type, abstractMethods, toBuilderMethods, propertyMethods, extensionsPresent);
        String finalSubclass = AutoValueProcessor.generatedSubclassName(type, 0);
        AutoValueTemplateVars vars = new AutoValueTemplateVars();
        vars.finalSubclass = TypeSimplifier.simpleNameOf(finalSubclass);
        vars.types = this.processingEnv.getTypeUtils();
        vars.identifiers = !this.processingEnv.getOptions().containsKey(OMIT_IDENTIFIERS_OPTION);
        this.defineSharedVarsForType(type, methods, vars);
        this.defineVarsForType(type, vars, toBuilderMethods, propertyMethods, builder);
        GwtCompatibility gwtCompatibility = new GwtCompatibility(type);
        vars.gwtCompatibleAnnotation = gwtCompatibility.gwtCompatibleAnnotationString();
        int subclassDepth = this.writeExtensions(type, context, applicableExtensions);
        String subclass = AutoValueProcessor.generatedSubclassName(type, subclassDepth);
        vars.subclass = TypeSimplifier.simpleNameOf(subclass);
        vars.isFinal = subclassDepth == 0;
        vars.modifiers = vars.isFinal != false ? "final " : "abstract ";
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, type.asType());
        text = Reformatter.fixup(text);
        this.writeSourceFile(subclass, text, type);
        GwtSerialization gwtSerialization = new GwtSerialization(gwtCompatibility, this.processingEnv, type);
        gwtSerialization.maybeWriteGwtSerializer(vars);
    }

    private int writeExtensions(TypeElement type, ExtensionContext context, $ImmutableList<AutoValueExtension> applicableExtensions) {
        int writtenSoFar = 0;
        for (AutoValueExtension extension : applicableExtensions) {
            boolean isFinal;
            String parentFqName = AutoValueProcessor.generatedSubclassName(type, writtenSoFar + 1);
            String parentSimpleName = TypeSimplifier.simpleNameOf(parentFqName);
            String classFqName = AutoValueProcessor.generatedSubclassName(type, writtenSoFar);
            String classSimpleName = TypeSimplifier.simpleNameOf(classFqName);
            String source = extension.generateClass(context, classSimpleName, parentSimpleName, isFinal = writtenSoFar == 0);
            if (source == null) continue;
            source = Reformatter.fixup(source);
            this.writeSourceFile(classFqName, source, type);
            ++writtenSoFar;
        }
        return writtenSoFar;
    }

    private $ImmutableList<AutoValueExtension> applicableExtensions(TypeElement type, ExtensionContext context) {
        ArrayList<AutoValueExtension> applicableExtensions = new ArrayList<AutoValueExtension>();
        ArrayList<AutoValueExtension> finalExtensions = new ArrayList<AutoValueExtension>();
        for (AutoValueExtension extension : this.extensions) {
            if (!extension.applicable(context)) continue;
            if (extension.mustBeFinal(context)) {
                finalExtensions.add(extension);
                continue;
            }
            applicableExtensions.add(extension);
        }
        switch (finalExtensions.size()) {
            case 0: {
                break;
            }
            case 1: {
                applicableExtensions.add(0, (AutoValueExtension)finalExtensions.get(0));
                break;
            }
            default: {
                this.errorReporter().reportError("More than one extension wants to generate the final class: " + finalExtensions.stream().map(this::extensionName).collect(Collectors.joining(", ")), type);
            }
        }
        return $ImmutableList.copyOf(applicableExtensions);
    }

    private $ImmutableSet<ExecutableElement> methodsConsumedByExtensions(TypeElement type, $ImmutableList<AutoValueExtension> applicableExtensions, ExtensionContext context, $ImmutableSet<ExecutableElement> abstractMethods, $ImmutableBiMap<String, ExecutableElement> properties) {
        HashSet consumed = new HashSet();
        for (AutoValueExtension extension : applicableExtensions) {
            HashSet<ExecutableElement> consumedHere = new HashSet<ExecutableElement>();
            for (String consumedProperty : extension.consumeProperties(context)) {
                ExecutableElement propertyMethod = (ExecutableElement)properties.get(consumedProperty);
                if (propertyMethod == null) {
                    this.errorReporter().reportError("Extension " + this.extensionName(extension) + " wants to consume a property that does not exist: " + consumedProperty, type);
                    continue;
                }
                consumedHere.add(propertyMethod);
            }
            for (ExecutableElement consumedMethod : extension.consumeMethods(context)) {
                if (!abstractMethods.contains(consumedMethod)) {
                    this.errorReporter().reportError("Extension " + this.extensionName(extension) + " wants to consume a method that is not one of the abstract methods in this class: " + consumedMethod, type);
                    continue;
                }
                consumedHere.add(consumedMethod);
            }
            for (ExecutableElement repeat : $Sets.intersection(consumed, consumedHere)) {
                this.errorReporter().reportError("Extension " + this.extensionName(extension) + " wants to consume a method that was already consumed by another extension", repeat);
            }
            consumed.addAll(consumedHere);
        }
        return $ImmutableSet.copyOf(consumed);
    }

    private void validateMethods(TypeElement type, $ImmutableSet<ExecutableElement> abstractMethods, $ImmutableSet<ExecutableElement> toBuilderMethods, $ImmutableSet<ExecutableElement> propertyMethods, boolean extensionsPresent) {
        for (ExecutableElement method : abstractMethods) {
            if (propertyMethods.contains(method)) {
                this.checkReturnType(type, method);
                continue;
            }
            if (toBuilderMethods.contains(method) || AutoValueProcessor.objectMethodToOverride(method) != AutoValueOrOneOfProcessor.ObjectMethod.NONE) continue;
            String message = "Abstract method is neither a property getter nor a Builder converter";
            if (extensionsPresent) {
                message = message + ", and no extension consumed it";
            }
            this.errorReporter().reportWarning(message, method);
        }
        this.errorReporter().abortIfAnyError();
    }

    private String extensionName(AutoValueExtension extension) {
        return extension.getClass().getName();
    }

    private void defineVarsForType(TypeElement type, AutoValueTemplateVars vars, $ImmutableSet<ExecutableElement> toBuilderMethods, $ImmutableSet<ExecutableElement> propertyMethods, Optional<BuilderSpec.Builder> builder) {
        vars.toBuilderMethods = $ImmutableList.copyOf(toBuilderMethods.stream().map(SimpleMethod::new).collect(Collectors.toList()));
        $ImmutableListMultimap<ExecutableElement, AnnotationMirror> annotatedPropertyFields = this.propertyFieldAnnotationMap(type, propertyMethods);
        $ImmutableListMultimap<ExecutableElement, AnnotationMirror> annotatedPropertyMethods = this.propertyMethodAnnotationMap(type, propertyMethods);
        vars.props = this.propertySet(type, propertyMethods, annotatedPropertyFields, annotatedPropertyMethods);
        vars.serialVersionUID = this.getSerialVersionUID(type);
        if (builder.isPresent()) {
            $BiMap methodToPropertyName = this.propertyNameToMethodMap(propertyMethods).inverse();
            builder.get().defineVars(vars, ($ImmutableBiMap<ExecutableElement, String>)methodToPropertyName);
        }
    }

    @Override
    Optional<String> nullableAnnotationForMethod(ExecutableElement propertyMethod) {
        return AutoValueProcessor.nullableAnnotationFor(propertyMethod, propertyMethod.getReturnType());
    }

    static $ImmutableSet<ExecutableElement> prefixedGettersIn(Iterable<ExecutableElement> methods) {
        $ImmutableSet.Builder getters = $ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            boolean is;
            String name = method.getSimpleName().toString();
            boolean get = name.startsWith("get") && !name.equals("get");
            boolean bl = is = name.startsWith("is") && !name.equals("is") && method.getReturnType().getKind() == TypeKind.BOOLEAN;
            if (!get && !is) continue;
            getters.add(method);
        }
        return getters.build();
    }

    private boolean ancestorIsAutoValue(TypeElement type) {
        TypeMirror parentMirror;
        while ((parentMirror = type.getSuperclass()).getKind() != TypeKind.NONE) {
            TypeElement parentElement = (TypeElement)this.typeUtils().asElement(parentMirror);
            if (AutoValueProcessor.hasAnnotationMirror(parentElement, "com.google.auto.value.AutoValue")) {
                return true;
            }
            type = parentElement;
        }
        return false;
    }

    private boolean implementsAnnotation(TypeElement type) {
        return this.typeUtils().isAssignable(type.asType(), this.getTypeMirror(Annotation.class));
    }

    private TypeMirror getTypeMirror(Class<?> c) {
        return this.processingEnv.getElementUtils().getTypeElement(c.getName()).asType();
    }

    private static <E> $ImmutableSet<E> immutableSetDifference($ImmutableSet<E> a, $ImmutableSet<E> b) {
        if (Collections.disjoint(a, b)) {
            return a;
        }
        return $ImmutableSet.copyOf($Sets.difference(a, b));
    }
}

