/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.credentialaccessboundary;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.util.Clock;
import com.google.auth.credentialaccessboundary.protobuf.ClientSideAccessBoundaryProto;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.StsRequestHandler;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.auth.oauth2.StsTokenExchangeResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.RegistryConfiguration;
import com.google.crypto.tink.SecretKeyAccess;
import com.google.crypto.tink.TinkProtoKeysetFormat;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelOptions;
import dev.cel.common.CelProtoAbstractSyntaxTree;
import dev.cel.common.CelValidationException;
import dev.cel.compiler.CelCompiler;
import dev.cel.compiler.CelCompilerFactory;
import dev.cel.expr.Expr;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class ClientSideCredentialAccessBoundaryFactory {
    static final Duration DEFAULT_REFRESH_MARGIN = Duration.ofMinutes(45L);
    static final Duration DEFAULT_MINIMUM_TOKEN_LIFETIME = Duration.ofMinutes(30L);
    private final GoogleCredentials sourceCredential;
    private final transient HttpTransportFactory transportFactory;
    private final String tokenExchangeEndpoint;
    private final Duration minimumTokenLifetime;
    private final Duration refreshMargin;
    private RefreshTask refreshTask;
    private final Object refreshLock = new byte[0];
    private IntermediateCredentials intermediateCredentials = null;
    private final Clock clock;
    private final CelCompiler celCompiler;

    private ClientSideCredentialAccessBoundaryFactory(Builder builder) {
        this.transportFactory = builder.transportFactory;
        this.sourceCredential = builder.sourceCredential;
        this.tokenExchangeEndpoint = builder.tokenExchangeEndpoint;
        this.refreshMargin = builder.refreshMargin;
        this.minimumTokenLifetime = builder.minimumTokenLifetime;
        this.clock = builder.clock;
        try {
            AeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Error occurred when registering Tink", e);
        }
        CelOptions options = CelOptions.current().build();
        this.celCompiler = CelCompilerFactory.standardCelCompilerBuilder().setOptions(options).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken generateToken(CredentialAccessBoundary accessBoundary) throws IOException, CelValidationException, GeneralSecurityException {
        String sessionKey;
        Date intermediateTokenExpirationTime;
        String intermediateToken;
        this.refreshCredentialsIfRequired();
        Object object = this.refreshLock;
        synchronized (object) {
            intermediateToken = this.intermediateCredentials.intermediateAccessToken.getTokenValue();
            intermediateTokenExpirationTime = this.intermediateCredentials.intermediateAccessToken.getExpirationTime();
            sessionKey = this.intermediateCredentials.accessBoundarySessionKey;
        }
        byte[] rawRestrictions = this.serializeCredentialAccessBoundary(accessBoundary);
        byte[] encryptedRestrictions = this.encryptRestrictions(rawRestrictions, sessionKey);
        String tokenValue = intermediateToken + "." + Base64.getUrlEncoder().withoutPadding().encodeToString(encryptedRestrictions);
        return new AccessToken(tokenValue, intermediateTokenExpirationTime);
    }

    @VisibleForTesting
    void refreshCredentialsIfRequired() throws IOException {
        RefreshType refreshType = this.determineRefreshType();
        if (refreshType == RefreshType.NONE) {
            return;
        }
        RefreshTask currentRefreshTask = this.getOrCreateRefreshTask();
        switch (refreshType) {
            case BLOCKING: {
                if (currentRefreshTask.isNew) {
                    MoreExecutors.directExecutor().execute((Runnable)currentRefreshTask.task);
                }
                try {
                    currentRefreshTask.task.get();
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while asynchronously refreshing the intermediate credentials", e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new IOException("Unexpected error refreshing intermediate credentials", cause);
                }
            }
            case ASYNC: {
                if (!currentRefreshTask.isNew) break;
                new Thread((Runnable)currentRefreshTask.task).start();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected refresh type: " + (Object)((Object)refreshType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefreshType determineRefreshType() {
        AccessToken intermediateAccessToken;
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.intermediateCredentials == null || this.intermediateCredentials.intermediateAccessToken == null) {
                return RefreshType.BLOCKING;
            }
            intermediateAccessToken = this.intermediateCredentials.intermediateAccessToken;
        }
        Date expirationTime = intermediateAccessToken.getExpirationTime();
        if (expirationTime == null) {
            return RefreshType.NONE;
        }
        Duration remaining = Duration.ofMillis(expirationTime.getTime() - this.clock.currentTimeMillis());
        if (remaining.compareTo(this.minimumTokenLifetime) <= 0) {
            return RefreshType.BLOCKING;
        }
        if (remaining.compareTo(this.refreshMargin) <= 0) {
            return RefreshType.ASYNC;
        }
        return RefreshType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefreshTask getOrCreateRefreshTask() {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.refreshTask != null) {
                return new RefreshTask((ListenableFutureTask<IntermediateCredentials>)this.refreshTask.task, false);
            }
            ListenableFutureTask task = ListenableFutureTask.create(this::fetchIntermediateCredentials);
            this.refreshTask = new RefreshTask((ListenableFutureTask<IntermediateCredentials>)task, true);
            return this.refreshTask;
        }
    }

    @VisibleForTesting
    IntermediateCredentials fetchIntermediateCredentials() throws IOException {
        try {
            this.sourceCredential.refresh();
        }
        catch (IOException e) {
            throw new IOException("Unable to refresh the provided source credential.", e);
        }
        AccessToken sourceAccessToken = this.sourceCredential.getAccessToken();
        if (sourceAccessToken == null || Strings.isNullOrEmpty((String)sourceAccessToken.getTokenValue())) {
            throw new IllegalStateException("The source credential does not have an access token.");
        }
        StsTokenExchangeRequest request = StsTokenExchangeRequest.newBuilder((String)sourceAccessToken.getTokenValue(), (String)"urn:ietf:params:oauth:token-type:access_token").setRequestTokenType("urn:ietf:params:oauth:token-type:access_boundary_intermediary_token").build();
        StsRequestHandler handler = StsRequestHandler.newBuilder((String)this.tokenExchangeEndpoint, (StsTokenExchangeRequest)request, (HttpRequestFactory)this.transportFactory.create().createRequestFactory()).build();
        StsTokenExchangeResponse response = handler.exchangeToken();
        return new IntermediateCredentials(ClientSideCredentialAccessBoundaryFactory.getTokenFromResponse(response, sourceAccessToken), response.getAccessBoundarySessionKey());
    }

    private static AccessToken getTokenFromResponse(StsTokenExchangeResponse response, AccessToken sourceAccessToken) {
        AccessToken intermediateToken = response.getAccessToken();
        if (intermediateToken.getExpirationTime() == null && sourceAccessToken.getExpirationTime() != null) {
            return new AccessToken(intermediateToken.getTokenValue(), sourceAccessToken.getExpirationTime());
        }
        return intermediateToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRefreshTask(ListenableFuture<IntermediateCredentials> finishedTask) throws ExecutionException {
        Object object = this.refreshLock;
        synchronized (object) {
            try {
                this.intermediateCredentials = (IntermediateCredentials)Futures.getDone(finishedTask);
            }
            finally {
                if (this.refreshTask != null && this.refreshTask.task == finishedTask) {
                    this.refreshTask = null;
                }
            }
        }
    }

    @VisibleForTesting
    String getTokenExchangeEndpoint() {
        return this.tokenExchangeEndpoint;
    }

    @VisibleForTesting
    HttpTransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    @VisibleForTesting
    Duration getRefreshMargin() {
        return this.refreshMargin;
    }

    @VisibleForTesting
    Duration getMinimumTokenLifetime() {
        return this.minimumTokenLifetime;
    }

    @VisibleForTesting
    byte[] serializeCredentialAccessBoundary(CredentialAccessBoundary credentialAccessBoundary) throws CelValidationException {
        List rules = credentialAccessBoundary.getAccessBoundaryRules();
        ClientSideAccessBoundaryProto.ClientSideAccessBoundary.Builder accessBoundaryBuilder = ClientSideAccessBoundaryProto.ClientSideAccessBoundary.newBuilder();
        for (CredentialAccessBoundary.AccessBoundaryRule rule : rules) {
            ClientSideAccessBoundaryProto.ClientSideAccessBoundaryRule.Builder ruleBuilder = accessBoundaryBuilder.addAccessBoundaryRulesBuilder().addAllAvailablePermissions(rule.getAvailablePermissions()).setAvailableResource(rule.getAvailableResource());
            if (rule.getAvailabilityCondition() == null) continue;
            String availabilityCondition = rule.getAvailabilityCondition().getExpression();
            Expr availabilityConditionExpr = this.compileCel(availabilityCondition);
            ruleBuilder.setCompiledAvailabilityCondition(availabilityConditionExpr);
        }
        return accessBoundaryBuilder.build().toByteArray();
    }

    private Expr compileCel(String expr) throws CelValidationException {
        CelAbstractSyntaxTree ast = this.celCompiler.parse(expr).getAst();
        CelProtoAbstractSyntaxTree astProto = CelProtoAbstractSyntaxTree.fromCelAst((CelAbstractSyntaxTree)ast);
        return astProto.getExpr();
    }

    private byte[] encryptRestrictions(byte[] restriction, String sessionKey) throws GeneralSecurityException {
        byte[] rawKey;
        try {
            rawKey = Base64.getDecoder().decode(sessionKey);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Session key is not Base64 encoded", e);
        }
        KeysetHandle keysetHandle = TinkProtoKeysetFormat.parseKeyset((byte[])rawKey, (SecretKeyAccess)InsecureSecretKeyAccess.get());
        Aead aead = (Aead)keysetHandle.getPrimitive(RegistryConfiguration.get(), Aead.class);
        return aead.encrypt(restriction, new byte[0]);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private GoogleCredentials sourceCredential;
        private HttpTransportFactory transportFactory;
        private String universeDomain;
        private String tokenExchangeEndpoint;
        private Duration minimumTokenLifetime;
        private Duration refreshMargin;
        private Clock clock = Clock.SYSTEM;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setSourceCredential(GoogleCredentials sourceCredential) {
            Preconditions.checkNotNull((Object)sourceCredential, (Object)"Source credential must not be null.");
            this.sourceCredential = sourceCredential;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinimumTokenLifetime(Duration minimumTokenLifetime) {
            Preconditions.checkNotNull((Object)minimumTokenLifetime, (Object)"Minimum token lifetime must not be null.");
            if (minimumTokenLifetime.isNegative() || minimumTokenLifetime.isZero()) {
                throw new IllegalArgumentException("Minimum token lifetime must be greater than zero.");
            }
            this.minimumTokenLifetime = minimumTokenLifetime;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRefreshMargin(Duration refreshMargin) {
            Preconditions.checkNotNull((Object)refreshMargin, (Object)"Refresh margin must not be null.");
            if (refreshMargin.isNegative() || refreshMargin.isZero()) {
                throw new IllegalArgumentException("Refresh margin must be greater than zero.");
            }
            this.refreshMargin = refreshMargin;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public ClientSideCredentialAccessBoundaryFactory build() {
            Duration minRefreshMargin;
            Preconditions.checkNotNull((Object)this.sourceCredential, (Object)"Source credential must not be null.");
            if (this.transportFactory == null) {
                this.transportFactory = (HttpTransportFactory)OAuth2Credentials.getFromServiceLoader(HttpTransportFactory.class, (Object)OAuth2Utils.HTTP_TRANSPORT_FACTORY);
            }
            if (Strings.isNullOrEmpty((String)this.universeDomain)) {
                this.universeDomain = "googleapis.com";
            }
            try {
                if (!this.universeDomain.equals(this.sourceCredential.getUniverseDomain())) {
                    throw new IllegalArgumentException("The client side access boundary credential's universe domain must be the same as the source credential.");
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Error occurred when attempting to retrieve source credential universe domain.", e);
            }
            if (this.refreshMargin == null) {
                this.refreshMargin = DEFAULT_REFRESH_MARGIN;
            }
            if (this.minimumTokenLifetime == null) {
                this.minimumTokenLifetime = DEFAULT_MINIMUM_TOKEN_LIFETIME;
            }
            if (this.refreshMargin.compareTo(minRefreshMargin = this.minimumTokenLifetime.plusMinutes(1L)) < 0) {
                throw new IllegalArgumentException("Refresh margin must be at least one minute longer than the minimum token lifetime.");
            }
            this.tokenExchangeEndpoint = String.format("https://sts.%s/v1/token", this.universeDomain);
            return new ClientSideCredentialAccessBoundaryFactory(this);
        }
    }

    class RefreshTask
    extends AbstractFuture<IntermediateCredentials>
    implements Runnable {
        private final ListenableFutureTask<IntermediateCredentials> task;
        final boolean isNew;

        RefreshTask(ListenableFutureTask<IntermediateCredentials> task, boolean isNew) {
            this.task = task;
            this.isNew = isNew;
            task.addListener(() -> {
                try {
                    ClientSideCredentialAccessBoundaryFactory.this.finishRefreshTask((ListenableFuture<IntermediateCredentials>)((ListenableFuture)task));
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    this.setException(cause);
                }
            }, MoreExecutors.directExecutor());
            Futures.addCallback(task, (FutureCallback)new FutureCallback<IntermediateCredentials>(){

                public void onSuccess(IntermediateCredentials result) {
                    RefreshTask.this.set(result);
                }

                public void onFailure(@Nullable Throwable t) {
                    RefreshTask.this.setException(t != null ? t : new IOException("Refresh failed with null Throwable."));
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    @VisibleForTesting
    static class IntermediateCredentials {
        private final AccessToken intermediateAccessToken;
        private final String accessBoundarySessionKey;

        IntermediateCredentials(AccessToken accessToken, String accessBoundarySessionKey) {
            this.intermediateAccessToken = accessToken;
            this.accessBoundarySessionKey = accessBoundarySessionKey;
        }

        String getAccessBoundarySessionKey() {
            return this.accessBoundarySessionKey;
        }

        AccessToken getIntermediateAccessToken() {
            return this.intermediateAccessToken;
        }
    }

    static enum RefreshType {
        NONE,
        ASYNC,
        BLOCKING;

    }
}

