/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.Utf8;
import java.nio.ByteBuffer;

public final class Utf8Safe
extends Utf8 {
    public Utf8Safe() {
    }

    private static int computeEncodedLength(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c2 = charSequence.charAt(n);
            if (c2 < '\u0800') {
                n3 += 127 - c2 >>> 31;
            } else {
                n3 += Utf8Safe.encodedLengthGeneral(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0800') {
                n3 += 127 - c2 >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c2 || c2 > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new a(i, n2);
            }
            ++i;
        }
        return n3;
    }

    private static String decodeUtf8Array(byte[] byArray, int n, int n2) {
        byte by;
        char[] cArray;
        int n3;
        byte by2;
        int n4;
        if ((n | n2 | byArray.length - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n, n2));
        }
        int n5 = n + n2;
        char[] cArray2 = new char[n2];
        int n6 = 0;
        for (n4 = n; n4 < n5 && Utf8.a.a(by2 = byArray[n4]); ++n4) {
            n3 = n6++;
            cArray = cArray2;
            by = by2;
            cArray[n3] = (char)by;
        }
        while (n4 < n5) {
            if (Utf8.a.a(by2 = byArray[n4++])) {
                byte by3;
                n3 = n6++;
                cArray = cArray2;
                by = by2;
                cArray[n3] = (char)by;
                while (n4 < n5 && Utf8.a.a(by3 = byArray[n4])) {
                    ++n4;
                    n3 = n6++;
                    cArray = cArray2;
                    by = by3;
                    cArray[n3] = (char)by;
                }
                continue;
            }
            if (Utf8.a.b(by2)) {
                if (n4 >= n5) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.a.a(by2, byArray[n4++], cArray2, n6++);
                continue;
            }
            if (Utf8.a.c(by2)) {
                if (n4 >= n5 - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.a.a(by2, byArray[n4++], byArray[n4++], cArray2, n6++);
                continue;
            }
            if (n4 >= n5 - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            Utf8.a.a(by2, byArray[n4++], byArray[n4++], byArray[n4++], cArray2, n6++);
            ++n6;
        }
        return new String(cArray2, 0, n6);
    }

    private static String decodeUtf8Buffer(ByteBuffer byteBuffer, int n, int n2) {
        byte by;
        char[] cArray;
        int n3;
        byte by2;
        if ((n | n2 | byteBuffer.limit() - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n, n2));
        }
        int n4 = n + n2;
        char[] cArray2 = new char[n2];
        int n5 = 0;
        while (n < n4 && Utf8.a.a(by2 = byteBuffer.get(n))) {
            ++n;
            n3 = n5++;
            cArray = cArray2;
            by = by2;
            cArray[n3] = (char)by;
        }
        while (n < n4) {
            if (Utf8.a.a(by2 = byteBuffer.get(n++))) {
                byte by3;
                n3 = n5++;
                cArray = cArray2;
                by = by2;
                cArray[n3] = (char)by;
                while (n < n4 && Utf8.a.a(by3 = byteBuffer.get(n))) {
                    ++n;
                    n3 = n5++;
                    cArray = cArray2;
                    by = by3;
                    cArray[n3] = (char)by;
                }
                continue;
            }
            if (Utf8.a.b(by2)) {
                if (n >= n4) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.a.a(by2, byteBuffer.get(n++), cArray2, n5++);
                continue;
            }
            if (Utf8.a.c(by2)) {
                if (n >= n4 - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.a.a(by2, byteBuffer.get(n++), byteBuffer.get(n++), cArray2, n5++);
                continue;
            }
            if (n >= n4 - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            Utf8.a.a(by2, byteBuffer.get(n++), byteBuffer.get(n++), byteBuffer.get(n++), cArray2, n5++);
            ++n5;
        }
        return new String(cArray2, 0, n5);
    }

    @Override
    public final int encodedLength(CharSequence charSequence) {
        return Utf8Safe.computeEncodedLength(charSequence);
    }

    @Override
    public final String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) throws IllegalArgumentException {
        if (byteBuffer.hasArray()) {
            return Utf8Safe.decodeUtf8Array(byteBuffer.array(), byteBuffer.arrayOffset() + n, n2);
        }
        return Utf8Safe.decodeUtf8Buffer(byteBuffer, n, n2);
    }

    private static void encodeUtf8Buffer(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n;
        int n2 = charSequence.length();
        int n3 = byteBuffer.position();
        try {
            char c2;
            for (n = 0; n < n2 && (c2 = charSequence.charAt(n)) < '\u0080'; ++n) {
                byteBuffer.put(n3 + n, (byte)c2);
            }
            if (n == n2) {
                byteBuffer.position(n3 + n);
                return;
            }
            n3 += n;
            while (n < n2) {
                c2 = charSequence.charAt(n);
                if (c2 < '\u0080') {
                    byteBuffer.put(n3, (byte)c2);
                } else if (c2 < '\u0800') {
                    byteBuffer.put(n3++, (byte)(0xC0 | c2 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & c2));
                } else if (c2 < '\ud800' || '\udfff' < c2) {
                    byteBuffer.put(n3++, (byte)(0xE0 | c2 >>> 12));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & c2 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & c2));
                } else {
                    char c3;
                    if (n + 1 == n2 || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n))) {
                        throw new a(n, n2);
                    }
                    int n4 = Character.toCodePoint(c2, c3);
                    byteBuffer.put(n3++, (byte)(0xF0 | n4 >>> 18));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 12));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & n4));
                }
                ++n;
                ++n3;
            }
            byteBuffer.position(n3);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n5 = byteBuffer.position() + Math.max(n, n3 - byteBuffer.position() + 1);
            char c4 = charSequence.charAt(n);
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c4).append(" at index ").append(n5).toString());
        }
    }

    private static int encodeUtf8Array(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c2;
        int n3;
        int n4 = charSequence.length();
        int n5 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n5 && (c2 = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c2;
        }
        if (n3 == n4) {
            return n + n4;
        }
        int n6 = n + n3;
        while (n3 < n4) {
            int n7;
            char c3;
            c2 = charSequence.charAt(n3);
            if (c2 < '\u0080' && n6 < n5) {
                byArray[n6++] = (byte)c2;
            } else if (c2 < '\u0800' && n6 <= n5 - 2) {
                byArray[n6++] = (byte)(0x3C0 | c2 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c2);
            } else if ((c2 < '\ud800' || '\udfff' < c2) && n6 <= n5 - 3) {
                byArray[n6++] = (byte)(0x1E0 | c2 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & c2 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c2);
            } else if (n6 <= n5 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n3))) {
                    throw new a(n3 - 1, n4);
                }
                n7 = Character.toCodePoint(c2, c3);
                byArray[n6++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7);
            } else {
                if (!('\ud800' > c2 || c2 > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c2, charSequence.charAt(n3 + 1)))) {
                    throw new a(n3, n4);
                }
                c3 = c2;
                n7 = n6;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c3).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n6;
    }

    @Override
    public final void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset();
            int n2 = Utf8Safe.encodeUtf8Array(charSequence, byteBuffer.array(), n + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(n2 - n);
            return;
        }
        Utf8Safe.encodeUtf8Buffer(charSequence, byteBuffer);
    }

    static final class a
    extends IllegalArgumentException {
        a(int n, int n2) {
            super(new StringBuilder(54).append("Unpaired surrogate at index ").append(n).append(" of ").append(n2).toString());
        }
    }
}

