/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.utilities;

import android.support.annotation.Nullable;

public class Preconditions {
    public Preconditions() {
    }

    public static <T> T checkNotNull(@Nullable T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNotNull(@Nullable T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static void checkElementIndex(int n, int n2) {
        Preconditions.checkElementIndex(n, n2, "index");
    }

    public static void checkElementIndex(int n, int n2, String string) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n, n2, string));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, @Nullable Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    private static String badElementIndex(int n, int n2, String string) {
        if (n < 0) {
            return Preconditions.format("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n2).toString());
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", string, n, n2);
    }

    private static String format(String string, Object ... objectArray) {
        int n;
        Object[] objectArray2;
        string = String.valueOf(string);
        if (objectArray == null) {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = "(Object[])null";
        } else {
            objectArray2 = objectArray;
        }
        objectArray = objectArray2;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16 * objectArray.length);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length && (n = string.indexOf("%s", n2)) != -1) {
            stringBuilder.append(string, n2, n);
            stringBuilder.append(objectArray[n3++]);
            n2 = n + 2;
        }
        stringBuilder.append(string, n2, string.length());
        if (n3 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n3++]);
            while (n3 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n3++]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

