/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.utilities;

import android.os.Build;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import com.google.ar.sceneform.utilities.Preconditions;

public class AndroidPreconditions {
    private static final boolean IS_ANDROID_API_AVAILABLE = AndroidPreconditions.checkAndroidApiAvailable();
    private static final boolean IS_MIN_ANDROID_API_LEVEL = AndroidPreconditions.isMinAndroidApiLevelImpl();
    private static boolean isUnderTesting = false;

    public AndroidPreconditions() {
    }

    public static void checkUiThread() {
        if (!AndroidPreconditions.isAndroidApiAvailable() || AndroidPreconditions.isUnderTesting()) {
            return;
        }
        boolean bl = Looper.getMainLooper().getThread() == Thread.currentThread();
        Preconditions.checkState(bl, "Must be called from the UI thread.");
    }

    public static void checkMinAndroidApiLevel() {
        Preconditions.checkState(AndroidPreconditions.isMinAndroidApiLevel(), "Sceneform requires Android N or later");
    }

    public static boolean isAndroidApiAvailable() {
        return IS_ANDROID_API_AVAILABLE;
    }

    public static boolean isUnderTesting() {
        return isUnderTesting;
    }

    public static boolean isMinAndroidApiLevel() {
        return AndroidPreconditions.isUnderTesting() || IS_MIN_ANDROID_API_LEVEL;
    }

    @VisibleForTesting
    public static void setUnderTesting(boolean bl) {
        isUnderTesting = bl;
    }

    private static boolean isMinAndroidApiLevelImpl() {
        return !AndroidPreconditions.isAndroidApiAvailable() || Build.VERSION.SDK_INT >= 21;
    }

    private static boolean checkAndroidApiAvailable() {
        try {
            Class.forName("android.app.Activity");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

