/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.math;

import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;

public class Quaternion {
    private static final float SLERP_THRESHOLD = 0.9995f;
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public Quaternion(Quaternion quaternion) {
        Preconditions.checkNotNull(quaternion, "Parameter \"q\" was null.");
        this.set(quaternion);
    }

    public Quaternion(Vector3 vector3, float f) {
        Preconditions.checkNotNull(vector3, "Parameter \"axis\" was null.");
        this.set(Quaternion.axisAngle(vector3, f));
    }

    public Quaternion(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"eulerAngles\" was null.");
        this.set(Quaternion.eulerAngles(vector3));
    }

    public void set(Quaternion quaternion) {
        Preconditions.checkNotNull(quaternion, "Parameter \"q\" was null.");
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        this.normalize();
    }

    public void set(Vector3 vector3, float f) {
        Preconditions.checkNotNull(vector3, "Parameter \"axis\" was null.");
        this.set(Quaternion.axisAngle(vector3, f));
    }

    public void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        this.normalize();
    }

    public void setIdentity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public boolean normalize() {
        float f = Quaternion.dot(this, this);
        if (MathHelper.almostEqualRelativeAndAbs(f, 0.0f)) {
            this.setIdentity();
            return false;
        }
        if (f != 1.0f) {
            float f2 = (float)(1.0 / Math.sqrt(f));
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
            this.w *= f2;
        }
        return true;
    }

    public Quaternion normalized() {
        Quaternion quaternion = new Quaternion(this);
        quaternion.normalize();
        return quaternion;
    }

    public Quaternion inverted() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    Quaternion negated() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    public String toString() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        return new StringBuilder(76).append("[x=").append(f).append(", y=").append(f2).append(", z=").append(f3).append(", w=").append(f4).append("]").toString();
    }

    public static Vector3 rotateVector(Quaternion quaternion, Vector3 vector3) {
        Preconditions.checkNotNull(quaternion, "Parameter \"q\" was null.");
        Preconditions.checkNotNull(vector3, "Parameter \"src\" was null.");
        Vector3 vector32 = new Vector3();
        float f = quaternion.w * quaternion.w;
        float f2 = quaternion.x * quaternion.x;
        float f3 = quaternion.y * quaternion.y;
        float f4 = quaternion.z * quaternion.z;
        float f5 = quaternion.z * quaternion.w;
        float f6 = quaternion.x * quaternion.y;
        float f7 = quaternion.x * quaternion.z;
        float f8 = quaternion.y * quaternion.w;
        float f9 = quaternion.y * quaternion.z;
        float f10 = quaternion.x * quaternion.w;
        float f11 = f + f2 - f4 - f3;
        float f12 = f6 + f5 + f5 + f6;
        float f13 = f7 - f8 + f7 - f8;
        float f14 = -f5 + f6 - f5 + f6;
        float f15 = f3 - f4 + f - f2;
        float f16 = f9 + f9 + f10 + f10;
        float f17 = f8 + f7 + f7 + f8;
        float f18 = f9 + f9 - f10 - f10;
        float f19 = f4 - f3 - f2 + f;
        float f20 = vector3.x;
        float f21 = vector3.y;
        float f22 = vector3.z;
        vector32.x = f11 * f20 + f14 * f21 + f17 * f22;
        vector32.y = f12 * f20 + f15 * f21 + f18 * f22;
        vector32.z = f13 * f20 + f16 * f21 + f19 * f22;
        return vector32;
    }

    public static Vector3 inverseRotateVector(Quaternion quaternion, Vector3 vector3) {
        Preconditions.checkNotNull(quaternion, "Parameter \"q\" was null.");
        Preconditions.checkNotNull(vector3, "Parameter \"src\" was null.");
        Vector3 vector32 = new Vector3();
        float f = quaternion.w * quaternion.w;
        float f2 = -quaternion.x * -quaternion.x;
        float f3 = -quaternion.y * -quaternion.y;
        float f4 = -quaternion.z * -quaternion.z;
        float f5 = -quaternion.z * quaternion.w;
        float f6 = -quaternion.x * -quaternion.y;
        float f7 = -quaternion.x * -quaternion.z;
        float f8 = -quaternion.y * quaternion.w;
        float f9 = -quaternion.y * -quaternion.z;
        float f10 = -quaternion.x * quaternion.w;
        float f11 = f + f2 - f4 - f3;
        float f12 = f6 + f5 + f5 + f6;
        float f13 = f7 - f8 + f7 - f8;
        float f14 = -f5 + f6 - f5 + f6;
        float f15 = f3 - f4 + f - f2;
        float f16 = f9 + f9 + f10 + f10;
        float f17 = f8 + f7 + f7 + f8;
        float f18 = f9 + f9 - f10 - f10;
        float f19 = f4 - f3 - f2 + f;
        float f20 = vector3.x;
        float f21 = vector3.y;
        float f22 = vector3.z;
        vector32.x = f11 * f20 + f14 * f21 + f17 * f22;
        vector32.y = f12 * f20 + f15 * f21 + f18 * f22;
        vector32.z = f13 * f20 + f16 * f21 + f19 * f22;
        return vector32;
    }

    public static Quaternion multiply(Quaternion quaternion, Quaternion quaternion2) {
        Preconditions.checkNotNull(quaternion, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(quaternion2, "Parameter \"rhs\" was null.");
        float f = quaternion.x;
        float f2 = quaternion.y;
        float f3 = quaternion.z;
        float f4 = quaternion.w;
        float f5 = quaternion2.x;
        float f6 = quaternion2.y;
        float f7 = quaternion2.z;
        float f8 = quaternion2.w;
        Quaternion quaternion3 = new Quaternion(f4 * f5 + f * f8 + f2 * f7 - f3 * f6, f4 * f6 - f * f7 + f2 * f8 + f3 * f5, f4 * f7 + f * f6 - f2 * f5 + f3 * f8, f4 * f8 - f * f5 - f2 * f6 - f3 * f7);
        return quaternion3;
    }

    Quaternion scaled(float f) {
        Quaternion quaternion = new Quaternion();
        new Quaternion().x = this.x * f;
        quaternion.y = this.y * f;
        quaternion.z = this.z * f;
        quaternion.w = this.w * f;
        return quaternion;
    }

    static Quaternion add(Quaternion quaternion, Quaternion quaternion2) {
        Preconditions.checkNotNull(quaternion, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(quaternion2, "Parameter \"rhs\" was null.");
        Quaternion quaternion3 = new Quaternion();
        new Quaternion().x = quaternion.x + quaternion2.x;
        quaternion3.y = quaternion.y + quaternion2.y;
        quaternion3.z = quaternion.z + quaternion2.z;
        quaternion3.w = quaternion.w + quaternion2.w;
        return quaternion3;
    }

    static float dot(Quaternion quaternion, Quaternion quaternion2) {
        Preconditions.checkNotNull(quaternion, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(quaternion2, "Parameter \"rhs\" was null.");
        return quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
    }

    static Quaternion lerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        Preconditions.checkNotNull(quaternion, "Parameter \"a\" was null.");
        Preconditions.checkNotNull(quaternion2, "Parameter \"b\" was null.");
        return new Quaternion(MathHelper.lerp(quaternion.x, quaternion2.x, f), MathHelper.lerp(quaternion.y, quaternion2.y, f), MathHelper.lerp(quaternion.z, quaternion2.z, f), MathHelper.lerp(quaternion.w, quaternion2.w, f));
    }

    public static Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        double d2;
        Preconditions.checkNotNull(quaternion, "Parameter \"start\" was null.");
        Preconditions.checkNotNull(quaternion2, "Parameter \"end\" was null.");
        Quaternion quaternion3 = quaternion.normalized();
        Quaternion quaternion4 = quaternion2.normalized();
        double d3 = Quaternion.dot(quaternion3, quaternion4);
        if (d2 < 0.0) {
            quaternion4 = quaternion4.negated();
            d3 = -d3;
        }
        if (d3 > (double)0.9995f) {
            return Quaternion.lerp(quaternion3, quaternion4, f);
        }
        d3 = Math.max(-1.0, Math.min(1.0, d3));
        double d4 = Math.acos(d3);
        double d5 = d4 * (double)f;
        double d6 = Math.cos(d5) - d3 * Math.sin(d5) / Math.sin(d4);
        double d7 = Math.sin(d5) / Math.sin(d4);
        Quaternion quaternion5 = Quaternion.add(quaternion3.scaled((float)d6), quaternion4.scaled((float)d7));
        return quaternion5.normalized();
    }

    public static Quaternion axisAngle(Vector3 vector3, float f) {
        Preconditions.checkNotNull(vector3, "Parameter \"axis\" was null.");
        Quaternion quaternion = new Quaternion();
        double d2 = Math.toRadians(f);
        double d3 = Math.sin(d2 / 2.0);
        quaternion.x = (float)((double)vector3.x * d3);
        quaternion.y = (float)((double)vector3.y * d3);
        quaternion.z = (float)((double)vector3.z * d3);
        quaternion.w = (float)Math.cos(d2 / 2.0);
        quaternion.normalize();
        return quaternion;
    }

    public static Quaternion eulerAngles(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"eulerAngles\" was null.");
        Quaternion quaternion = new Quaternion(Vector3.right(), vector3.x);
        Quaternion quaternion2 = new Quaternion(Vector3.up(), vector3.y);
        Quaternion quaternion3 = new Quaternion(Vector3.back(), vector3.z);
        return Quaternion.multiply(Quaternion.multiply(quaternion2, quaternion), quaternion3);
    }

    public static Quaternion rotationBetweenVectors(Vector3 vector3, Vector3 vector32) {
        float f;
        Preconditions.checkNotNull(vector3, "Parameter \"start\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"end\" was null.");
        vector3 = vector3.normalized();
        vector32 = vector32.normalized();
        float f2 = Vector3.dot(vector3, vector32);
        if (f < -0.999f) {
            Vector3 vector33;
            Vector3 vector34 = Vector3.cross(Vector3.back(), vector3);
            if (vector33.lengthSquared() < 0.01f) {
                vector34 = Vector3.cross(Vector3.right(), vector3);
            }
            vector34 = vector34.normalized();
            return Quaternion.axisAngle(vector34, 180.0f);
        }
        Vector3 vector35 = Vector3.cross(vector3, vector32);
        float f3 = (float)Math.sqrt((1.0 + (double)f2) * 2.0);
        float f4 = 1.0f / f3;
        return new Quaternion(vector35.x * f4, vector35.y * f4, vector35.z * f4, f3 * 0.5f);
    }

    public static Quaternion lookRotation(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"forwardInWorld\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"desiredUpInWorld\" was null.");
        Quaternion quaternion = Quaternion.rotationBetweenVectors(Vector3.forward(), vector3);
        Vector3 vector33 = Vector3.cross(vector3, vector32);
        vector32 = Vector3.cross(vector33, vector3);
        Vector3 vector34 = Quaternion.rotateVector(quaternion, Vector3.up());
        Quaternion quaternion2 = Quaternion.rotationBetweenVectors(vector34, vector32);
        return Quaternion.multiply(quaternion2, quaternion);
    }

    public static boolean equals(Quaternion quaternion, Quaternion quaternion2) {
        Preconditions.checkNotNull(quaternion, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(quaternion2, "Parameter \"rhs\" was null.");
        float f = Quaternion.dot(quaternion, quaternion2);
        return MathHelper.almostEqualRelativeAndAbs(f, 1.0f);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Quaternion)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return Quaternion.equals(this, (Quaternion)object);
    }

    public int hashCode() {
        int n = 31 + Float.floatToIntBits(this.w);
        n = n * 31 + Float.floatToIntBits(this.x);
        n = n * 31 + Float.floatToIntBits(this.y);
        n = n * 31 + Float.floatToIntBits(this.z);
        return n;
    }

    public static Quaternion identity() {
        return new Quaternion();
    }
}

