/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.math;

import android.util.Log;
import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;

public class Matrix {
    private static final String TAG = Matrix.class.getSimpleName();
    public static final float[] IDENTITY_DATA = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float[] data = new float[16];

    public Matrix() {
        this.set(IDENTITY_DATA);
    }

    public Matrix(float[] fArray) {
        this.set(fArray);
    }

    public void set(float[] fArray) {
        if (fArray == null || fArray.length != 16) {
            Log.w((String)TAG, (String)"Cannot set Matrix, invalid data.");
            return;
        }
        for (int i = 0; i < fArray.length; ++i) {
            this.data[i] = fArray[i];
        }
    }

    public void set(Matrix matrix) {
        Preconditions.checkNotNull(matrix, "Parameter \"m\" was null.");
        this.set(matrix.data);
    }

    public void decomposeTranslation(Vector3 vector3) {
        vector3.x = this.data[12];
        vector3.y = this.data[13];
        vector3.z = this.data[14];
    }

    public void decomposeScale(Vector3 vector3) {
        Vector3 vector32 = new Vector3(this.data[0], this.data[1], this.data[2]);
        vector3.x = vector32.length();
        vector32.set(this.data[4], this.data[5], this.data[6]);
        vector3.y = vector32.length();
        vector32.set(this.data[8], this.data[9], this.data[10]);
        vector3.z = vector32.length();
    }

    public void decomposeRotation(Vector3 vector3, Quaternion quaternion) {
        float f = this.data[0];
        float f2 = this.data[1];
        float f3 = this.data[2];
        float f4 = this.data[3];
        float f5 = this.data[4];
        float f6 = this.data[5];
        float f7 = this.data[6];
        float f8 = this.data[7];
        float f9 = this.data[8];
        float f10 = this.data[9];
        float f11 = this.data[10];
        float f12 = this.data[11];
        float f13 = this.data[12];
        float f14 = this.data[13];
        float f15 = this.data[14];
        float f16 = this.data[15];
        this.decomposeRotation(vector3, this);
        this.extractQuaternion(quaternion);
        this.data[0] = f;
        this.data[1] = f2;
        this.data[2] = f3;
        this.data[3] = f4;
        this.data[4] = f5;
        this.data[5] = f6;
        this.data[6] = f7;
        this.data[7] = f8;
        this.data[8] = f9;
        this.data[9] = f10;
        this.data[10] = f11;
        this.data[11] = f12;
        this.data[12] = f13;
        this.data[13] = f14;
        this.data[14] = f15;
        this.data[15] = f16;
    }

    public void decomposeRotation(Vector3 vector3, Matrix matrix) {
        int n;
        if (vector3.x != 0.0f) {
            for (n = 0; n < 3; ++n) {
                matrix.data[n] = this.data[n] / vector3.x;
            }
        }
        matrix.data[3] = 0.0f;
        if (vector3.y != 0.0f) {
            for (n = 4; n < 7; ++n) {
                matrix.data[n] = this.data[n] / vector3.y;
            }
        }
        matrix.data[7] = 0.0f;
        if (vector3.z != 0.0f) {
            for (n = 8; n < 11; ++n) {
                matrix.data[n] = this.data[n] / vector3.z;
            }
        }
        matrix.data[11] = 0.0f;
        matrix.data[12] = 0.0f;
        matrix.data[13] = 0.0f;
        matrix.data[14] = 0.0f;
        matrix.data[15] = 1.0f;
    }

    public void extractQuaternion(Quaternion quaternion) {
        float f;
        float f2 = this.data[0] + this.data[5] + this.data[10];
        if (f > 0.0f) {
            float f3 = (float)Math.sqrt((double)f2 + 1.0) * 2.0f;
            quaternion.w = 0.25f * f3;
            quaternion.x = (this.data[6] - this.data[9]) / f3;
            quaternion.y = (this.data[8] - this.data[2]) / f3;
            quaternion.z = (this.data[1] - this.data[4]) / f3;
        } else if (this.data[0] > this.data[5] && this.data[0] > this.data[10]) {
            float f4 = (float)Math.sqrt(1.0f + this.data[0] - this.data[5] - this.data[10]) * 2.0f;
            quaternion.w = (this.data[6] - this.data[9]) / f4;
            quaternion.x = 0.25f * f4;
            quaternion.y = (this.data[4] + this.data[1]) / f4;
            quaternion.z = (this.data[8] + this.data[2]) / f4;
        } else if (this.data[5] > this.data[10]) {
            float f5 = (float)Math.sqrt(1.0f + this.data[5] - this.data[0] - this.data[10]) * 2.0f;
            quaternion.w = (this.data[8] - this.data[2]) / f5;
            quaternion.x = (this.data[4] + this.data[1]) / f5;
            quaternion.y = 0.25f * f5;
            quaternion.z = (this.data[9] + this.data[6]) / f5;
        } else {
            float f6 = (float)Math.sqrt(1.0f + this.data[10] - this.data[0] - this.data[5]) * 2.0f;
            quaternion.w = (this.data[1] - this.data[4]) / f6;
            quaternion.x = (this.data[8] + this.data[2]) / f6;
            quaternion.y = (this.data[9] + this.data[6]) / f6;
            quaternion.z = 0.25f * f6;
        }
        quaternion.normalize();
    }

    public void makeTranslation(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"translation\" was null.");
        this.set(IDENTITY_DATA);
        this.setTranslation(vector3);
    }

    public void setTranslation(Vector3 vector3) {
        this.data[12] = vector3.x;
        this.data[13] = vector3.y;
        this.data[14] = vector3.z;
    }

    public void makeRotation(Quaternion quaternion) {
        Preconditions.checkNotNull(quaternion, "Parameter \"rotation\" was null.");
        this.set(IDENTITY_DATA);
        quaternion.normalize();
        float f = quaternion.x * quaternion.x;
        float f2 = quaternion.x * quaternion.y;
        float f3 = quaternion.x * quaternion.z;
        float f4 = quaternion.x * quaternion.w;
        float f5 = quaternion.y * quaternion.y;
        float f6 = quaternion.y * quaternion.z;
        float f7 = quaternion.y * quaternion.w;
        float f8 = quaternion.z * quaternion.z;
        float f9 = quaternion.z * quaternion.w;
        this.data[0] = 1.0f - 2.0f * (f5 + f8);
        this.data[4] = 2.0f * (f2 - f9);
        this.data[8] = 2.0f * (f3 + f7);
        this.data[1] = 2.0f * (f2 + f9);
        this.data[5] = 1.0f - 2.0f * (f + f8);
        this.data[9] = 2.0f * (f6 - f4);
        this.data[2] = 2.0f * (f3 - f7);
        this.data[6] = 2.0f * (f6 + f4);
        this.data[10] = 1.0f - 2.0f * (f + f5);
    }

    public void makeScale(float f) {
        Preconditions.checkNotNull(Float.valueOf(f), "Parameter \"scale\" was null.");
        this.set(IDENTITY_DATA);
        this.data[0] = f;
        this.data[5] = f;
        this.data[10] = f;
    }

    public void makeScale(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"scale\" was null.");
        this.set(IDENTITY_DATA);
        this.data[0] = vector3.x;
        this.data[5] = vector3.y;
        this.data[10] = vector3.z;
    }

    public void makeTrs(Vector3 vector3, Quaternion quaternion, Vector3 vector32) {
        float f = 1.0f - 2.0f * quaternion.x * quaternion.x;
        float f2 = quaternion.y * quaternion.y;
        float f3 = 2.0f * quaternion.z * quaternion.z;
        float f4 = 2.0f * quaternion.x * quaternion.z;
        float f5 = 2.0f * quaternion.y * quaternion.w;
        float f6 = 2.0f * quaternion.x * quaternion.y;
        float f7 = 2.0f * quaternion.z * quaternion.w;
        float f8 = 2.0f * quaternion.x * quaternion.w;
        float f9 = 2.0f * quaternion.y * quaternion.z;
        this.data[0] = (1.0f - f2 * 2.0f - f3) * vector32.x;
        this.data[4] = (f6 - f7) * vector32.y;
        this.data[8] = (f4 + f5) * vector32.z;
        this.data[1] = (f6 + f7) * vector32.x;
        this.data[5] = (f - f3) * vector32.y;
        this.data[9] = (f9 - f8) * vector32.z;
        this.data[2] = (f4 - f5) * vector32.x;
        this.data[6] = (f9 + f8) * vector32.y;
        this.data[10] = (f - f2 * 2.0f) * vector32.z;
        this.data[12] = vector3.x;
        this.data[13] = vector3.y;
        this.data[14] = vector3.z;
        this.data[15] = 1.0f;
    }

    public static void multiply(Matrix matrix, Matrix matrix2, Matrix matrix3) {
        Preconditions.checkNotNull(matrix, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(matrix2, "Parameter \"rhs\" was null.");
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float f17 = matrix.data[0 + (i << 2)];
            float f18 = matrix.data[1 + (i << 2)];
            float f19 = matrix.data[2 + (i << 2)];
            float f20 = matrix.data[3 + (i << 2)];
            float f21 = matrix2.data[i + 0];
            float f22 = matrix2.data[i + 4];
            float f23 = matrix2.data[i + 8];
            float f24 = matrix2.data[i + 12];
            f += f17 * f21;
            f2 += f18 * f21;
            f3 += f19 * f21;
            f4 += f20 * f21;
            f5 += f17 * f22;
            f6 += f18 * f22;
            f7 += f19 * f22;
            f8 += f20 * f22;
            f9 += f17 * f23;
            f10 += f18 * f23;
            f11 += f19 * f23;
            f12 += f20 * f23;
            f13 += f17 * f24;
            f14 += f18 * f24;
            f15 += f19 * f24;
            f16 += f20 * f24;
        }
        matrix3.data[0] = f;
        matrix3.data[1] = f2;
        matrix3.data[2] = f3;
        matrix3.data[3] = f4;
        matrix3.data[4] = f5;
        matrix3.data[5] = f6;
        matrix3.data[6] = f7;
        matrix3.data[7] = f8;
        matrix3.data[8] = f9;
        matrix3.data[9] = f10;
        matrix3.data[10] = f11;
        matrix3.data[11] = f12;
        matrix3.data[12] = f13;
        matrix3.data[13] = f14;
        matrix3.data[14] = f15;
        matrix3.data[15] = f16;
    }

    public Vector3 transformPoint(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"vector\" was null.");
        Vector3 vector32 = new Vector3();
        float f = vector3.x;
        float f2 = vector3.y;
        float f3 = vector3.z;
        vector32.x = this.data[0] * f;
        vector32.x += this.data[4] * f2;
        vector32.x += this.data[8] * f3;
        vector32.x += this.data[12];
        vector32.y = this.data[1] * f;
        vector32.y += this.data[5] * f2;
        vector32.y += this.data[9] * f3;
        vector32.y += this.data[13];
        vector32.z = this.data[2] * f;
        vector32.z += this.data[6] * f2;
        vector32.z += this.data[10] * f3;
        vector32.z += this.data[14];
        return vector32;
    }

    public Vector3 transformDirection(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"vector\" was null.");
        Vector3 vector32 = new Vector3();
        float f = vector3.x;
        float f2 = vector3.y;
        float f3 = vector3.z;
        vector32.x = this.data[0] * f;
        vector32.x += this.data[4] * f2;
        vector32.x += this.data[8] * f3;
        vector32.y = this.data[1] * f;
        vector32.y += this.data[5] * f2;
        vector32.y += this.data[9] * f3;
        vector32.z = this.data[2] * f;
        vector32.z += this.data[6] * f2;
        vector32.z += this.data[10] * f3;
        return vector32;
    }

    public static boolean invert(Matrix matrix, Matrix matrix2) {
        Preconditions.checkNotNull(matrix, "Parameter \"matrix\" was null.");
        Preconditions.checkNotNull(matrix2, "Parameter \"dest\" was null.");
        float f = matrix.data[0];
        float f2 = matrix.data[1];
        float f3 = matrix.data[2];
        float f4 = matrix.data[3];
        float f5 = matrix.data[4];
        float f6 = matrix.data[5];
        float f7 = matrix.data[6];
        float f8 = matrix.data[7];
        float f9 = matrix.data[8];
        float f10 = matrix.data[9];
        float f11 = matrix.data[10];
        float f12 = matrix.data[11];
        float f13 = matrix.data[12];
        float f14 = matrix.data[13];
        float f15 = matrix.data[14];
        float f16 = matrix.data[15];
        matrix2.data[0] = f6 * f11 * f16 - f6 * f12 * f15 - f10 * f7 * f16 + f10 * f8 * f15 + f14 * f7 * f12 - f14 * f8 * f11;
        matrix2.data[4] = -f5 * f11 * f16 + f5 * f12 * f15 + f9 * f7 * f16 - f9 * f8 * f15 - f13 * f7 * f12 + f13 * f8 * f11;
        matrix2.data[8] = f5 * f10 * f16 - f5 * f12 * f14 - f9 * f6 * f16 + f9 * f8 * f14 + f13 * f6 * f12 - f13 * f8 * f10;
        matrix2.data[12] = -f5 * f10 * f15 + f5 * f11 * f14 + f9 * f6 * f15 - f9 * f7 * f14 - f13 * f6 * f11 + f13 * f7 * f10;
        matrix2.data[1] = -f2 * f11 * f16 + f2 * f12 * f15 + f10 * f3 * f16 - f10 * f4 * f15 - f14 * f3 * f12 + f14 * f4 * f11;
        matrix2.data[5] = f * f11 * f16 - f * f12 * f15 - f9 * f3 * f16 + f9 * f4 * f15 + f13 * f3 * f12 - f13 * f4 * f11;
        matrix2.data[9] = -f * f10 * f16 + f * f12 * f14 + f9 * f2 * f16 - f9 * f4 * f14 - f13 * f2 * f12 + f13 * f4 * f10;
        matrix2.data[13] = f * f10 * f15 - f * f11 * f14 - f9 * f2 * f15 + f9 * f3 * f14 + f13 * f2 * f11 - f13 * f3 * f10;
        matrix2.data[2] = f2 * f7 * f16 - f2 * f8 * f15 - f6 * f3 * f16 + f6 * f4 * f15 + f14 * f3 * f8 - f14 * f4 * f7;
        matrix2.data[6] = -f * f7 * f16 + f * f8 * f15 + f5 * f3 * f16 - f5 * f4 * f15 - f13 * f3 * f8 + f13 * f4 * f7;
        matrix2.data[10] = f * f6 * f16 - f * f8 * f14 - f5 * f2 * f16 + f5 * f4 * f14 + f13 * f2 * f8 - f13 * f4 * f6;
        matrix2.data[14] = -f * f6 * f15 + f * f7 * f14 + f5 * f2 * f15 - f5 * f3 * f14 - f13 * f2 * f7 + f13 * f3 * f6;
        matrix2.data[3] = -f2 * f7 * f12 + f2 * f8 * f11 + f6 * f3 * f12 - f6 * f4 * f11 - f10 * f3 * f8 + f10 * f4 * f7;
        matrix2.data[7] = f * f7 * f12 - f * f8 * f11 - f5 * f3 * f12 + f5 * f4 * f11 + f9 * f3 * f8 - f9 * f4 * f7;
        matrix2.data[11] = -f * f6 * f12 + f * f8 * f10 + f5 * f2 * f12 - f5 * f4 * f10 - f9 * f2 * f8 + f9 * f4 * f6;
        matrix2.data[15] = f * f6 * f11 - f * f7 * f10 - f5 * f2 * f11 + f5 * f3 * f10 + f9 * f2 * f7 - f9 * f3 * f6;
        float f17 = f * matrix2.data[0] + f2 * matrix2.data[4] + f3 * matrix2.data[8] + f4 * matrix2.data[12];
        if (f17 == 0.0f) {
            return false;
        }
        f17 = 1.0f / f17;
        int n = 0;
        while (n < 16) {
            int n2 = n++;
            matrix2.data[n2] = matrix2.data[n2] * f17;
        }
        return true;
    }

    public static boolean equals(Matrix matrix, Matrix matrix2) {
        Preconditions.checkNotNull(matrix, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(matrix2, "Parameter \"rhs\" was null.");
        boolean bl = true;
        for (int i = 0; i < 16; ++i) {
            bl &= MathHelper.almostEqualRelativeAndAbs(matrix.data[i], matrix2.data[i]);
        }
        return bl;
    }
}

