/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.collision;

import android.util.Log;
import com.google.ar.sceneform.collision.Box;
import com.google.ar.sceneform.collision.CollisionShape;
import com.google.ar.sceneform.collision.Ray;
import com.google.ar.sceneform.collision.RayHit;
import com.google.ar.sceneform.collision.a;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;

public class Sphere
extends CollisionShape {
    private static final String TAG = Sphere.class.getSimpleName();
    private final Vector3 center = new Vector3();
    private float radius = 1.0f;

    public Sphere() {
    }

    public Sphere(float f) {
        this(f, Vector3.zero());
    }

    public Sphere(float f, Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"center\" was null.");
        this.setCenter(vector3);
        this.setRadius(f);
    }

    public void setCenter(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"center\" was null.");
        this.center.set(vector3);
        this.onChanged();
    }

    public Vector3 getCenter() {
        return new Vector3(this.center);
    }

    public void setRadius(float f) {
        this.radius = f;
        this.onChanged();
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    public Sphere makeCopy() {
        return new Sphere(this.getRadius(), this.getCenter());
    }

    @Override
    protected boolean rayIntersection(Ray ray, RayHit rayHit) {
        float f;
        Preconditions.checkNotNull(ray, "Parameter \"ray\" was null.");
        Preconditions.checkNotNull(rayHit, "Parameter \"result\" was null.");
        Vector3 vector3 = ray.getDirection();
        Vector3 vector32 = ray.getOrigin();
        Vector3 vector33 = Vector3.subtract(vector32, this.center);
        float f2 = 2.0f * Vector3.dot(vector33, vector3);
        float f3 = Vector3.dot(vector33, vector33) - this.radius * this.radius;
        float f4 = f2 * f2 - 4.0f * f3;
        if (f < 0.0f) {
            return false;
        }
        float f5 = (float)Math.sqrt(f4);
        float f6 = (-f2 - f5) / 2.0f;
        float f7 = (-f2 + f5) / 2.0f;
        if (f6 < 0.0f && f7 < 0.0f) {
            return false;
        }
        if (f6 < 0.0f && f7 > 0.0f) {
            rayHit.setDistance(f7);
        } else {
            rayHit.setDistance(f6);
        }
        rayHit.setPoint(ray.getPoint(rayHit.getDistance()));
        return true;
    }

    @Override
    protected boolean shapeIntersection(CollisionShape collisionShape) {
        Preconditions.checkNotNull(collisionShape, "Parameter \"shape\" was null.");
        return collisionShape.sphereIntersection(this);
    }

    @Override
    protected boolean sphereIntersection(Sphere sphere) {
        float f;
        Sphere sphere2 = sphere;
        Sphere sphere3 = this;
        Preconditions.checkNotNull(sphere3, "Parameter \"sphere1\" was null.");
        Preconditions.checkNotNull(sphere2, "Parameter \"sphere2\" was null.");
        float f2 = sphere3.getRadius() + sphere2.getRadius();
        float f3 = f2 * f2;
        Vector3 vector3 = Vector3.subtract(sphere2.getCenter(), sphere3.getCenter());
        float f4 = Vector3.dot(vector3, vector3);
        return f - f3 <= 0.0f && f4 != 0.0f;
    }

    @Override
    protected boolean boxIntersection(Box box) {
        return a.a(this, box);
    }

    @Override
    CollisionShape transform(TransformProvider transformProvider) {
        Preconditions.checkNotNull(transformProvider, "Parameter \"transformProvider\" was null.");
        Sphere sphere = new Sphere();
        this.transform(transformProvider, sphere);
        return sphere;
    }

    @Override
    void transform(TransformProvider transformProvider, CollisionShape collisionShape) {
        Preconditions.checkNotNull(transformProvider, "Parameter \"transformProvider\" was null.");
        Preconditions.checkNotNull(collisionShape, "Parameter \"result\" was null.");
        if (!(collisionShape instanceof Sphere)) {
            Log.w((String)TAG, (String)"Cannot pass CollisionShape of a type other than Sphere into Sphere.transform.");
            return;
        }
        Sphere sphere = (Sphere)collisionShape;
        Matrix matrix = transformProvider.getWorldModelMatrix();
        sphere.setCenter(matrix.transformPoint(this.center));
        Vector3 vector3 = new Vector3();
        matrix.decomposeScale(vector3);
        float f = Math.max(Math.abs(Math.min(Math.min(vector3.x, vector3.y), vector3.z)), Math.max(Math.max(vector3.x, vector3.y), vector3.z));
        sphere.radius = this.radius * f;
    }
}

