/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.collision;

import com.google.ar.sceneform.collision.Ray;
import com.google.ar.sceneform.collision.RayHit;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;

public class Plane {
    private final Vector3 center = new Vector3();
    private final Vector3 normal = new Vector3();
    private static final double NEAR_ZERO_THRESHOLD = 1.0E-6;

    public Plane(Vector3 vector3, Vector3 vector32) {
        this.setCenter(vector3);
        this.setNormal(vector32);
    }

    public void setCenter(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"center\" was null.");
        this.center.set(vector3);
    }

    public Vector3 getCenter() {
        return new Vector3(this.center);
    }

    public void setNormal(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"normal\" was null.");
        this.normal.set(vector3.normalized());
    }

    public Vector3 getNormal() {
        return new Vector3(this.normal);
    }

    public boolean rayIntersection(Ray ray, RayHit rayHit) {
        float f;
        Preconditions.checkNotNull(ray, "Parameter \"ray\" was null.");
        Preconditions.checkNotNull(rayHit, "Parameter \"result\" was null.");
        Vector3 vector3 = ray.getDirection();
        Vector3 vector32 = ray.getOrigin();
        float f2 = Vector3.dot(this.normal, vector3);
        if ((double)Math.abs(f) > 1.0E-6) {
            float f3;
            Vector3 vector33 = Vector3.subtract(this.center, vector32);
            float f4 = Vector3.dot(vector33, this.normal) / f2;
            if (f3 >= 0.0f) {
                rayHit.setDistance(f4);
                rayHit.setPoint(ray.getPoint(rayHit.getDistance()));
                return true;
            }
        }
        return false;
    }
}

