/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.collision;

import android.support.annotation.Nullable;
import com.google.ar.sceneform.collision.Collider;
import com.google.ar.sceneform.collision.CollisionShape;
import com.google.ar.sceneform.collision.Ray;
import com.google.ar.sceneform.collision.RayHit;
import com.google.ar.sceneform.collision.b;
import com.google.ar.sceneform.utilities.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CollisionSystem {
    private static final String TAG = CollisionSystem.class.getSimpleName();
    private final ArrayList<Collider> colliders = new ArrayList();

    public CollisionSystem() {
    }

    public void addCollider(Collider collider) {
        Preconditions.checkNotNull(collider, "Parameter \"collider\" was null.");
        this.colliders.add(collider);
    }

    public void removeCollider(Collider collider) {
        Preconditions.checkNotNull(collider, "Parameter \"collider\" was null.");
        this.colliders.remove(collider);
    }

    @Nullable
    public Collider raycast(Ray ray, RayHit rayHit) {
        Preconditions.checkNotNull(ray, "Parameter \"ray\" was null.");
        Preconditions.checkNotNull(rayHit, "Parameter \"resultHit\" was null.");
        rayHit.reset();
        Collider collider = null;
        RayHit rayHit2 = new RayHit();
        ArrayList<Collider> arrayList = this.colliders;
        int n = arrayList.size();
        Object var5_8 = null;
        for (int i = 0; i < n; ++i) {
            Collider collider2 = arrayList.get(i);
            Collider collider3 = collider2;
            CollisionShape collisionShape = collider2.getTransformedShape();
            if (collisionShape == null || !collisionShape.rayIntersection(ray, rayHit2) || !(rayHit2.getDistance() < rayHit.getDistance())) continue;
            rayHit.set(rayHit2);
            collider = collider3;
        }
        return collider;
    }

    public <T extends RayHit> int raycastAll(Ray ray, ArrayList<T> arrayList, @Nullable BiConsumer<T, Collider> biConsumer, Supplier<T> supplier) {
        Preconditions.checkNotNull(ray, "Parameter \"ray\" was null.");
        Preconditions.checkNotNull(arrayList, "Parameter \"resultBuffer\" was null.");
        Preconditions.checkNotNull(supplier, "Parameter \"allocateResult\" was null.");
        RayHit rayHit = new RayHit();
        int n = 0;
        ArrayList<Collider> arrayList2 = this.colliders;
        int n2 = arrayList2.size();
        int n3 = 0;
        Object var7_10 = null;
        while (n3 < n2) {
            RayHit rayHit2;
            Collider collider = arrayList2.get(n3);
            ++n3;
            Collider collider2 = collider;
            CollisionShape collisionShape = collider.getTransformedShape();
            if (collisionShape == null || !collisionShape.rayIntersection(ray, rayHit)) continue;
            if (arrayList.size() >= ++n) {
                rayHit2 = (RayHit)arrayList.get(n - 1);
            } else {
                rayHit2 = (RayHit)supplier.get();
                arrayList.add(rayHit2);
            }
            rayHit2.reset();
            rayHit2.set(rayHit);
            if (biConsumer == null) continue;
            biConsumer.accept(rayHit2, collider2);
        }
        for (int i = n; i < arrayList.size(); ++i) {
            ((RayHit)arrayList.get(i)).reset();
        }
        Collections.sort(arrayList, b.a);
        return n;
    }

    @Nullable
    public Collider intersects(Collider collider) {
        Preconditions.checkNotNull(collider, "Parameter \"collider\" was null.");
        CollisionShape collisionShape = collider.getTransformedShape();
        if (collisionShape == null) {
            return null;
        }
        ArrayList<Collider> arrayList = this.colliders;
        int n = arrayList.size();
        Object var3_6 = null;
        for (int i = 0; i < n; ++i) {
            CollisionShape collisionShape2;
            Collider collider2 = arrayList.get(i);
            Collider collider3 = collider2;
            if (collider2 == collider || (collisionShape2 = collider3.getTransformedShape()) == null || !collisionShape.shapeIntersection(collisionShape2)) continue;
            return collider3;
        }
        return null;
    }

    public void intersectsAll(Collider collider, Consumer<Collider> consumer) {
        Preconditions.checkNotNull(collider, "Parameter \"collider\" was null.");
        Preconditions.checkNotNull(consumer, "Parameter \"processResult\" was null.");
        CollisionShape collisionShape = collider.getTransformedShape();
        if (collisionShape == null) {
            return;
        }
        ArrayList<Collider> arrayList = this.colliders;
        int n = arrayList.size();
        Object var4_7 = null;
        for (int i = 0; i < n; ++i) {
            CollisionShape collisionShape2;
            Collider collider2 = arrayList.get(i);
            Collider collider3 = collider2;
            if (collider2 == collider || (collisionShape2 = collider3.getTransformedShape()) == null || !collisionShape.shapeIntersection(collisionShape2)) continue;
            consumer.accept(collider3);
        }
    }

    static final /* synthetic */ int lambda$raycastAll$0$CollisionSystem(RayHit rayHit, RayHit rayHit2) {
        return Float.compare(rayHit.getDistance(), rayHit2.getDistance());
    }
}

