/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.collision;

import android.support.annotation.Nullable;
import com.google.ar.sceneform.collision.CollisionShape;
import com.google.ar.sceneform.collision.CollisionSystem;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.utilities.ChangeId;
import com.google.ar.sceneform.utilities.Preconditions;

public class Collider {
    private TransformProvider transformProvider;
    @Nullable
    private CollisionSystem attachedCollisionSystem;
    private CollisionShape localShape;
    @Nullable
    private CollisionShape cachedWorldShape;
    private boolean isWorldShapeDirty;
    private int shapeId = 0;

    public Collider(TransformProvider transformProvider, CollisionShape collisionShape) {
        Preconditions.checkNotNull(transformProvider, "Parameter \"transformProvider\" was null.");
        Preconditions.checkNotNull(collisionShape, "Parameter \"localCollisionShape\" was null.");
        this.transformProvider = transformProvider;
        this.setShape(collisionShape);
    }

    public void setShape(CollisionShape collisionShape) {
        Preconditions.checkNotNull(collisionShape, "Parameter \"localCollisionShape\" was null.");
        this.localShape = collisionShape;
        this.cachedWorldShape = null;
    }

    public CollisionShape getShape() {
        return this.localShape;
    }

    public TransformProvider getTransformProvider() {
        return this.transformProvider;
    }

    @Nullable
    public CollisionShape getTransformedShape() {
        this.updateCachedWorldShape();
        return this.cachedWorldShape;
    }

    public void setAttachedCollisionSystem(@Nullable CollisionSystem collisionSystem) {
        if (this.attachedCollisionSystem != null) {
            this.attachedCollisionSystem.removeCollider(this);
        }
        this.attachedCollisionSystem = collisionSystem;
        if (this.attachedCollisionSystem != null) {
            this.attachedCollisionSystem.addCollider(this);
        }
    }

    public void markWorldShapeDirty() {
        this.isWorldShapeDirty = true;
    }

    private boolean doesCachedWorldShapeNeedUpdate() {
        if (this.localShape == null) {
            return false;
        }
        ChangeId changeId = this.localShape.getId();
        return changeId.checkChanged(this.shapeId) || this.isWorldShapeDirty || this.cachedWorldShape == null;
    }

    private void updateCachedWorldShape() {
        if (!this.doesCachedWorldShapeNeedUpdate()) {
            return;
        }
        if (this.cachedWorldShape == null) {
            this.cachedWorldShape = this.localShape.transform(this.transformProvider);
        } else {
            this.localShape.transform(this.transformProvider, this.cachedWorldShape);
        }
        ChangeId changeId = this.localShape.getId();
        this.shapeId = changeId.get();
    }
}

