/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.collision;

import android.util.Log;
import com.google.ar.sceneform.collision.CollisionShape;
import com.google.ar.sceneform.collision.Ray;
import com.google.ar.sceneform.collision.RayHit;
import com.google.ar.sceneform.collision.Sphere;
import com.google.ar.sceneform.collision.a;
import com.google.ar.sceneform.common.TransformProvider;
import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.math.Matrix;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;

public class Box
extends CollisionShape {
    private static final String TAG = Box.class.getSimpleName();
    private final Vector3 center = Vector3.zero();
    private final Vector3 size = Vector3.one();
    private final Matrix rotationMatrix = new Matrix();

    public Box() {
    }

    public Box(Vector3 vector3) {
        this(vector3, Vector3.zero());
    }

    public Box(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector32, "Parameter \"center\" was null.");
        Preconditions.checkNotNull(vector3, "Parameter \"size\" was null.");
        this.setCenter(vector32);
        this.setSize(vector3);
    }

    public void setCenter(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"center\" was null.");
        this.center.set(vector3);
        this.onChanged();
    }

    public Vector3 getCenter() {
        return new Vector3(this.center);
    }

    public void setSize(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"size\" was null.");
        this.size.set(vector3);
        this.onChanged();
    }

    public Vector3 getSize() {
        return new Vector3(this.size);
    }

    public Vector3 getExtents() {
        return this.getSize().scaled(0.5f);
    }

    public void setRotation(Quaternion quaternion) {
        Preconditions.checkNotNull(quaternion, "Parameter \"rotation\" was null.");
        this.rotationMatrix.makeRotation(quaternion);
        this.onChanged();
    }

    public Quaternion getRotation() {
        Quaternion quaternion = new Quaternion();
        this.rotationMatrix.extractQuaternion(quaternion);
        return quaternion;
    }

    @Override
    public Box makeCopy() {
        return new Box(this.getSize(), this.getCenter());
    }

    Matrix getRawRotationMatrix() {
        return this.rotationMatrix;
    }

    @Override
    protected boolean rayIntersection(Ray ray, RayHit rayHit) {
        float f;
        float f2;
        float f3;
        Preconditions.checkNotNull(ray, "Parameter \"ray\" was null.");
        Preconditions.checkNotNull(rayHit, "Parameter \"result\" was null.");
        Vector3 vector3 = ray.getDirection();
        Vector3 vector32 = ray.getOrigin();
        Vector3 vector33 = this.getExtents();
        Vector3 vector34 = vector33.negated();
        float f4 = Float.MIN_VALUE;
        float f5 = Float.MAX_VALUE;
        Vector3 vector35 = Vector3.subtract(this.center, vector32);
        float[] fArray = this.rotationMatrix.data;
        Vector3 vector36 = new Vector3(fArray[0], fArray[1], fArray[2]);
        float f6 = Vector3.dot(vector36, vector35);
        float f7 = Vector3.dot(vector3, vector36);
        if (!MathHelper.almostEqualRelativeAndAbs(f7, 0.0f)) {
            f3 = (f6 + vector34.x) / f7;
            f2 = (f6 + vector33.x) / f7;
            if (f3 > f2) {
                f = f3;
                f3 = f2;
                f2 = f;
            }
            if ((f5 = Math.min(f2, Float.MAX_VALUE)) < (f4 = Math.max(f3, Float.MIN_VALUE))) {
                return false;
            }
        } else if (-f6 + vector34.x > 0.0f || -f6 + vector33.x < 0.0f) {
            return false;
        }
        vector36 = new Vector3(fArray[4], fArray[5], fArray[6]);
        f6 = Vector3.dot(vector36, vector35);
        f7 = Vector3.dot(vector3, vector36);
        if (!MathHelper.almostEqualRelativeAndAbs(f7, 0.0f)) {
            f3 = (f6 + vector34.y) / f7;
            f2 = (f6 + vector33.y) / f7;
            if (f3 > f2) {
                f = f3;
                f3 = f2;
                f2 = f;
            }
            if ((f5 = Math.min(f2, f5)) < (f4 = Math.max(f3, f4))) {
                return false;
            }
        } else if (-f6 + vector34.y > 0.0f || -f6 + vector33.y < 0.0f) {
            return false;
        }
        vector36 = new Vector3(fArray[8], fArray[9], fArray[10]);
        f6 = Vector3.dot(vector36, vector35);
        f7 = Vector3.dot(vector3, vector36);
        if (!MathHelper.almostEqualRelativeAndAbs(f7, 0.0f)) {
            f3 = (f6 + vector34.z) / f7;
            f2 = (f6 + vector33.z) / f7;
            if (f3 > f2) {
                f = f3;
                f3 = f2;
                f2 = f;
            }
            if ((f5 = Math.min(f2, f5)) < (f4 = Math.max(f3, f4))) {
                return false;
            }
        } else if (-f6 + vector34.z > 0.0f || -f6 + vector33.z < 0.0f) {
            return false;
        }
        rayHit.setDistance(f4);
        rayHit.setPoint(ray.getPoint(rayHit.getDistance()));
        return true;
    }

    @Override
    protected boolean shapeIntersection(CollisionShape collisionShape) {
        Preconditions.checkNotNull(collisionShape, "Parameter \"shape\" was null.");
        return collisionShape.boxIntersection(this);
    }

    @Override
    protected boolean sphereIntersection(Sphere sphere) {
        return a.a(sphere, this);
    }

    @Override
    protected boolean boxIntersection(Box box) {
        return a.a(this, box);
    }

    @Override
    CollisionShape transform(TransformProvider transformProvider) {
        Preconditions.checkNotNull(transformProvider, "Parameter \"transformProvider\" was null.");
        Box box = new Box();
        this.transform(transformProvider, box);
        return box;
    }

    @Override
    void transform(TransformProvider transformProvider, CollisionShape collisionShape) {
        Preconditions.checkNotNull(transformProvider, "Parameter \"transformProvider\" was null.");
        Preconditions.checkNotNull(collisionShape, "Parameter \"result\" was null.");
        if (!(collisionShape instanceof Box)) {
            Log.w((String)TAG, (String)"Cannot pass CollisionShape of a type other than Box into Box.transform.");
            return;
        }
        if (collisionShape == this) {
            throw new IllegalArgumentException("Box cannot transform itself.");
        }
        Box box = (Box)collisionShape;
        Matrix matrix = transformProvider.getWorldModelMatrix();
        box.center.set(matrix.transformPoint(this.center));
        Vector3 vector3 = new Vector3();
        matrix.decomposeScale(vector3);
        box.size.x = this.size.x * vector3.x;
        box.size.y = this.size.y * vector3.y;
        box.size.z = this.size.z * vector3.z;
        matrix.decomposeRotation(vector3, box.rotationMatrix);
        Matrix.multiply(this.rotationMatrix, box.rotationMatrix, box.rotationMatrix);
    }
}

