/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.apphosting.runtime.SessionData;
import com.google.apphosting.runtime.SessionManagerUtil;
import com.google.apphosting.runtime.SessionStore;
import com.google.common.flogger.GoogleLogger;
import java.util.Map;

public class DatastoreSessionStore
implements SessionStore {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String SESSION_ENTITY_TYPE = "_ah_SESSION";
    static final String EXPIRES_PROP = "_expires";
    static final String VALUES_PROP = "_values";
    private final DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();

    static Key createKeyForSession(String key) {
        String originalNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Key key2 = KeyFactory.createKey((String)SESSION_ENTITY_TYPE, (String)key);
            return key2;
        }
        finally {
            NamespaceManager.set((String)originalNamespace);
        }
    }

    static SessionData createSessionFromEntity(Entity entity) {
        SessionData data = new SessionData();
        data.setExpirationTime(((Long)entity.getProperty(EXPIRES_PROP)).longValue());
        Blob valueBlob = (Blob)entity.getProperty(VALUES_PROP);
        Map valueMap = (Map)SessionManagerUtil.deserialize(valueBlob.getBytes());
        data.setValueMap(valueMap);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Entity createEntityForSession(String key, SessionData data) {
        String originalNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Entity entity = new Entity(SESSION_ENTITY_TYPE, key);
            entity.setProperty(EXPIRES_PROP, (Object)data.getExpirationTime());
            entity.setProperty(VALUES_PROP, (Object)new Blob(SessionManagerUtil.serialize(data.getValueMap())));
            Entity entity2 = entity;
            return entity2;
        }
        finally {
            NamespaceManager.set((String)originalNamespace);
        }
    }

    @Override
    public SessionData getSession(String key) {
        try {
            Entity entity = this.datastore.get(DatastoreSessionStore.createKeyForSession(key));
            ((GoogleLogger.Api)logger.atFinest()).log("Loaded session %s from datastore.", (Object)key);
            return DatastoreSessionStore.createSessionFromEntity(entity);
        }
        catch (EntityNotFoundException ex) {
            ((GoogleLogger.Api)logger.atFine()).log("Unable to find specified session %s", (Object)key);
            return null;
        }
    }

    @Override
    public void saveSession(String key, SessionData data) throws SessionStore.Retryable {
        try {
            this.datastore.put(DatastoreSessionStore.createEntityForSession(key, data));
        }
        catch (DatastoreTimeoutException e) {
            throw new SessionStore.Retryable((RuntimeException)((Object)e));
        }
    }

    @Override
    public void deleteSession(String key) {
        this.datastore.delete(new Key[]{DatastoreSessionStore.createKeyForSession(key)});
    }
}

