/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineApplicationXml;
import com.google.apphosting.utils.config.AppEngineApplicationXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYamlProcessor;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.ApplicationXmlReader;
import com.google.apphosting.utils.config.EarInfo;
import com.google.apphosting.utils.config.WebModule;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import com.google.apphosting.utils.config.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class EarHelper {
    private static final Logger LOGGER = Logger.getLogger(EarHelper.class.getName());
    private static final AppEngineApplicationXmlReader APP_ENGINE_APPLICATION_XML_READER = new AppEngineApplicationXmlReader();
    private static final ApplicationXmlReader APPLICATION_XML_READER = new ApplicationXmlReader();
    private static final String META_INF = "META-INF";
    private static final String APPENGINE_APPLICATION_XML_NAME = "appengine-application.xml";
    private static final String APPLICATION_XML_NAME = "application.xml";

    public static boolean isEar(String dir) {
        return EarHelper.isEar(dir, true);
    }

    public static boolean isEar(String directory, boolean logWhyNot) {
        if (directory == null) {
            if (logWhyNot) {
                LOGGER.fine("Directory 'null' is not an EAR directory. ");
            }
            return false;
        }
        File metaInf = new File(directory, META_INF);
        if (!EarHelper.hasFile(metaInf, APPENGINE_APPLICATION_XML_NAME)) {
            EarHelper.logNotAnEar(directory.toString(), APPENGINE_APPLICATION_XML_NAME, logWhyNot);
            return false;
        }
        if (!EarHelper.hasFile(metaInf, APPLICATION_XML_NAME)) {
            EarHelper.logNotAnEar(directory.toString(), APPLICATION_XML_NAME, logWhyNot);
            return false;
        }
        return true;
    }

    private static void logNotAnEar(String dir, String missingFile, boolean withLogging) {
        if (withLogging) {
            LOGGER.fine("Directory '" + dir + "' is not an EAR directory. File " + new File(dir, missingFile) + " not detected.");
        }
    }

    private static void reportConfigException(String message) {
        LOGGER.info(message);
        throw new AppEngineConfigException(message);
    }

    public static EarInfo readEarInfo(String earDirectoryPath, File schemaFile) throws AppEngineConfigException {
        if (!EarHelper.isEar(earDirectoryPath)) {
            throw new IllegalArgumentException("earDir '" + earDirectoryPath + "' is not a valid EAR directory.");
        }
        File earDirectory = new File(earDirectoryPath).getAbsoluteFile();
        File metaInf = new File(earDirectory, META_INF);
        XmlUtils.validateXml(new File(metaInf, APPENGINE_APPLICATION_XML_NAME).getAbsolutePath(), schemaFile);
        AppEngineApplicationXml appEngineApplicationXml = APP_ENGINE_APPLICATION_XML_READER.processXml(EarHelper.getInputStream(metaInf, APPENGINE_APPLICATION_XML_NAME));
        ApplicationXml applicationXml = APPLICATION_XML_READER.processXml(EarHelper.getInputStream(metaInf, APPLICATION_XML_NAME));
        String applicationId = appEngineApplicationXml.getApplicationId();
        ImmutableList.Builder moduleListBuilder = ImmutableList.builder();
        for (ApplicationXml.Modules.Web web : applicationXml.getModules().getWeb()) {
            File serviceDirectory = EarHelper.getServiceDirectory(earDirectory, web.getWebUri());
            WebModule webModule = EarHelper.readWebModule(web.getContextRoot(), serviceDirectory, null, null, "");
            if (!applicationId.equals(webModule.getAppEngineWebXml().getAppId())) {
                LOGGER.info("Application id '" + appEngineApplicationXml.getApplicationId() + "' from '" + new File(metaInf, APPENGINE_APPLICATION_XML_NAME) + "' is overriding  application id '" + webModule.getAppEngineWebXml().getAppId() + "' from '" + new File(serviceDirectory, "WEB-INF/appengine-web.xml") + "'");
                webModule.getAppEngineWebXml().setAppId(applicationId);
            }
            moduleListBuilder.add((Object)webModule);
        }
        ImmutableList webModules = moduleListBuilder.build();
        if (webModules.size() == 0) {
            EarHelper.reportConfigException("At least one web module is required in '" + new File(metaInf, APPLICATION_XML_NAME) + "'");
        }
        return new EarInfo(earDirectory, appEngineApplicationXml, applicationXml, (List<WebModule>)webModules);
    }

    public static WebModule readWebModule(@Nullable String contextRoot, File applicationDirectory, @Nullable File appengineWebXmlFile, @Nullable File webXmlFile, String appIdPrefix) throws AppEngineConfigException {
        AppEngineWebXml appEngineWebXml;
        Preconditions.checkNotNull((Object)appIdPrefix);
        AppEngineWebXmlReader appEngineWebXmlReader = EarHelper.newAppEngineWebXmlReader(applicationDirectory, appengineWebXmlFile);
        String webXmlFileLocation = webXmlFile == null ? new File(applicationDirectory, "WEB-INF/web.xml").getAbsolutePath() : webXmlFile.getAbsolutePath();
        AppYamlProcessor.convert(new File(applicationDirectory, "WEB-INF"), appEngineWebXmlReader.getFilename(), webXmlFileLocation);
        try {
            appEngineWebXml = appEngineWebXmlReader.readAppEngineWebXml();
        }
        catch (AppEngineConfigException aece) {
            throw new AppEngineConfigException(String.format("Invalid appengine-web.xml(%s) - %s", appEngineWebXmlReader.getFilename(), aece.getMessage()));
        }
        String appId = appEngineWebXml.getAppId();
        if (appId != null) {
            appEngineWebXml.setAppId(appIdPrefix + appEngineWebXml.getAppId());
        }
        WebXmlReader webXmlReader = EarHelper.newWebXmlReader(applicationDirectory, webXmlFile, appEngineWebXml.isWebXmlRequired());
        WebXml webXml = webXmlReader.readWebXml();
        WebModule webModule = new WebModule(applicationDirectory, appEngineWebXml, new File(appEngineWebXmlReader.getFilename()), webXml, new File(webXmlReader.getFilename()), contextRoot);
        return webModule;
    }

    @VisibleForTesting
    static File getServiceDirectory(File earDirectory, String contextRoot) {
        String absoluteURI = "file:";
        File serviceDirectory = null;
        if (contextRoot.startsWith(absoluteURI)) {
            try {
                serviceDirectory = new File(new URI(contextRoot));
            }
            catch (URISyntaxException e) {
                EarHelper.reportConfigException("Service directory '" + contextRoot + "' is not a valid URI.");
            }
        } else {
            serviceDirectory = new File(earDirectory, contextRoot);
        }
        if (!serviceDirectory.exists() || !serviceDirectory.isDirectory()) {
            EarHelper.reportConfigException("Service directory '" + serviceDirectory + "' must exist and be a directory.");
        }
        return serviceDirectory;
    }

    private static AppEngineWebXmlReader newAppEngineWebXmlReader(File applicationDirectory, File appEngineWebXmlFile) {
        return appEngineWebXmlFile == null ? new AppEngineWebXmlReader(applicationDirectory.getAbsolutePath()) : new AppEngineWebXmlReader(appEngineWebXmlFile.getParent(), appEngineWebXmlFile.getName());
    }

    private static WebXmlReader newWebXmlReader(File applicationDirectory, File webXmlFile, boolean isRequired) {
        return webXmlFile == null ? new WebXmlReader(applicationDirectory.getAbsolutePath(), isRequired) : new WebXmlReader(webXmlFile.getParent(), webXmlFile.getName(), isRequired);
    }

    private static InputStream getInputStream(File parent, String fileName) {
        File file = new File(parent, fileName);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException("File should exist - '" + file + "'");
        }
    }

    private static boolean hasFile(File parent, String child) {
        File file = new File(parent, child);
        return file.isFile();
    }
}

