/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class GetIndexesRequestChecker {
    public static int checkLimit(int limit) {
        Preconditions.checkArgument((limit >= 1 && limit <= 1000 ? 1 : 0) != 0, (String)"The limit %s must be between 1 and %s", (int)limit, (int)1000);
        return limit;
    }

    public static int checkOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 && offset <= 1000 ? 1 : 0) != 0, (String)"The limit %s must be between 1 and %s", (int)offset, (int)1000);
        return offset;
    }

    public static String checkIndexNamePrefix(String indexNamePrefix) {
        if (Strings.isNullOrEmpty((String)indexNamePrefix)) {
            return indexNamePrefix;
        }
        return IndexChecker.checkName(indexNamePrefix);
    }

    public static String checkStartIndexName(String startIndexName) {
        if (Strings.isNullOrEmpty((String)startIndexName)) {
            return startIndexName;
        }
        return IndexChecker.checkName(startIndexName);
    }

    public static SearchServicePb.ListIndexesParams checkListIndexesParams(SearchServicePb.ListIndexesParams params) {
        if (params.hasLimit()) {
            GetIndexesRequestChecker.checkLimit(params.getLimit());
        }
        if (params.hasNamespace()) {
            NamespaceManager.validateNamespace(params.getNamespace());
        }
        if (params.hasStartIndexName()) {
            GetIndexesRequestChecker.checkStartIndexName(params.getStartIndexName());
        }
        if (params.hasIndexNamePrefix()) {
            Preconditions.checkArgument((!params.getAllNamespaces() ? 1 : 0) != 0, (Object)"all_namespaces cannot be used in conjunction with index_name_prefix");
            GetIndexesRequestChecker.checkIndexNamePrefix(params.getIndexNamePrefix());
        }
        if (params.hasOffset()) {
            GetIndexesRequestChecker.checkOffset(params.getOffset());
        }
        return params;
    }
}

