/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.apphosting.api.search.DocumentPb;
import com.google.common.base.Preconditions;

public class GeoPointChecker {
    public static double checkLatitude(double latitude) {
        Preconditions.checkArgument((-90.0 <= latitude && latitude <= 90.0 ? 1 : 0) != 0, (String)"latitude %s must be between %s and %s", (Object)latitude, (Object)-90.0, (Object)90.0);
        return latitude;
    }

    public static double checkLongitude(double longitude) {
        Preconditions.checkArgument((-180.0 <= longitude && longitude <= 180.0 ? 1 : 0) != 0, (String)"longitude %s must be between %s and %s", (Object)longitude, (Object)-180.0, (Object)180.0);
        return longitude;
    }

    public static DocumentPb.FieldValue.Geo checkValid(DocumentPb.FieldValue.Geo geoPb) {
        GeoPointChecker.checkLatitude(geoPb.getLat());
        GeoPointChecker.checkLongitude(geoPb.getLng());
        return geoPb;
    }
}

