/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.DateUtil;
import com.google.appengine.api.search.checkers.GeoPointChecker;
import com.google.appengine.api.search.checkers.SearchApiLimits;
import com.google.appengine.api.search.query.ExpressionTreeBuilder;
import com.google.apphosting.api.search.DocumentPb;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.antlr.runtime.RecognitionException;

public final class FieldChecker {
    public static String checkFieldName(String name) {
        return FieldChecker.checkFieldName(name, "field name");
    }

    public static String checkFieldName(String name, String fieldName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"%s cannot be null or empty", (Object)fieldName);
        Preconditions.checkArgument((FieldChecker.bytesInString(name) <= 500 ? 1 : 0) != 0, (String)"%s longer than %s: %s", (Object)fieldName, (Object)500, (Object)name);
        Preconditions.checkArgument((boolean)name.matches("^[A-Za-z][A-Za-z0-9_]*$"), (String)"%s should match pattern %s: %s", (Object)fieldName, (Object)"^[A-Za-z][A-Za-z0-9_]*$", (Object)name);
        return name;
    }

    static int bytesInString(String str) {
        return str.getBytes(StandardCharsets.UTF_8).length;
    }

    static boolean nameMatchesPattern(String name) {
        return name.matches("^[A-Za-z][A-Za-z0-9_]*$");
    }

    public static String checkText(String text) {
        if (text != null) {
            Preconditions.checkArgument((FieldChecker.bytesInString(text) <= 0x100000 ? 1 : 0) != 0, (String)"Field text longer than maximum length %s", (int)0x100000);
        }
        return text;
    }

    public static String checkHTML(String html) {
        if (html != null) {
            Preconditions.checkArgument((FieldChecker.bytesInString(html) <= 0x100000 ? 1 : 0) != 0, (String)"html longer than maximum length %s", (int)0x100000);
        }
        return html;
    }

    public static String checkAtom(String atom) {
        if (atom != null) {
            Preconditions.checkArgument((FieldChecker.bytesInString(atom) <= 500 ? 1 : 0) != 0, (String)"Field atom longer than maximum length %s", (int)500);
        }
        return atom;
    }

    public static String checkPrefix(String prefix) {
        if (prefix != null) {
            Preconditions.checkArgument((FieldChecker.bytesInString(prefix) <= 500 ? 1 : 0) != 0, (String)"Field prefix longer than maximum length %s", (int)500);
        }
        return prefix;
    }

    public static List<Double> checkVector(List<Double> vector) {
        Preconditions.checkArgument((vector.size() <= 10000 ? 1 : 0) != 0, (String)"Vector size greater than %s", (int)10000);
        for (Double d : vector) {
            Preconditions.checkNotNull((Object)d, (Object)"Vector element cannot be null");
            Preconditions.checkArgument((!d.isNaN() && !d.isInfinite() ? 1 : 0) != 0, (Object)"Vector element should be a finite number");
        }
        return vector;
    }

    public static Double checkNumber(Double value) {
        if (value != null) {
            Preconditions.checkArgument((-2.147483647E9 <= value ? 1 : 0) != 0, (String)"number value, %s, must be greater than or equal to %s", (Object)value, (Object)-2.147483647E9);
            Preconditions.checkArgument((value <= 2.147483647E9 ? 1 : 0) != 0, (String)"number value, %s, must be less than or equal to %s", (Object)value, (Object)2.147483647E9);
        }
        return value;
    }

    public static Date checkDate(Date date) throws IllegalArgumentException {
        if (date != null) {
            Preconditions.checkArgument((SearchApiLimits.MINIMUM_DATE_VALUE.compareTo(date) <= 0 ? 1 : 0) != 0, (String)"date %s must be after %s", (Object)DateUtil.formatDateTime(date), (Object)DateUtil.formatDateTime(SearchApiLimits.MINIMUM_DATE_VALUE));
            Preconditions.checkArgument((date.compareTo(SearchApiLimits.MAXIMUM_DATE_VALUE) <= 0 ? 1 : 0) != 0, (String)"date %s must be before %s", (Object)DateUtil.formatDateTime(date), (Object)DateUtil.formatDateTime(SearchApiLimits.MAXIMUM_DATE_VALUE));
        }
        return date;
    }

    private static String checkExpressionHelper(String expression, String mode) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression cannot be null");
        ExpressionTreeBuilder parser = new ExpressionTreeBuilder();
        try {
            parser.parse(expression);
        }
        catch (RecognitionException e) {
            String message = String.format("Failed to parse %s expression '%s': parse error at line %d position %d", mode, expression, e.line, e.charPositionInLine);
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static String checkExpression(String expression) {
        return FieldChecker.checkExpressionHelper(expression, "field");
    }

    public static String checkSortExpression(String expression) {
        return FieldChecker.checkExpressionHelper(expression, "sort");
    }

    public static DocumentPb.Field checkValid(DocumentPb.Field field) {
        FieldChecker.checkFieldName(field.getName());
        DocumentPb.FieldValue value = field.getValue();
        switch (value.getType()) {
            case TEXT: {
                FieldChecker.checkText(value.getStringValue());
                break;
            }
            case HTML: {
                FieldChecker.checkHTML(value.getStringValue());
                break;
            }
            case DATE: {
                FieldChecker.checkDate(DateUtil.deserializeDate(value.getStringValue()));
                break;
            }
            case ATOM: {
                FieldChecker.checkAtom(value.getStringValue());
                break;
            }
            case NUMBER: {
                FieldChecker.checkNumber(Double.parseDouble(value.getStringValue()));
                break;
            }
            case GEO: {
                GeoPointChecker.checkValid(value.getGeo());
                break;
            }
            case UNTOKENIZED_PREFIX: 
            case TOKENIZED_PREFIX: {
                FieldChecker.checkPrefix(value.getStringValue());
                break;
            }
            case VECTOR: {
                FieldChecker.checkVector(value.getVectorValueList());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type " + value.getType());
            }
        }
        return field;
    }

    public static Locale parseLocale(String locale) {
        if (locale == null) {
            return null;
        }
        String[] parts = locale.split("_", 3);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        throw new IllegalArgumentException("Cannot parse locale " + locale);
    }
}

