/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.DateUtil;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SortExpression {
    public static final String DOCUMENT_ID_FIELD_NAME = "_doc_id";
    public static final String LANGUAGE_FIELD_NAME = "_lang";
    public static final String RANK_FIELD_NAME = "_rank";
    public static final String SCORE_FIELD_NAME = "_score";
    public static final String TIMESTAMP_FIELD_NAME = "_timestamp";
    private final SortDirection direction;
    private final String expression;
    private final String defaultValue;
    private final Double defaultValueNumeric;
    private final Date defaultValueDate;

    private SortExpression(Builder builder) {
        this.expression = builder.expression;
        this.direction = Util.defaultIfNull(builder.direction, SortDirection.DESCENDING);
        this.defaultValue = builder.defaultValue;
        this.defaultValueNumeric = builder.defaultValueNumeric;
        this.defaultValueDate = builder.defaultValueDate;
        this.checkValid();
    }

    public String getExpression() {
        return this.expression;
    }

    public SortDirection getDirection() {
        return this.direction;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Double getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public Date getDefaultValueDate() {
        return this.defaultValueDate;
    }

    private SortExpression checkValid() {
        Preconditions.checkNotNull((Object)this.expression, (Object)"expression cannot be null");
        int defaultValueCount = 0;
        if (this.defaultValue != null) {
            ++defaultValueCount;
        }
        if (this.defaultValueNumeric != null) {
            ++defaultValueCount;
        }
        if (this.defaultValueDate != null) {
            ++defaultValueCount;
        }
        Preconditions.checkArgument((defaultValueCount <= 1 ? 1 : 0) != 0, (Object)"At most one default value can be specified for the SortExpression");
        if (this.defaultValue != null) {
            FieldChecker.checkText(this.defaultValue);
        }
        return this;
    }

    SearchServicePb.SortSpec copyToProtocolBuffer() {
        SearchServicePb.SortSpec.Builder builder = SearchServicePb.SortSpec.newBuilder();
        if (SortDirection.ASCENDING.equals((Object)this.getDirection())) {
            builder.setSortDescending(false);
        }
        builder.setSortExpression(this.getExpression());
        if (this.getDefaultValue() != null) {
            builder.setDefaultValueText(this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            builder.setDefaultValueNumeric(this.getDefaultValueNumeric().doubleValue());
        }
        if (this.getDefaultValueDate() != null) {
            builder.setDefaultValueText(DateUtil.serializeDate(this.getDefaultValueDate()));
        }
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return new Util.ToStringHelper("SortExpression").addField("direction", (Object)this.direction).addField("expression", this.expression).addField("defaultValue", this.defaultValue).addField("defaultValueNumeric", this.defaultValueNumeric).addField("defaultValueDate", this.defaultValueDate).finish();
    }

    public static final class Builder {
        private String expression;
        private SortDirection direction;
        private @Nullable String defaultValue;
        private @Nullable Double defaultValueNumeric;
        private @Nullable Date defaultValueDate;

        private Builder() {
        }

        public Builder setExpression(String expression) {
            this.expression = FieldChecker.checkSortExpression(expression);
            return this;
        }

        public Builder setDirection(SortDirection direction) {
            this.direction = direction;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = FieldChecker.checkText(defaultValue);
            return this;
        }

        public Builder setDefaultValueNumeric(double defaultValue) {
            this.defaultValueNumeric = defaultValue;
            return this;
        }

        public Builder setDefaultValueDate(Date defaultValue) {
            this.defaultValueDate = FieldChecker.checkDate(defaultValue);
            return this;
        }

        public SortExpression build() {
            return new SortExpression(this);
        }
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

