/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemcacheSerialization {
    static final int MAX_KEY_BYTE_COUNT = 250;
    private static final byte FALSE_VALUE = 48;
    private static final byte TRUE_VALUE = 49;
    private static final String MYCLASSNAME = MemcacheSerialization.class.getName();
    private static final MessageDigest sha1Prototype;
    public static final String USE_THREAD_CONTEXT_CLASSLOADER_PROPERTY = "appengine.api.memcache.useThreadContextClassLoader";

    private MemcacheSerialization() {
    }

    public static Object deserialize(byte[] value, int flags) throws ClassNotFoundException, IOException {
        Flag flagval = Flag.fromInt(flags);
        switch (flagval) {
            case BYTES: {
                return value;
            }
            case BOOLEAN: {
                if (value.length != 1) {
                    throw new InvalidValueException("Cannot deserialize Boolean: bad length", null);
                }
                switch (value[0]) {
                    case 49: {
                        return Boolean.TRUE;
                    }
                    case 48: {
                        return Boolean.FALSE;
                    }
                }
                throw new InvalidValueException("Cannot deserialize Boolean: bad contents", null);
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                long val = new BigInteger(new String(value, StandardCharsets.US_ASCII)).longValue();
                switch (flagval) {
                    case BYTE: {
                        return (byte)val;
                    }
                    case SHORT: {
                        return (short)val;
                    }
                    case INTEGER: {
                        return (int)val;
                    }
                    case LONG: {
                        return val;
                    }
                }
                throw new InvalidValueException("Cannot deserialize number: bad contents", null);
            }
            case UTF8: {
                return new String(value, StandardCharsets.UTF_8);
            }
            case OBJECT: {
                if (value.length == 0) {
                    return null;
                }
                ByteArrayInputStream baos = new ByteArrayInputStream(value);
                ObjectInputStream objIn = null;
                objIn = UseThreadContextClassLoaderHolder.INSTANCE ? new ObjectInputStream(baos){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
                        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                        if (threadClassLoader == null) {
                            return super.resolveClass(objectStreamClass);
                        }
                        try {
                            return Class.forName(objectStreamClass.getName(), false, threadClassLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            return super.resolveClass(objectStreamClass);
                        }
                    }
                } : new ObjectInputStream(baos);
                Object response = objIn.readObject();
                objIn.close();
                return response;
            }
        }
        assert (false);
        return null;
    }

    private static boolean noEmbeddedNulls(byte[] key) {
        return !Bytes.contains((byte[])key, (byte)0);
    }

    public static byte[] makePbKey(Object key) throws IOException {
        if (key == null) {
            return new byte[0];
        }
        if (key instanceof String && ((String)key).length() <= 248) {
            byte[] bytes = ("\"" + key + "\"").getBytes(StandardCharsets.UTF_8);
            if (bytes.length <= 250) {
                return bytes;
            }
        } else if (key instanceof byte[]) {
            byte[] bytes = (byte[])key;
            if (bytes.length <= 250 && MemcacheSerialization.noEmbeddedNulls(bytes)) {
                return bytes;
            }
        } else {
            if (key instanceof Long || key instanceof Integer || key instanceof Short || key instanceof Byte) {
                return (key.getClass().getName() + ":" + key).getBytes(StandardCharsets.UTF_8);
            }
            if (key instanceof Boolean) {
                return ((Boolean)key != false ? "true" : "false").getBytes(StandardCharsets.UTF_8);
            }
        }
        return MemcacheSerialization.hash(key);
    }

    private static final byte[] hash(Object key) throws IOException {
        MessageDigest md;
        ValueAndFlags vaf = MemcacheSerialization.serialize(key);
        try {
            md = (MessageDigest)sha1Prototype.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        md.update(vaf.value);
        byte[] sha1hash = md.digest();
        return BaseEncoding.base64().encode(sha1hash).getBytes(StandardCharsets.UTF_8);
    }

    public static ValueAndFlags serialize(Object value) throws IOException {
        Flag flags;
        byte[] bytes;
        if (value == null) {
            bytes = new byte[]{};
            flags = Flag.OBJECT;
        } else if (value instanceof byte[]) {
            flags = Flag.BYTES;
            bytes = (byte[])value;
        } else if (value instanceof Boolean) {
            flags = Flag.BOOLEAN;
            bytes = new byte[]{(Boolean)value != false ? (byte)49 : 48};
        } else if (value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Short) {
            bytes = value.toString().getBytes(StandardCharsets.US_ASCII);
            flags = value instanceof Integer ? Flag.INTEGER : (value instanceof Long ? Flag.LONG : (value instanceof Byte ? Flag.BYTE : Flag.SHORT));
        } else if (value instanceof String) {
            flags = Flag.UTF8;
            bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
        } else if (value instanceof Serializable) {
            flags = Flag.OBJECT;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(baos);
            objOut.writeObject(value);
            objOut.close();
            bytes = baos.toByteArray();
        } else {
            throw new IllegalArgumentException("can't accept " + value.getClass() + " as a memcache entity");
        }
        return new ValueAndFlags(bytes, flags);
    }

    static {
        try {
            sha1Prototype = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MYCLASSNAME).log(Level.SEVERE, "Can't load SHA-1 MessageDigest!", ex);
            throw new MemcacheServiceException("No SHA-1 algorithm, cannot hash keys for memcache", ex);
        }
    }

    private static class UseThreadContextClassLoaderHolder {
        static final boolean INSTANCE = Boolean.getBoolean("appengine.api.memcache.useThreadContextClassLoader");

        private UseThreadContextClassLoaderHolder() {
        }
    }

    public static class ValueAndFlags {
        public final byte[] value;
        public final Flag flags;

        private ValueAndFlags(byte[] value, Flag flags) {
            this.value = value;
            this.flags = flags;
        }
    }

    public static enum Flag {
        BYTES,
        UTF8,
        OBJECT,
        INTEGER,
        LONG,
        BOOLEAN,
        BYTE,
        SHORT;

        private static final Flag[] VALUES;

        public static Flag fromInt(int i) {
            if (i < 0 || i >= VALUES.length) {
                throw new IllegalArgumentException();
            }
            return VALUES[i];
        }

        static {
            VALUES = Flag.values();
        }
    }
}

