/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.ByteRange;
import com.google.appengine.api.blobstore.RangeFormatException;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class ServeBlobFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ServeBlobFilter.class.getName());
    static final String SERVE_HEADER = "X-AppEngine-BlobKey";
    static final String BLOB_RANGE_HEADER = "X-AppEngine-BlobRange";
    static final String CONTENT_RANGE_HEADER = "Content-range";
    static final String RANGE_HEADER = "Range";
    static final String CONTENT_TYPE_HEADER = "Content-type";
    static final String CONTENT_RANGE_FORMAT = "bytes %d-%d/%d";
    private static final int BUF_SIZE = 4096;
    private BlobStorage blobStorage;
    private BlobInfoStorage blobInfoStorage;
    private ApiProxyLocal apiProxyLocal;

    public void init(FilterConfig config) {
        this.blobInfoStorage = BlobStorageFactory.getBlobInfoStorage();
        this.apiProxyLocal = (ApiProxyLocal)config.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper wrapper = new ResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrapper);
        BlobKey blobKey = wrapper.getBlobKey();
        if (blobKey != null) {
            this.serveBlob(blobKey, wrapper.hasContentType(), (HttpServletRequest)request, (HttpServletResponse)wrapper);
        }
    }

    public void destroy() {
    }

    private BlobStorage getBlobStorage() {
        if (this.blobStorage == null) {
            this.apiProxyLocal.getService("blobstore");
            this.blobStorage = BlobStorageFactory.getBlobStorage();
        }
        return this.blobStorage;
    }

    private void calculateContentRange(BlobInfo blobInfo, HttpServletRequest request, HttpServletResponse response) throws RangeFormatException {
        ResponseWrapper responseWrapper = (ResponseWrapper)response;
        String contentRangeHeader = request.getHeader(CONTENT_RANGE_HEADER);
        long blobSize = blobInfo.getSize();
        String rangeHeader = responseWrapper.getBlobRangeHeader();
        if (rangeHeader != null) {
            if (rangeHeader.isEmpty()) {
                response.setHeader(BLOB_RANGE_HEADER, null);
                rangeHeader = null;
            }
        } else {
            rangeHeader = request.getHeader(RANGE_HEADER);
        }
        if (rangeHeader != null) {
            ByteRange byteRange = ByteRange.parse((String)rangeHeader);
            if (byteRange.hasEnd()) {
                contentRangeHeader = String.format(CONTENT_RANGE_FORMAT, byteRange.getStart(), byteRange.getEnd(), blobSize);
            } else {
                long contentRangeStart = byteRange.getStart() >= 0L ? byteRange.getStart() : blobSize + byteRange.getStart();
                contentRangeHeader = String.format(CONTENT_RANGE_FORMAT, contentRangeStart, blobSize - 1L, blobSize);
            }
            response.setHeader(CONTENT_RANGE_HEADER, contentRangeHeader);
        }
    }

    private static void copy(InputStream from, OutputStream to, long size) throws IOException {
        byte[] buf = new byte[4096];
        while (size > 0L) {
            int r = from.read(buf);
            if (r == -1) {
                return;
            }
            to.write(buf, 0, (int)Math.min((long)r, size));
            size -= (long)r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveBlob(BlobKey blobKey, boolean hasContentType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            logger.severe("Asked to send blob " + blobKey + " but response was already committed.");
            return;
        }
        BlobInfo blobInfo = this.blobInfoStorage.loadBlobInfo(blobKey);
        if (blobInfo == null) {
            blobInfo = this.blobInfoStorage.loadGsFileInfo(blobKey);
        }
        if (blobInfo == null) {
            logger.severe("Could not find blob: " + blobKey);
            response.sendError(404);
            return;
        }
        if (!this.getBlobStorage().hasBlob(blobKey)) {
            logger.severe("Blob " + blobKey + " missing. Did you delete the file?");
            response.sendError(404);
            return;
        }
        if (!hasContentType) {
            response.setContentType(this.getContentType(blobKey));
        }
        try {
            this.calculateContentRange(blobInfo, request, response);
            String contentRange = ((ResponseWrapper)response).getContentRangeHeader();
            long contentLength = blobInfo.getSize();
            long start = 0L;
            if (contentRange != null) {
                ByteRange byteRange = ByteRange.parseContentRange((String)contentRange);
                start = byteRange.getStart();
                contentLength = byteRange.getEnd() - byteRange.getStart() + 1L;
                response.setStatus(206);
            }
            response.setHeader("Content-Length", Long.toString(contentLength));
            boolean swallowDueToThrow = true;
            InputStream inStream = this.getBlobStorage().fetchBlob(blobKey);
            try {
                ServletOutputStream outStream = response.getOutputStream();
                try {
                    inStream.skip(start);
                    ServeBlobFilter.copy(inStream, (OutputStream)outStream, contentLength);
                    swallowDueToThrow = false;
                }
                finally {
                    Closeables.close((Closeable)outStream, (boolean)swallowDueToThrow);
                }
            }
            finally {
                Closeables.close((Closeable)inStream, (boolean)swallowDueToThrow);
            }
        }
        catch (RangeFormatException ex) {
            response.setStatus(416);
            return;
        }
    }

    private String getContentType(BlobKey blobKey) {
        BlobInfo blobInfo = this.blobInfoStorage.loadBlobInfo(blobKey);
        if (blobInfo != null) {
            return blobInfo.getContentType();
        }
        return "application/octet-stream";
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private BlobKey blobKey;
        private boolean hasContentType;
        private String contentRangeHeader;
        private String blobRangeHeader;

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setContentType(String contentType) {
            super.setContentType(contentType);
            this.hasContentType = true;
        }

        public void addHeader(String name, String value) {
            if (name.equalsIgnoreCase(ServeBlobFilter.SERVE_HEADER)) {
                this.blobKey = new BlobKey(value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.CONTENT_RANGE_HEADER)) {
                this.contentRangeHeader = value;
                super.addHeader(name, value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.BLOB_RANGE_HEADER)) {
                this.blobRangeHeader = value;
                super.addHeader(name, value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.CONTENT_TYPE_HEADER)) {
                this.hasContentType = true;
                super.addHeader(name, value);
            } else {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (name.equalsIgnoreCase(ServeBlobFilter.SERVE_HEADER)) {
                this.blobKey = new BlobKey(value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.CONTENT_RANGE_HEADER)) {
                this.contentRangeHeader = value;
                super.setHeader(name, value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.BLOB_RANGE_HEADER)) {
                this.blobRangeHeader = value;
            } else if (name.equalsIgnoreCase(ServeBlobFilter.CONTENT_TYPE_HEADER)) {
                this.hasContentType = true;
                super.setHeader(name, value);
            } else {
                super.setHeader(name, value);
            }
        }

        public boolean containsHeader(String name) {
            if (name.equals(ServeBlobFilter.SERVE_HEADER)) {
                return this.blobKey != null;
            }
            return super.containsHeader(name);
        }

        public BlobKey getBlobKey() {
            return this.blobKey;
        }

        public boolean hasContentType() {
            return this.hasContentType;
        }

        public String getContentRangeHeader() {
            return this.contentRangeHeader;
        }

        public String getBlobRangeHeader() {
            return this.blobRangeHeader;
        }
    }
}

