/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.BaseDatastoreValidator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.EntityV4Helper;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityV4Validator
extends BaseDatastoreValidator {
    public static final EntityV4Validator DEFAULT = new EntityV4Validator(Config.DatastoreConfig.getDefaultInstance());
    private final Config.DatastoreConfig config;

    public EntityV4Validator(Config.DatastoreConfig config) {
        this.config = config;
    }

    public void validateEntities(ValidationConstraint constraint, Iterable<? extends EntityV4.EntityOrBuilder> entities) throws ValidationException {
        for (EntityV4.EntityOrBuilder entityOrBuilder : entities) {
            this.validateEntity(constraint, entityOrBuilder);
        }
    }

    public void validateKeys(ValidationConstraint constraint, Iterable<? extends EntityV4.KeyOrBuilder> keys) throws ValidationException {
        for (EntityV4.KeyOrBuilder keyOrBuilder : keys) {
            this.validateKey(constraint, keyOrBuilder);
        }
    }

    public void validateEntity(ValidationConstraint constraint, EntityV4.EntityOrBuilder entity) throws ValidationException {
        if (entity.hasKey()) {
            this.validateKey(constraint, (EntityV4.KeyOrBuilder)entity.getKey());
        } else {
            ValidationException.validateAssertion(constraint.absentKeyAllowed, "Entity is missing key.", new Object[0]);
        }
        HashSet propertyNameSet = Sets.newHashSet();
        for (EntityV4.PropertyOrBuilder property : entity.getPropertyList()) {
            String propertyName = property.getName();
            ValidationException.validateAssertion(propertyNameSet.add(propertyName), "Entity has duplicate property name \"%s\".", propertyName);
            this.validateProperty(constraint, property);
        }
    }

    public void validateKey(ValidationConstraint constraint, EntityV4.KeyOrBuilder key) throws ValidationException {
        boolean finalElementComplete;
        ValidationException.validateAssertion(key.hasPartitionId(), "Key is missing partition id.", new Object[0]);
        this.validatePartitionId(constraint, (EntityV4.PartitionIdOrBuilder)key.getPartitionId());
        int numKeyPathElements = key.getPathElementCount();
        ValidationException.validateAssertion(numKeyPathElements != 0, "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(numKeyPathElements <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        int numIncompleteElements = 0;
        for (EntityV4.Key.PathElementOrBuilder element : key.getPathElementList()) {
            this.validateStringUtf8(element.getKindBytes(), "key path kind");
            String kind = element.getKind();
            this.validateKind(constraint, kind);
            boolean elementHasName = element.hasName();
            if (element.hasId()) {
                ValidationException.validateAssertion(!elementHasName, "Key path element has both id (%d) and name (\"%s\").", element.getId(), element.getName());
                ValidationException.validateAssertion(element.getId() != 0L, "Key path id is invalid. Must not be zero.", new Object[0]);
                continue;
            }
            if (elementHasName) {
                this.validateStringUtf8(element.getNameBytes(), "key path element name");
                String name = element.getName();
                this.validateStringNotEmpty(name, "key path element name");
                this.validateStringNotTooLong(name, 500, "key path element name");
                if (constraint.reservedKeyAllowed) continue;
                this.validateStringNotReserved(name, "key path element name");
                continue;
            }
            ++numIncompleteElements;
        }
        EntityV4.Key.PathElementOrBuilder finalElement = key.getPathElementOrBuilder(numKeyPathElements - 1);
        boolean bl = finalElementComplete = finalElement.hasId() || finalElement.hasName();
        if (!constraint.completeKeyPathAllowed) {
            this.validateKeyAssertion(!finalElementComplete, "Key path element must not be complete", key);
        }
        if (!constraint.incompleteKeyPathAllowed) {
            this.validateKeyAssertion(finalElementComplete, "Key path element must not be incomplete", key);
        }
        this.validateKeyAssertion(numIncompleteElements == (finalElementComplete ? 0 : 1), "Key path element must not be incomplete", key);
    }

    public void validatePartitionId(ValidationConstraint constraint, EntityV4.PartitionIdOrBuilder partitionId) throws ValidationException {
        ValidationException.validateAssertion(partitionId.hasDatasetId(), "Partition id is missing dataset id.", new Object[0]);
        if (partitionId.hasDatasetId()) {
            this.validateStringUtf8(partitionId.getDatasetIdBytes(), "dataset id");
            this.validateAppName(constraint, partitionId.getDatasetId(), "dataset id");
        }
        if (partitionId.hasNamespace()) {
            this.validateStringUtf8(partitionId.getNamespaceBytes(), "namespace");
            this.validatePartitionIdDimension(constraint, partitionId.getNamespace(), "namespace");
        }
    }

    public void validateProperty(ValidationConstraint constraint, EntityV4.PropertyOrBuilder property) throws ValidationException {
        this.validateStringUtf8(property.getNameBytes(), "property name");
        String propertyName = property.getName();
        this.validatePropertyName(constraint, propertyName);
        if (property.hasDeprecatedMulti() || property.getDeprecatedValueCount() > 0) {
            ValidationException.validateAssertion(!property.hasValue(), "Property has both old and new value type", new Object[0]);
            int numValues = property.getDeprecatedValueCount();
            ValidationException.validateAssertion(numValues > 0, "Property \"%s\" has no value.", propertyName);
            ValidationException.validateAssertion(property.getDeprecatedMulti() || numValues == 1, "Single-valued property \"%s\" has many values.", propertyName);
            for (EntityV4.ValueOrBuilder value : property.getDeprecatedValueList()) {
                ValidationException.validateAssertion(value.getListValueCount() == 0, "Property has both old and new value type", new Object[0]);
                this.validateValue(constraint, value, propertyName);
            }
        } else {
            ValidationException.validateAssertion(property.hasValue(), "Property \"%s\" has no value.", propertyName);
            this.validateValue(constraint, property.getValueOrBuilder(), propertyName);
        }
    }

    public void validateGeoPoint(EntityV4.GeoPointOrBuilder geopoint) throws ValidationException {
        ValidationException.validateAssertion(Math.abs(geopoint.getLatitude()) <= 90.0, "Geo point latitude outside permitted range -90.0 to 90.0.", new Object[0]);
        ValidationException.validateAssertion(Math.abs(geopoint.getLongitude()) <= 180.0, "Geo point longitude outside permitted range -180.0 to 180.0.", new Object[0]);
    }

    void validateValue(ValidationConstraint constraint, EntityV4.ValueOrBuilder value, String desc) throws ValidationException {
        this.validateValueUnion(value, desc);
        if (value.hasStringValue()) {
            this.validateStringUtf8(value.getStringValueBytes(), "string value");
        } else if (value.hasBlobKeyValue()) {
            this.validateStringUtf8(value.getBlobKeyValueBytes(), "blob key value");
        } else if (value.hasKeyValue()) {
            this.validateKey(ValidationConstraint.KEY_IN_VALUE, (EntityV4.KeyOrBuilder)value.getKeyValue());
        } else if (value.hasEntityValue()) {
            this.validateEntity(constraint.getEntityInValueConstraint(), value.getEntityValueOrBuilder());
        } else if (value.getListValueCount() > 0) {
            ValidationException.validateAssertion(!value.hasIndexed(), "A Value containing a list_value cannot specify indexed.", new Object[0]);
            ValidationException.validateAssertion(!value.hasMeaning(), "A Value containing a list_value cannot specify a meaning.", new Object[0]);
            for (EntityV4.ValueOrBuilder subValue : value.getListValueList()) {
                ValidationException.validateAssertion(subValue.getListValueCount() == 0, "list_value cannot contain a Value containing another list_value.", new Object[0]);
                this.validateValue(constraint, subValue, desc);
            }
        } else if (value.hasBlobValue()) {
            ValidationException.validateAssertion(value.getBlobValue().size() <= this.config.getMaxRawPropertyBytes(), "The value \"%s\" contains a blob_value that is too long. It cannot exceed %s bytes.", desc, this.config.getMaxRawPropertyBytes());
        } else if (value.hasGeoPointValue()) {
            this.validateGeoPoint((EntityV4.GeoPointOrBuilder)value.getGeoPointValue());
        }
        this.validateValueMeaningMatchesUnion(value, desc);
        this.validateValueMeaningConstraints(constraint, value);
        this.validateValueIndexConstraints(value, desc);
    }

    private void validateValueUnion(EntityV4.ValueOrBuilder value, String propertyName) throws ValidationException {
        int numSubValues = 0;
        if (value.hasBooleanValue()) {
            ++numSubValues;
        }
        if (value.hasIntegerValue()) {
            ++numSubValues;
        }
        if (value.hasDoubleValue()) {
            ++numSubValues;
        }
        if (value.hasTimestampMicrosecondsValue()) {
            ++numSubValues;
        }
        if (value.hasKeyValue()) {
            ++numSubValues;
        }
        if (value.hasBlobKeyValue()) {
            ++numSubValues;
        }
        if (value.hasStringValue()) {
            ++numSubValues;
        }
        if (value.hasBlobValue()) {
            ++numSubValues;
        }
        if (value.hasEntityValue()) {
            ++numSubValues;
        }
        if (value.hasGeoPointValue()) {
            ++numSubValues;
        }
        if (value.getListValueCount() > 0) {
            ++numSubValues;
        }
        ValidationException.validateAssertion(numSubValues <= 1, "The value \"%s\" has multiple types set.", propertyName);
    }

    private void validateValueMeaningMatchesUnion(EntityV4.ValueOrBuilder value, String desc) throws ValidationException {
        if (!value.hasMeaning()) {
            return;
        }
        String message = "Value \"%s\" has a meaning %d which does not match %s field.";
        int meaning = value.getMeaning();
        switch (meaning) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                ValidationException.validateAssertion(value.hasStringValue(), message, desc, meaning, "string_value");
                break;
            }
            case 16: 
            case 22: {
                ValidationException.validateAssertion(value.hasBlobValue(), message, desc, meaning, "blob_value");
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.hasIntegerValue(), message, desc, meaning, "integer_value");
                break;
            }
            case 9: 
            case 20: 
            case 21: {
                ValidationException.validateAssertion(value.hasEntityValue(), message, desc, meaning, "entity_value");
                break;
            }
            case 18: {
                ValidationException.validateAssertion(!value.hasTimestampMicrosecondsValue(), message, desc, meaning, "timestamp_microseconds_value");
                ValidationException.validateAssertion(!value.hasBlobKeyValue(), message, desc, meaning, "blob_key_value");
                ValidationException.validateAssertion(!value.hasEntityValue(), message, desc, meaning, "entity_value");
                break;
            }
            default: {
                ValidationException.validateAssertion(false, "Unknown value meaning %s.", meaning);
            }
        }
    }

    private void validateValueMeaningConstraints(ValidationConstraint constraint, EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.hasMeaning()) {
            return;
        }
        switch (value.getMeaning()) {
            case 16: {
                ValidationException.validateAssertion(value.getBlobValue().size() <= 500, "Blob value with meaning %d has more than permitted %d bytes.", value.getMeaning(), 500);
                break;
            }
            case 15: 
            case 22: {
                ValidationException.validateAssertion(!value.getIndexed(), "Indexed value has meaning %d.", value.getMeaning());
                break;
            }
            case 2: {
                ValidationException.validateAssertion(value.getStringValue().length() <= 2038, "Url value has more than permitted %d characters.", 2038);
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.getIntegerValue() >= 0L && value.getIntegerValue() <= 100L, "Percent value outside permitted range [0, 100].", new Object[0]);
                break;
            }
            case 9: {
                Map<String, EntityV4.ValueOrBuilder> propertyMap = this.validatePredefinedValueEntity("geo point", (Map<String, Integer>)EntityV4Helper.PredefinedEntityPointConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                this.validateGeoPoint(propertyMap.get("x").getDoubleValue(), propertyMap.get("y").getDoubleValue());
                break;
            }
            case 21: {
                this.validatePredefinedValueEntity("point", (Map<String, Integer>)EntityV4Helper.PredefinedEntityPointConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 20: {
                this.validatePredefinedValueEntity("user", (Map<String, Integer>)EntityV4Helper.PredefinedEntityUserConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityUserConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 18: {
                ValidationException.validateAssertion(constraint.meaningIndexOnlyAllowed, "Projection property cannot be used.", new Object[0]);
            }
        }
    }

    private Map<String, EntityV4.ValueOrBuilder> validatePredefinedValueEntity(String predefinedEntityName, Map<String, Integer> allowedProperties, Set<String> requiredPropertyNameSet, EntityV4.EntityOrBuilder entity) throws ValidationException {
        ValidationException.validateAssertion(!entity.hasKey(), "The %s entity has a key.", predefinedEntityName);
        HashMap propertyMap = Maps.newHashMap();
        for (EntityV4.PropertyOrBuilder property : entity.getPropertyList()) {
            EntityV4.ValueOrBuilder value;
            String propertyName = property.getName();
            ValidationException.validateAssertion(allowedProperties.containsKey(propertyName), "The %s entity property \"%s\" is not allowed.", predefinedEntityName, propertyName);
            if (property.hasValue()) {
                value = property.getValueOrBuilder();
                ValidationException.validateAssertion(value.getListValueCount() == 0, "The %s entity property \"%s\" is multi-valued.", predefinedEntityName, propertyName);
            } else {
                ValidationException.validateAssertion(!property.getDeprecatedMulti(), "The %s entity property \"%s\" is multi-valued.", predefinedEntityName, propertyName);
                value = property.getDeprecatedValue(0);
            }
            boolean isValueRequiredType = value.hasField(EntityV4.Value.getDescriptor().findFieldByNumber(allowedProperties.get(propertyName).intValue()));
            ValidationException.validateAssertion(isValueRequiredType, "The %s entity property \"%s\" is the wrong type.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!value.hasMeaning(), "The %s entity property \"%s\" has a meaning.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!value.getIndexed(), "The %s entity property \"%s\" is indexed.", predefinedEntityName, propertyName);
            propertyMap.put(propertyName, value);
        }
        for (String requiredPropertyName : requiredPropertyNameSet) {
            ValidationException.validateAssertion(propertyMap.containsKey(requiredPropertyName), "The %s entity is missing required property \"%s\".", predefinedEntityName, requiredPropertyName);
        }
        return propertyMap;
    }

    private void validateValueIndexConstraints(EntityV4.ValueOrBuilder value, String propertyName) throws ValidationException {
        if (!value.getIndexed()) {
            return;
        }
        if (value.hasStringValue() && value.getMeaning() != 2) {
            ValidationException.validateAssertion(value.getStringValue().length() <= 500, "The string property %s has a value that is too long. It cannot exceed %d characters.", propertyName, 500);
        } else if (value.hasBlobValue()) {
            ValidationException.validateAssertion(value.getBlobValue().size() <= 500, "Indexed blob value has more than permitted %d bytes.", 500);
        } else if (value.hasEntityValue()) {
            ValidationException.validateAssertion(value.hasMeaning(), "Entity value is indexed.", new Object[0]);
        }
    }

    private void validateKeyAssertion(boolean assertion, String message, EntityV4.KeyOrBuilder key) throws ValidationException {
        if (!assertion) {
            String string = Paths.toPathString(key);
            throw new ValidationException(new StringBuilder(2 + String.valueOf(message).length() + String.valueOf(string).length()).append(message).append(": ").append(string).toString());
        }
    }
}

