/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.Paths;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntityProtoConverter {
    public static final EntityProtoConverter V1BETA2 = new EntityProtoConverter(false);
    public static final EntityProtoConverter V1BETA3 = new EntityProtoConverter(true);
    public static final EntityProtoConverter DEFAULT = V1BETA2;
    private final boolean useGeoPoint;

    private EntityProtoConverter(boolean useGeoPoint) {
        this.useGeoPoint = useGeoPoint;
    }

    public OnestoreEntity.Reference toV3Reference(EntityV4.KeyOrBuilder keyV4) {
        EntityV4.PartitionId partitionId = keyV4.getPartitionId();
        OnestoreEntity.Reference referenceV3 = new OnestoreEntity.Reference();
        this.addV4PartitionIdToV3Reference(partitionId, referenceV3);
        OnestoreEntity.Path referencePathV3 = referenceV3.getMutablePath();
        for (EntityV4.Key.PathElementOrBuilder keyPathElementV4 : keyV4.getPathElementOrBuilderList()) {
            OnestoreEntity.Path.Element pathElementV3 = this.toV3PathElement(keyPathElementV4);
            referencePathV3.addElement(pathElementV3);
        }
        return referenceV3;
    }

    public List<OnestoreEntity.Reference> toV3ReferenceList(List<EntityV4.Key> keys) {
        return Lists.transform(keys, (Function)new Function<EntityV4.Key, OnestoreEntity.Reference>(){

            public OnestoreEntity.Reference apply(EntityV4.Key keyV4) {
                return EntityProtoConverter.this.toV3Reference((EntityV4.KeyOrBuilder)keyV4);
            }
        });
    }

    public EntityV4.Key.Builder toV4Key(OnestoreEntity.Reference referenceV3) {
        EntityV4.Key.Builder keyV4 = EntityV4.Key.newBuilder();
        EntityV4.PartitionId.Builder partitionId = this.toPartitionId(referenceV3);
        if (partitionId != null) {
            keyV4.setPartitionId(partitionId);
        }
        for (OnestoreEntity.Path.Element pathElementV3 : referenceV3.getPath().elements()) {
            keyV4.addPathElement(this.toV4KeyPathElement(pathElementV3));
        }
        return keyV4;
    }

    public List<EntityV4.Key> toV4KeyList(List<OnestoreEntity.Reference> keys) {
        return Lists.transform(keys, (Function)new Function<OnestoreEntity.Reference, EntityV4.Key>(){

            public EntityV4.Key apply(OnestoreEntity.Reference keyV3) {
                return EntityProtoConverter.this.toV4Key(keyV3).build();
            }
        });
    }

    public EntityV4.Entity.Builder toV4Entity(OnestoreEntity.EntityProto entityV3) {
        EntityV4.Entity.Builder entityV4 = EntityV4.Entity.newBuilder();
        if (entityV3.hasKey() && !entityV3.getKey().getApp().isEmpty()) {
            entityV4.setKey(this.toV4Key(entityV3.getKey()));
        }
        LinkedHashMap nameToPropertyBuilderMap = Maps.newLinkedHashMap();
        for (OnestoreEntity.Property indexedPropertyV3 : entityV3.propertys()) {
            this.addV3PropertyToV4Map(true, indexedPropertyV3, nameToPropertyBuilderMap);
        }
        for (OnestoreEntity.Property unindexedPropertyV3 : entityV3.rawPropertys()) {
            this.addV3PropertyToV4Map(false, unindexedPropertyV3, nameToPropertyBuilderMap);
        }
        for (EntityV4.Property.Builder propertyV4 : nameToPropertyBuilderMap.values()) {
            entityV4.addProperty(propertyV4);
        }
        return entityV4;
    }

    private void addV3Property(String propertyName, boolean isMulti, EntityV4.ValueOrBuilder valueV4, OnestoreEntity.EntityProto entityV3) {
        OnestoreEntity.Property propertyV3 = this.toV3Property(propertyName, isMulti, valueV4);
        if (valueV4.getIndexed()) {
            entityV3.addProperty(propertyV3);
        } else {
            entityV3.addRawProperty(propertyV3);
        }
    }

    public OnestoreEntity.EntityProto toV3Entity(EntityV4.EntityOrBuilder entityV4) {
        OnestoreEntity.EntityProto entityV3 = new OnestoreEntity.EntityProto();
        for (EntityV4.Property propertyV4 : entityV4.getPropertyList()) {
            String propertyName = propertyV4.getName();
            if (propertyV4.hasValue()) {
                EntityV4.Value valueV4 = propertyV4.getValue();
                if (valueV4.getListValueCount() > 0) {
                    for (EntityV4.ValueOrBuilder subValueV4 : valueV4.getListValueOrBuilderList()) {
                        this.addV3Property(propertyName, true, subValueV4, entityV3);
                    }
                    continue;
                }
                this.addV3Property(propertyName, false, (EntityV4.ValueOrBuilder)valueV4, entityV3);
                continue;
            }
            boolean isMulti = propertyV4.getDeprecatedMulti();
            for (EntityV4.ValueOrBuilder valueV4 : propertyV4.getDeprecatedValueOrBuilderList()) {
                this.addV3Property(propertyName, isMulti, valueV4, entityV3);
            }
        }
        if (entityV4.hasKey()) {
            EntityV4.Key keyV4 = entityV4.getKey();
            OnestoreEntity.Reference referenceV3 = this.toV3Reference((EntityV4.KeyOrBuilder)keyV4);
            entityV3.setKey(referenceV3);
            if (Paths.hasIdOrName(referenceV3) || referenceV3.getPath().elementSize() > 1) {
                entityV3.setEntityGroup(Paths.getGroup(referenceV3));
            }
        }
        return entityV3;
    }

    EntityV4.Value.Builder toV4Value(OnestoreEntity.Property propertyV3, boolean indexed) {
        String uriMeaningV3;
        EntityV4.Value.Builder valueV4 = EntityV4.Value.newBuilder();
        OnestoreEntity.PropertyValue propertyValueV3 = propertyV3.getValue();
        OnestoreEntity.Property.Meaning meaningV3 = propertyV3.getMeaningEnum();
        String string = uriMeaningV3 = propertyV3.hasMeaningUri() ? propertyV3.getMeaningUri() : null;
        if (!this.doubleCheckIsInternValueUnionValid(propertyV3.getValue())) {
            meaningV3 = null;
            uriMeaningV3 = null;
        } else if (meaningV3 == OnestoreEntity.Property.Meaning.NO_MEANING) {
            meaningV3 = null;
        } else if (!this.doubleCheckIsInternValueMeaningValid(meaningV3, propertyValueV3)) {
            meaningV3 = null;
        }
        boolean isZlibValue = false;
        if (uriMeaningV3 != null && uriMeaningV3.equals("ZLIB") && propertyValueV3.hasStringValue()) {
            isZlibValue = true;
            if (meaningV3 != OnestoreEntity.Property.Meaning.BLOB) {
                meaningV3 = OnestoreEntity.Property.Meaning.BLOB;
            }
        }
        if (propertyValueV3.hasBooleanValue()) {
            valueV4.setBooleanValue(propertyValueV3.isBooleanValue());
        } else if (propertyValueV3.hasInt64Value()) {
            if (meaningV3 == OnestoreEntity.Property.Meaning.GD_WHEN) {
                valueV4.setTimestampMicrosecondsValue(propertyValueV3.getInt64Value());
                meaningV3 = null;
            } else {
                valueV4.setIntegerValue(propertyValueV3.getInt64Value());
            }
        } else if (propertyValueV3.hasDoubleValue()) {
            valueV4.setDoubleValue(propertyValueV3.getDoubleValue());
        } else if (propertyValueV3.hasReferenceValue()) {
            valueV4.setKeyValue(this.toV4Key(Paths.toReference(propertyValueV3)));
        } else if (propertyValueV3.hasStringValue()) {
            if (meaningV3 == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                OnestoreEntity.EntityProto entityV3;
                byte[] serializedEntityV3 = propertyValueV3.getStringValueAsBytes();
                try {
                    entityV3 = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.PARSER.parsePartialFrom(serializedEntityV3);
                }
                catch (InvalidProtocolBufferException exception) {
                    entityV3 = null;
                }
                if (entityV3 == null) {
                    valueV4.setBlobValue(ByteString.copyFrom((byte[])serializedEntityV3));
                } else {
                    valueV4.setEntityValue(this.toV4Entity(entityV3));
                }
                meaningV3 = null;
            } else if (meaningV3 == OnestoreEntity.Property.Meaning.BLOB || meaningV3 == OnestoreEntity.Property.Meaning.BYTESTRING) {
                valueV4.setBlobValue(ByteString.copyFrom((byte[])propertyValueV3.getStringValueAsBytes()));
                if (indexed || meaningV3 == OnestoreEntity.Property.Meaning.BLOB) {
                    meaningV3 = null;
                }
            } else {
                ByteString byteStringValue = ByteString.copyFrom((byte[])propertyValueV3.getStringValueAsBytes());
                if (byteStringValue.isValidUtf8()) {
                    String stringValue = propertyValueV3.getStringValue();
                    if (meaningV3 == OnestoreEntity.Property.Meaning.BLOBKEY) {
                        valueV4.setBlobKeyValue(stringValue);
                        meaningV3 = null;
                    } else {
                        valueV4.setStringValue(stringValue);
                    }
                } else {
                    valueV4.setBlobValue(byteStringValue);
                    if (meaningV3 != OnestoreEntity.Property.Meaning.INDEX_VALUE) {
                        meaningV3 = null;
                    }
                }
            }
        } else if (propertyValueV3.hasPointValue()) {
            if (this.useGeoPoint) {
                if (meaningV3 == OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                    valueV4.setGeoPointValue(this.toV4GeoPointValue(propertyValueV3.getPointValue()));
                    meaningV3 = null;
                } else if (this.useGeoPoint && meaningV3 == OnestoreEntity.Property.Meaning.INDEX_VALUE) {
                    valueV4.setGeoPointValue(this.toV4GeoPointValue(propertyValueV3.getPointValue()));
                } else {
                    valueV4.setEntityValue(this.toV4Entity(propertyValueV3.getPointValue()));
                    valueV4.setMeaning(21);
                    meaningV3 = null;
                }
            } else {
                valueV4.setEntityValue(this.toV4Entity(propertyValueV3.getPointValue()));
                if (meaningV3 != OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                    valueV4.setMeaning(21);
                    meaningV3 = null;
                }
            }
        } else if (propertyValueV3.hasUserValue()) {
            valueV4.setEntityValue(this.toV4Entity(propertyValueV3.getUserValue()));
            valueV4.setMeaning(20);
            meaningV3 = null;
        }
        if (isZlibValue) {
            valueV4.setMeaning(22);
        } else if (meaningV3 != null) {
            int meaningV4 = meaningV3.getValue();
            valueV4.setMeaning(meaningV4);
        }
        if (indexed != valueV4.getIndexed()) {
            valueV4.setIndexed(indexed);
        }
        return valueV4;
    }

    private EntityV4.GeoPoint toV4GeoPointValue(OnestoreEntity.PropertyValue.PointValue pointValueV3) {
        return EntityV4.GeoPoint.newBuilder().setLatitude(pointValueV3.getX()).setLongitude(pointValueV3.getY()).build();
    }

    OnestoreEntity.PropertyValue toV3PropertyValue(EntityV4.ValueOrBuilder valueV4) {
        Preconditions.checkArgument((valueV4.getListValueCount() == 0 ? 1 : 0) != 0, (Object)"v4 list_value not convertable to v3");
        OnestoreEntity.PropertyValue propertyValueV3 = new OnestoreEntity.PropertyValue();
        if (valueV4.hasBooleanValue()) {
            propertyValueV3.setBooleanValue(valueV4.getBooleanValue());
        } else if (valueV4.hasIntegerValue()) {
            propertyValueV3.setInt64Value(valueV4.getIntegerValue());
        } else if (valueV4.hasDoubleValue()) {
            propertyValueV3.setDoubleValue(valueV4.getDoubleValue());
        } else if (valueV4.hasTimestampMicrosecondsValue()) {
            propertyValueV3.setInt64Value(valueV4.getTimestampMicrosecondsValue());
        } else if (valueV4.hasKeyValue()) {
            EntityV4.Key keyV4 = valueV4.getKeyValue();
            OnestoreEntity.PropertyValue.ReferenceValue referenceValueV3 = Paths.toReferenceProperty(this.toV3Reference((EntityV4.KeyOrBuilder)keyV4)).getReferenceValue();
            propertyValueV3.setReferenceValue(referenceValueV3);
        } else if (valueV4.hasBlobKeyValue()) {
            propertyValueV3.setStringValue(valueV4.getBlobKeyValue());
        } else if (valueV4.hasStringValue()) {
            propertyValueV3.setStringValue(valueV4.getStringValue());
        } else if (valueV4.hasBlobValue()) {
            ByteString blobV4 = valueV4.getBlobValue();
            propertyValueV3.setStringValueAsBytes(blobV4.toByteArray());
        } else if (valueV4.hasEntityValue()) {
            EntityV4.Entity entityValueV4 = valueV4.getEntityValue();
            if (valueV4.getMeaning() == 9 || valueV4.getMeaning() == 21) {
                OnestoreEntity.PropertyValue.PointValue pointValueV3 = this.toV3PointValue((EntityV4.EntityOrBuilder)entityValueV4);
                propertyValueV3.setPointValue(pointValueV3);
            } else if (valueV4.getMeaning() == 20) {
                OnestoreEntity.PropertyValue.UserValue userValueV3 = this.toV3UserValue((EntityV4.EntityOrBuilder)entityValueV4);
                propertyValueV3.setUserValue(userValueV3);
            } else {
                OnestoreEntity.EntityProto entityValueV3 = this.toV3Entity((EntityV4.EntityOrBuilder)entityValueV4);
                propertyValueV3.setStringValueAsBytes(entityValueV3.toByteArray());
            }
        } else if (valueV4.hasGeoPointValue()) {
            EntityV4.GeoPoint geopointValueV4 = valueV4.getGeoPointValue();
            OnestoreEntity.PropertyValue.PointValue pointValueV3 = this.toV3PointValue(geopointValueV4);
            propertyValueV3.setPointValue(pointValueV3);
        }
        return propertyValueV3;
    }

    public OnestoreEntity.Property toV3Property(String propertyName, boolean isMultiple, EntityV4.ValueOrBuilder valueV4) {
        int meaningV4;
        OnestoreEntity.Property propertyV3 = new OnestoreEntity.Property();
        propertyV3.setName(propertyName);
        propertyV3.setMultiple(isMultiple);
        propertyV3.setValue(this.toV3PropertyValue(valueV4));
        int n = meaningV4 = valueV4.hasMeaning() ? valueV4.getMeaning() : 0;
        if (valueV4.hasTimestampMicrosecondsValue()) {
            propertyV3.setMeaning(OnestoreEntity.Property.Meaning.GD_WHEN);
        } else if (valueV4.hasBlobKeyValue()) {
            propertyV3.setMeaning(OnestoreEntity.Property.Meaning.BLOBKEY);
        } else if (valueV4.hasBlobValue()) {
            if (meaningV4 == 22) {
                propertyV3.setMeaningUri("ZLIB");
            }
            if (meaningV4 == 16) {
                if (valueV4.getIndexed()) {
                    // empty if block
                }
            } else {
                if (valueV4.getIndexed()) {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.BYTESTRING);
                } else {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.BLOB);
                }
                meaningV4 = 0;
            }
        } else if (valueV4.hasEntityValue()) {
            if (meaningV4 != 9) {
                if (meaningV4 != 21 && meaningV4 != 20) {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
                }
                meaningV4 = 0;
            }
        } else if (valueV4.hasGeoPointValue()) {
            propertyV3.setMeaning(OnestoreEntity.Property.Meaning.GEORSS_POINT);
            meaningV4 = 0;
        }
        if (meaningV4 != 0) {
            OnestoreEntity.Property.Meaning meaningV3 = OnestoreEntity.Property.Meaning.valueOf((int)meaningV4);
            propertyV3.setMeaning(meaningV3);
        }
        return propertyV3;
    }

    private void addV4PartitionIdToV3Reference(EntityV4.PartitionId partitionId, OnestoreEntity.Reference referenceV3) {
        String datasetId = partitionId.hasDatasetId() ? partitionId.getDatasetId() : "";
        referenceV3.setApp(datasetId);
        if (partitionId.hasNamespace()) {
            String namespace = partitionId.getNamespace();
            referenceV3.setNameSpace(namespace);
        }
    }

    private OnestoreEntity.Path.Element toV3PathElement(EntityV4.Key.PathElementOrBuilder keyPathElementV4) {
        OnestoreEntity.Path.Element pathElementV3 = new OnestoreEntity.Path.Element();
        String kind = keyPathElementV4.getKind();
        pathElementV3.setType(kind);
        if (keyPathElementV4.hasId()) {
            long id = keyPathElementV4.getId();
            pathElementV3.setId(id);
        } else if (keyPathElementV4.hasName()) {
            String name = keyPathElementV4.getName();
            pathElementV3.setName(name);
        }
        return pathElementV3;
    }

    private OnestoreEntity.PropertyValue.PointValue toV3PointValue(EntityV4.EntityOrBuilder pointEntityV4) {
        Map<String, EntityV4.PropertyOrBuilder> nameToV4Property = this.buildNameToV4PropertyMap(pointEntityV4);
        OnestoreEntity.PropertyValue.PointValue pointValueV3 = new OnestoreEntity.PropertyValue.PointValue();
        double x = this.toDoubleValue(nameToV4Property.get("x"));
        double y = this.toDoubleValue(nameToV4Property.get("y"));
        pointValueV3.setX(x);
        pointValueV3.setY(y);
        return pointValueV3;
    }

    private OnestoreEntity.PropertyValue.PointValue toV3PointValue(EntityV4.GeoPoint geopointValueV4) {
        OnestoreEntity.PropertyValue.PointValue pointValueV3 = new OnestoreEntity.PropertyValue.PointValue();
        double x = geopointValueV4.getLatitude();
        double y = geopointValueV4.getLongitude();
        pointValueV3.setX(x);
        pointValueV3.setY(y);
        return pointValueV3;
    }

    private OnestoreEntity.PropertyValue.UserValue toV3UserValue(EntityV4.EntityOrBuilder userEntity) {
        EntityV4.PropertyOrBuilder federatedProviderProperty;
        EntityV4.PropertyOrBuilder federatedIdentityProperty;
        Map<String, EntityV4.PropertyOrBuilder> nameToV4Property = this.buildNameToV4PropertyMap(userEntity);
        OnestoreEntity.PropertyValue.UserValue userValueV3 = new OnestoreEntity.PropertyValue.UserValue();
        userValueV3.setEmail(this.toStringValue(nameToV4Property.get("email")));
        userValueV3.setAuthDomain(this.toStringValue(nameToV4Property.get("auth_domain")));
        EntityV4.PropertyOrBuilder userIdProperty = nameToV4Property.get("user_id");
        if (nameToV4Property.containsKey("internal_id")) {
            userValueV3.setGaiaid(this.toIntegerValue(nameToV4Property.get("internal_id")));
        } else {
            userValueV3.setGaiaid(0L);
        }
        if (userIdProperty != null) {
            userValueV3.setObfuscatedGaiaid(this.toStringValue(userIdProperty));
        }
        if ((federatedIdentityProperty = nameToV4Property.get("federated_identity")) != null) {
            userValueV3.setFederatedIdentity(this.toStringValue(federatedIdentityProperty));
        }
        if ((federatedProviderProperty = nameToV4Property.get("federated_provider")) != null) {
            userValueV3.setFederatedProvider(this.toStringValue(federatedProviderProperty));
        }
        return userValueV3;
    }

    private Map<String, EntityV4.PropertyOrBuilder> buildNameToV4PropertyMap(EntityV4.EntityOrBuilder entityV4) {
        HashMap nameToV4Property = Maps.newHashMap();
        for (EntityV4.PropertyOrBuilder propertyV4 : entityV4.getPropertyOrBuilderList()) {
            nameToV4Property.put(propertyV4.getName(), propertyV4);
        }
        return nameToV4Property;
    }

    private long toIntegerValue(EntityV4.PropertyOrBuilder propertyV4) {
        if (propertyV4.hasValue()) {
            return propertyV4.getValueOrBuilder().getIntegerValue();
        }
        return ((EntityV4.Value)Iterables.getOnlyElement((Iterable)propertyV4.getDeprecatedValueList())).getIntegerValue();
    }

    private double toDoubleValue(EntityV4.PropertyOrBuilder propertyV4) {
        if (propertyV4.hasValue()) {
            return propertyV4.getValueOrBuilder().getDoubleValue();
        }
        return ((EntityV4.Value)Iterables.getOnlyElement((Iterable)propertyV4.getDeprecatedValueList())).getDoubleValue();
    }

    private String toStringValue(EntityV4.PropertyOrBuilder propertyV4) {
        if (propertyV4.hasValue()) {
            return propertyV4.getValueOrBuilder().getStringValue();
        }
        return ((EntityV4.Value)Iterables.getOnlyElement((Iterable)propertyV4.getDeprecatedValueList())).getStringValue();
    }

    private void addV3PropertyToV4Map(boolean isIndexed, OnestoreEntity.Property propertyV3, Map<String, EntityV4.Property.Builder> nameToV4PropertyBuilderMap) {
        String propertyName = propertyV3.getName();
        EntityV4.Value propertyValue = this.toV4Value(propertyV3, isIndexed).build();
        EntityV4.Property.Builder propertyV4 = nameToV4PropertyBuilderMap.get(propertyName);
        if (propertyV4 == null) {
            propertyV4 = EntityV4.Property.newBuilder();
            propertyV4.setName(propertyName);
            nameToV4PropertyBuilderMap.put(propertyName, propertyV4);
            if (!propertyV3.isMultiple()) {
                propertyV4.setValue(propertyValue);
                return;
            }
        } else {
            if (propertyV4.getValue().getListValueCount() == 0) {
                propertyV4.setValue(EntityV4.Value.newBuilder().addListValue(propertyV4.getValue()));
            }
            if (!propertyV3.isMultiple()) {
                // empty if block
            }
        }
        propertyV4.getValueBuilder().addListValue(propertyValue);
    }

    private boolean doubleCheckIsInternValueUnionValid(OnestoreEntity.PropertyValue propertyValueV3) {
        int numSubValues = 0;
        if (propertyValueV3.hasBooleanValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasInt64Value()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasDoubleValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasReferenceValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasStringValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasPointValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasUserValue()) {
            ++numSubValues;
        }
        return numSubValues <= 1;
    }

    private boolean doubleCheckIsInternValueMeaningValid(OnestoreEntity.Property.Meaning meaningV3, OnestoreEntity.PropertyValue propertyValueV3) {
        switch (meaningV3) {
            case NO_MEANING: 
            case INDEX_VALUE: {
                return true;
            }
            case BLOB: 
            case TEXT: 
            case BYTESTRING: 
            case ATOM_CATEGORY: 
            case ATOM_LINK: 
            case ATOM_TITLE: 
            case ATOM_CONTENT: 
            case ATOM_SUMMARY: 
            case ATOM_AUTHOR: 
            case GD_EMAIL: 
            case GD_IM: 
            case GD_PHONENUMBER: 
            case GD_POSTALADDRESS: 
            case BLOBKEY: 
            case ENTITY_PROTO: {
                return propertyValueV3.hasStringValue();
            }
            case GD_WHEN: 
            case GD_RATING: {
                return propertyValueV3.hasInt64Value();
            }
            case GEORSS_POINT: {
                return propertyValueV3.hasPointValue();
            }
        }
        return false;
    }

    private EntityV4.PartitionId.Builder toPartitionId(OnestoreEntity.Reference referenceV3) {
        if (referenceV3.getApp().isEmpty()) {
            return null;
        }
        String appId = referenceV3.getApp();
        EntityV4.PartitionId.Builder partitionId = EntityV4.PartitionId.newBuilder();
        partitionId.setDatasetId(appId);
        if (referenceV3.hasNameSpace()) {
            String internNamespace = referenceV3.getNameSpace();
            partitionId.setNamespace(internNamespace);
        }
        return partitionId;
    }

    private EntityV4.Key.PathElement.Builder toV4KeyPathElement(OnestoreEntity.Path.Element pathElementV3) {
        EntityV4.Key.PathElement.Builder keyPathElementV4 = EntityV4.Key.PathElement.newBuilder();
        keyPathElementV4.setKind(pathElementV3.getType());
        if (pathElementV3.hasId()) {
            keyPathElementV4.setId(pathElementV3.getId());
        }
        if (pathElementV3.hasName()) {
            keyPathElementV4.setName(pathElementV3.getName());
        }
        return keyPathElementV4;
    }

    private EntityV4.Entity.Builder toV4Entity(OnestoreEntity.PropertyValue.PointValue pointValueV3) {
        String xPropertyName = "x";
        String yPropertyName = "y";
        return EntityV4.Entity.newBuilder().addProperty(this.toV4UnindexedProperty(xPropertyName, pointValueV3.getX())).addProperty(this.toV4UnindexedProperty(yPropertyName, pointValueV3.getY()));
    }

    private EntityV4.Entity.Builder toV4Entity(OnestoreEntity.PropertyValue.UserValue userValueV3) {
        EntityV4.Entity.Builder entityV4 = EntityV4.Entity.newBuilder();
        entityV4.addProperty(this.toV4UnindexedProperty("email", userValueV3.getEmail()));
        entityV4.addProperty(this.toV4UnindexedProperty("auth_domain", userValueV3.getAuthDomain()));
        if (userValueV3.hasObfuscatedGaiaid()) {
            entityV4.addProperty(this.toV4UnindexedProperty("user_id", userValueV3.getObfuscatedGaiaid()));
        }
        if (userValueV3.getGaiaid() != 0L) {
            entityV4.addProperty(this.toV4UnindexedProperty("internal_id", userValueV3.getGaiaid()));
        }
        if (userValueV3.hasFederatedIdentity()) {
            entityV4.addProperty(this.toV4UnindexedProperty("federated_identity", userValueV3.getFederatedIdentity()));
        }
        if (userValueV3.hasFederatedProvider()) {
            entityV4.addProperty(this.toV4UnindexedProperty("federated_provider", userValueV3.getFederatedProvider()));
        }
        return entityV4;
    }

    private EntityV4.Property.Builder toV4UnindexedProperty(String propertyName, String stringValue) {
        return EntityV4.Property.newBuilder().setName(propertyName).setValue(EntityV4.Value.newBuilder().setStringValue(stringValue).setIndexed(false));
    }

    private EntityV4.Property.Builder toV4UnindexedProperty(String propertyName, double doubleValue) {
        return EntityV4.Property.newBuilder().setName(propertyName).setValue(EntityV4.Value.newBuilder().setDoubleValue(doubleValue).setIndexed(false));
    }

    private EntityV4.Property.Builder toV4UnindexedProperty(String propertyName, long integerValue) {
        return EntityV4.Property.newBuilder().setName(propertyName).setValue(EntityV4.Value.newBuilder().setIntegerValue(integerValue).setIndexed(false));
    }
}

