/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.util.cache;

public abstract class Cache {
    public static Cache synchronizedCache(Cache cache) {
        return cache.getSynchronizedCache();
    }

    Cache getSynchronizedCache() {
        return new SynchronizedCache(this);
    }

    public abstract void put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract boolean containsKey(Object var1);

    public abstract void close();

    static class SynchronizedCache
    extends Cache {
        Object mutex;
        Cache cache;

        SynchronizedCache(Cache cache) {
            this.cache = cache;
            this.mutex = this;
        }

        SynchronizedCache(Cache cache, Object mutex) {
            this.cache = cache;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.cache.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.mutex;
            synchronized (object) {
                this.cache.close();
            }
        }

        Cache getSynchronizedCache() {
            return this;
        }
    }
}

