/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.CorruptIndexException;
import com.google.appengine.repackaged.org.apache.lucene.index.DefaultSkipListWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfo;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsDocsConsumer;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsPositionsConsumer;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsPositionsWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsTermsWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexFileNames;
import com.google.appengine.repackaged.org.apache.lucene.index.SegmentWriteState;
import com.google.appengine.repackaged.org.apache.lucene.index.TermInfo;
import com.google.appengine.repackaged.org.apache.lucene.store.IndexOutput;
import com.google.appengine.repackaged.org.apache.lucene.util.UnicodeUtil;
import java.io.IOException;

final class FormatPostingsDocsWriter
extends FormatPostingsDocsConsumer {
    final IndexOutput out;
    final FormatPostingsTermsWriter parent;
    final FormatPostingsPositionsWriter posWriter;
    final DefaultSkipListWriter skipListWriter;
    final int skipInterval;
    final int totalNumDocs;
    boolean omitTermFreqAndPositions;
    boolean storePayloads;
    long freqStart;
    FieldInfo fieldInfo;
    int lastDocID;
    int df;
    private final TermInfo termInfo = new TermInfo();
    final UnicodeUtil.UTF8Result utf8 = new UnicodeUtil.UTF8Result();
    static final /* synthetic */ boolean $assertionsDisabled;

    FormatPostingsDocsWriter(SegmentWriteState state, FormatPostingsTermsWriter parent) throws IOException {
        this.parent = parent;
        String fileName = IndexFileNames.segmentFileName(parent.parent.segment, "frq");
        state.flushedFiles.add(fileName);
        this.out = parent.parent.dir.createOutput(fileName);
        this.totalNumDocs = parent.parent.totalNumDocs;
        this.skipInterval = parent.parent.termsOut.skipInterval;
        this.skipListWriter = parent.parent.skipListWriter;
        this.skipListWriter.setFreqOutput(this.out);
        this.posWriter = new FormatPostingsPositionsWriter(state, this);
    }

    void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.omitTermFreqAndPositions = fieldInfo.omitTermFreqAndPositions;
        this.storePayloads = fieldInfo.storePayloads;
        this.posWriter.setField(fieldInfo);
    }

    FormatPostingsPositionsConsumer addDoc(int docID, int termDocFreq) throws IOException {
        int delta = docID - this.lastDocID;
        if (docID < 0 || this.df > 0 && delta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " )");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.posWriter.lastPayloadLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        if (!$assertionsDisabled && docID >= this.totalNumDocs) {
            throw new AssertionError((Object)("docID=" + docID + " totalNumDocs=" + this.totalNumDocs));
        }
        this.lastDocID = docID;
        if (this.omitTermFreqAndPositions) {
            this.out.writeVInt(delta);
        } else if (1 == termDocFreq) {
            this.out.writeVInt(delta << 1 | 1);
        } else {
            this.out.writeVInt(delta << 1);
            this.out.writeVInt(termDocFreq);
        }
        return this.posWriter;
    }

    void finish() throws IOException {
        long skipPointer = this.skipListWriter.writeSkip(this.out);
        this.termInfo.set(this.df, this.parent.freqStart, this.parent.proxStart, (int)(skipPointer - this.parent.freqStart));
        UnicodeUtil.UTF16toUTF8(this.parent.currentTerm, this.parent.currentTermStart, this.utf8);
        if (this.df > 0) {
            this.parent.termsOut.add(this.fieldInfo.number, this.utf8.result, this.utf8.length, this.termInfo);
        }
        this.lastDocID = 0;
        this.df = 0;
    }

    void close() throws IOException {
        this.out.close();
        this.posWriter.close();
    }

    static {
        $assertionsDisabled = !FormatPostingsDocsWriter.class.desiredAssertionStatus();
    }
}

