/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.webmasters;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.webmasters.WebmastersRequest;
import com.google.api.services.webmasters.WebmastersRequestInitializer;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryRequest;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryResponse;
import com.google.api.services.webmasters.model.SitemapsListResponse;
import com.google.api.services.webmasters.model.SitesListResponse;
import com.google.api.services.webmasters.model.UrlCrawlErrorsCountsQueryResponse;
import com.google.api.services.webmasters.model.UrlCrawlErrorsSample;
import com.google.api.services.webmasters.model.UrlCrawlErrorsSamplesListResponse;
import com.google.api.services.webmasters.model.WmxSite;
import com.google.api.services.webmasters.model.WmxSitemap;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Webmasters
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "webmasters/v3/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/webmasters/v3/";

    public Webmasters(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Webmasters(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Searchanalytics searchanalytics() {
        return new Searchanalytics();
    }

    public Sitemaps sitemaps() {
        return new Sitemaps();
    }

    public Sites sites() {
        return new Sites();
    }

    public Urlcrawlerrorscounts urlcrawlerrorscounts() {
        return new Urlcrawlerrorscounts();
    }

    public Urlcrawlerrorssamples urlcrawlerrorssamples() {
        return new Urlcrawlerrorssamples();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.19.1 of the Webmaster Tools API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Webmasters.DEFAULT_ROOT_URL, Webmasters.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Webmasters build() {
            return new Webmasters(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setWebmastersRequestInitializer(WebmastersRequestInitializer webmastersRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)webmastersRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Urlcrawlerrorssamples {
        public Get get(String string, String string2, String string3, String string4) throws IOException {
            Get get = new Get(string, string2, string3, string4);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2, String string3) throws IOException {
            List list = new List(string, string2, string3);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public MarkAsFixed markAsFixed(String string, String string2, String string3, String string4) throws IOException {
            MarkAsFixed markAsFixed = new MarkAsFixed(string, string2, string3, string4);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)markAsFixed);
            return markAsFixed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MarkAsFixed
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}/urlCrawlErrorsSamples/{url}";
            @Key
            private String siteUrl;
            @Key
            private String url;
            @Key
            private String category;
            @Key
            private String platform;

            protected MarkAsFixed(String string, String string2, String string3, String string4) {
                super(Webmasters.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
                this.url = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter url must be specified.");
                this.category = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter category must be specified.");
                this.platform = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter platform must be specified.");
            }

            public MarkAsFixed setAlt(String string) {
                return (MarkAsFixed)super.setAlt(string);
            }

            public MarkAsFixed setFields(String string) {
                return (MarkAsFixed)super.setFields(string);
            }

            public MarkAsFixed setKey(String string) {
                return (MarkAsFixed)super.setKey(string);
            }

            public MarkAsFixed setOauthToken(String string) {
                return (MarkAsFixed)super.setOauthToken(string);
            }

            public MarkAsFixed setPrettyPrint(Boolean bl) {
                return (MarkAsFixed)super.setPrettyPrint(bl);
            }

            public MarkAsFixed setQuotaUser(String string) {
                return (MarkAsFixed)super.setQuotaUser(string);
            }

            public MarkAsFixed setUserIp(String string) {
                return (MarkAsFixed)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public MarkAsFixed setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getUrl() {
                return this.url;
            }

            public MarkAsFixed setUrl(String string) {
                this.url = string;
                return this;
            }

            public String getCategory() {
                return this.category;
            }

            public MarkAsFixed setCategory(String string) {
                this.category = string;
                return this;
            }

            public String getPlatform() {
                return this.platform;
            }

            public MarkAsFixed setPlatform(String string) {
                this.platform = string;
                return this;
            }

            @Override
            public MarkAsFixed set(String string, Object object) {
                return (MarkAsFixed)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends WebmastersRequest<UrlCrawlErrorsSamplesListResponse> {
            private static final String REST_PATH = "sites/{siteUrl}/urlCrawlErrorsSamples";
            @Key
            private String siteUrl;
            @Key
            private String category;
            @Key
            private String platform;

            protected List(String string, String string2, String string3) {
                super(Webmasters.this, "GET", REST_PATH, null, UrlCrawlErrorsSamplesListResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
                this.category = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter category must be specified.");
                this.platform = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter platform must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public List setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getCategory() {
                return this.category;
            }

            public List setCategory(String string) {
                this.category = string;
                return this;
            }

            public String getPlatform() {
                return this.platform;
            }

            public List setPlatform(String string) {
                this.platform = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends WebmastersRequest<UrlCrawlErrorsSample> {
            private static final String REST_PATH = "sites/{siteUrl}/urlCrawlErrorsSamples/{url}";
            @Key
            private String siteUrl;
            @Key
            private String url;
            @Key
            private String category;
            @Key
            private String platform;

            protected Get(String string, String string2, String string3, String string4) {
                super(Webmasters.this, "GET", REST_PATH, null, UrlCrawlErrorsSample.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
                this.url = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter url must be specified.");
                this.category = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter category must be specified.");
                this.platform = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter platform must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getUrl() {
                return this.url;
            }

            public Get setUrl(String string) {
                this.url = string;
                return this;
            }

            public String getCategory() {
                return this.category;
            }

            public Get setCategory(String string) {
                this.category = string;
                return this;
            }

            public String getPlatform() {
                return this.platform;
            }

            public Get setPlatform(String string) {
                this.platform = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Urlcrawlerrorscounts {
        public Query query(String string) throws IOException {
            Query query = new Query(string);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends WebmastersRequest<UrlCrawlErrorsCountsQueryResponse> {
            private static final String REST_PATH = "sites/{siteUrl}/urlCrawlErrorsCounts/query";
            @Key
            private String siteUrl;
            @Key
            private String category;
            @Key
            private String platform;
            @Key
            private Boolean latestCountsOnly;

            protected Query(String string) {
                super(Webmasters.this, "GET", REST_PATH, null, UrlCrawlErrorsCountsQueryResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Query setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getCategory() {
                return this.category;
            }

            public Query setCategory(String string) {
                this.category = string;
                return this;
            }

            public String getPlatform() {
                return this.platform;
            }

            public Query setPlatform(String string) {
                this.platform = string;
                return this;
            }

            public Boolean getLatestCountsOnly() {
                return this.latestCountsOnly;
            }

            public Query setLatestCountsOnly(Boolean bl) {
                this.latestCountsOnly = bl;
                return this;
            }

            public boolean isLatestCountsOnly() {
                if (this.latestCountsOnly == null || this.latestCountsOnly == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.latestCountsOnly;
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }
    }

    public class Sites {
        public Add add(String string) throws IOException {
            Add add = new Add(string);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)add);
            return add;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends WebmastersRequest<SitesListResponse> {
            private static final String REST_PATH = "sites";

            protected List() {
                super(Webmasters.this, "GET", REST_PATH, null, SitesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends WebmastersRequest<WmxSite> {
            private static final String REST_PATH = "sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Get(String string) {
                super(Webmasters.this, "GET", REST_PATH, null, WmxSite.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Delete(String string) {
                super(Webmasters.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Delete setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Add
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Add(String string) {
                super(Webmasters.this, "PUT", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
            }

            public Add setAlt(String string) {
                return (Add)super.setAlt(string);
            }

            public Add setFields(String string) {
                return (Add)super.setFields(string);
            }

            public Add setKey(String string) {
                return (Add)super.setKey(string);
            }

            public Add setOauthToken(String string) {
                return (Add)super.setOauthToken(string);
            }

            public Add setPrettyPrint(Boolean bl) {
                return (Add)super.setPrettyPrint(bl);
            }

            public Add setQuotaUser(String string) {
                return (Add)super.setQuotaUser(string);
            }

            public Add setUserIp(String string) {
                return (Add)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Add setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            @Override
            public Add set(String string, Object object) {
                return (Add)super.set(string, object);
            }
        }
    }

    public class Sitemaps {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Submit submit(String string, String string2) throws IOException {
            Submit submit = new Submit(string, string2);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)submit);
            return submit;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Submit
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Submit(String string, String string2) {
                super(Webmasters.this, "PUT", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter feedpath must be specified.");
            }

            public Submit setAlt(String string) {
                return (Submit)super.setAlt(string);
            }

            public Submit setFields(String string) {
                return (Submit)super.setFields(string);
            }

            public Submit setKey(String string) {
                return (Submit)super.setKey(string);
            }

            public Submit setOauthToken(String string) {
                return (Submit)super.setOauthToken(string);
            }

            public Submit setPrettyPrint(Boolean bl) {
                return (Submit)super.setPrettyPrint(bl);
            }

            public Submit setQuotaUser(String string) {
                return (Submit)super.setQuotaUser(string);
            }

            public Submit setUserIp(String string) {
                return (Submit)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Submit setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Submit setFeedpath(String string) {
                this.feedpath = string;
                return this;
            }

            @Override
            public Submit set(String string, Object object) {
                return (Submit)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends WebmastersRequest<SitemapsListResponse> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps";
            @Key
            private String siteUrl;
            @Key
            private String sitemapIndex;

            protected List(String string) {
                super(Webmasters.this, "GET", REST_PATH, null, SitemapsListResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public List setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getSitemapIndex() {
                return this.sitemapIndex;
            }

            public List setSitemapIndex(String string) {
                this.sitemapIndex = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends WebmastersRequest<WmxSitemap> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Get(String string, String string2) {
                super(Webmasters.this, "GET", REST_PATH, null, WmxSitemap.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter feedpath must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Get setFeedpath(String string) {
                this.feedpath = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Delete(String string, String string2) {
                super(Webmasters.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter feedpath must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Delete setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Delete setFeedpath(String string) {
                this.feedpath = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Searchanalytics {
        public Query query(String string, SearchAnalyticsQueryRequest searchAnalyticsQueryRequest) throws IOException {
            Query query = new Query(string, searchAnalyticsQueryRequest);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends WebmastersRequest<SearchAnalyticsQueryResponse> {
            private static final String REST_PATH = "sites/{siteUrl}/searchAnalytics/query";
            @Key
            private String siteUrl;

            protected Query(String string, SearchAnalyticsQueryRequest searchAnalyticsQueryRequest) {
                super(Webmasters.this, "POST", REST_PATH, (Object)searchAnalyticsQueryRequest, SearchAnalyticsQueryResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter siteUrl must be specified.");
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Query setSiteUrl(String string) {
                this.siteUrl = string;
                return this;
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }
    }
}

