/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for Uri.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Uri extends com.google.api.client.json.GenericJson {

  /**
   * The URI's title appearing in the app as text. Recommended maximum is 20 characters to ensure
   * full string is displayed on smaller screens. Note that in some contexts this text is not used,
   * such as when `description` is part of an image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The ID associated with a uri. This field is here to enable ease of management of uris.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#uri"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Translated strings for the description. Recommended maximum is 20 characters to ensure full
   * string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedDescription;

  /**
   * The location of a web page, image, or other resource. URIs in the `LinksModuleData` module can
   * have different prefixes indicating the type of URI (a link to a web page, a link to a map, a
   * telephone number, or an email address). URIs must have a scheme.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * The URI's title appearing in the app as text. Recommended maximum is 20 characters to ensure
   * full string is displayed on smaller screens. Note that in some contexts this text is not used,
   * such as when `description` is part of an image.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The URI's title appearing in the app as text. Recommended maximum is 20 characters to ensure
   * full string is displayed on smaller screens. Note that in some contexts this text is not used,
   * such as when `description` is part of an image.
   * @param description description or {@code null} for none
   */
  public Uri setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The ID associated with a uri. This field is here to enable ease of management of uris.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID associated with a uri. This field is here to enable ease of management of uris.
   * @param id id or {@code null} for none
   */
  public Uri setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#uri"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#uri"`.
   * @param kind kind or {@code null} for none
   */
  public Uri setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Translated strings for the description. Recommended maximum is 20 characters to ensure full
   * string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedDescription() {
    return localizedDescription;
  }

  /**
   * Translated strings for the description. Recommended maximum is 20 characters to ensure full
   * string is displayed on smaller screens.
   * @param localizedDescription localizedDescription or {@code null} for none
   */
  public Uri setLocalizedDescription(LocalizedString localizedDescription) {
    this.localizedDescription = localizedDescription;
    return this;
  }

  /**
   * The location of a web page, image, or other resource. URIs in the `LinksModuleData` module can
   * have different prefixes indicating the type of URI (a link to a web page, a link to a map, a
   * telephone number, or an email address). URIs must have a scheme.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * The location of a web page, image, or other resource. URIs in the `LinksModuleData` module can
   * have different prefixes indicating the type of URI (a link to a web page, a link to a map, a
   * telephone number, or an email address). URIs must have a scheme.
   * @param uri uri or {@code null} for none
   */
  public Uri setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public Uri set(String fieldName, Object value) {
    return (Uri) super.set(fieldName, value);
  }

  @Override
  public Uri clone() {
    return (Uri) super.clone();
  }

}
