/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TranslatedString.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslatedString extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#translatedString"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or "de-AT".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * The UTF-8 encoded translated string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#translatedString"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#translatedString"`.
   * @param kind kind or {@code null} for none
   */
  public TranslatedString setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or "de-AT".
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or "de-AT".
   * @param language language or {@code null} for none
   */
  public TranslatedString setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  /**
   * The UTF-8 encoded translated string.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The UTF-8 encoded translated string.
   * @param value value or {@code null} for none
   */
  public TranslatedString setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public TranslatedString set(String fieldName, Object value) {
    return (TranslatedString) super.set(fieldName, value);
  }

  @Override
  public TranslatedString clone() {
    return (TranslatedString) super.clone();
  }

}
