/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Request to upload rotating barcode values.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransitObjectUploadRotatingBarcodeValuesRequest extends com.google.api.client.json.GenericJson {

  /**
   * A reference to the rotating barcode values payload that was uploaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Media blob;

  /**
   * Extra information about the uploaded media.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MediaRequestInfo mediaRequestInfo;

  /**
   * A reference to the rotating barcode values payload that was uploaded.
   * @return value or {@code null} for none
   */
  public Media getBlob() {
    return blob;
  }

  /**
   * A reference to the rotating barcode values payload that was uploaded.
   * @param blob blob or {@code null} for none
   */
  public TransitObjectUploadRotatingBarcodeValuesRequest setBlob(Media blob) {
    this.blob = blob;
    return this;
  }

  /**
   * Extra information about the uploaded media.
   * @return value or {@code null} for none
   */
  public MediaRequestInfo getMediaRequestInfo() {
    return mediaRequestInfo;
  }

  /**
   * Extra information about the uploaded media.
   * @param mediaRequestInfo mediaRequestInfo or {@code null} for none
   */
  public TransitObjectUploadRotatingBarcodeValuesRequest setMediaRequestInfo(MediaRequestInfo mediaRequestInfo) {
    this.mediaRequestInfo = mediaRequestInfo;
    return this;
  }

  @Override
  public TransitObjectUploadRotatingBarcodeValuesRequest set(String fieldName, Object value) {
    return (TransitObjectUploadRotatingBarcodeValuesRequest) super.set(fieldName, value);
  }

  @Override
  public TransitObjectUploadRotatingBarcodeValuesRequest clone() {
    return (TransitObjectUploadRotatingBarcodeValuesRequest) super.clone();
  }

}
