/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TicketRestrictions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TicketRestrictions extends com.google.api.client.json.GenericJson {

  /**
   * Extra restrictions that don't fall under the "route" or "time" categories.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString otherRestrictions;

  /**
   * Restrictions about routes that may be taken. For example, this may be the string "Reserved
   * CrossCountry trains only".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString routeRestrictions;

  /**
   * More details about the above `routeRestrictions`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString routeRestrictionsDetails;

  /**
   * Restrictions about times this ticket may be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString timeRestrictions;

  /**
   * Extra restrictions that don't fall under the "route" or "time" categories.
   * @return value or {@code null} for none
   */
  public LocalizedString getOtherRestrictions() {
    return otherRestrictions;
  }

  /**
   * Extra restrictions that don't fall under the "route" or "time" categories.
   * @param otherRestrictions otherRestrictions or {@code null} for none
   */
  public TicketRestrictions setOtherRestrictions(LocalizedString otherRestrictions) {
    this.otherRestrictions = otherRestrictions;
    return this;
  }

  /**
   * Restrictions about routes that may be taken. For example, this may be the string "Reserved
   * CrossCountry trains only".
   * @return value or {@code null} for none
   */
  public LocalizedString getRouteRestrictions() {
    return routeRestrictions;
  }

  /**
   * Restrictions about routes that may be taken. For example, this may be the string "Reserved
   * CrossCountry trains only".
   * @param routeRestrictions routeRestrictions or {@code null} for none
   */
  public TicketRestrictions setRouteRestrictions(LocalizedString routeRestrictions) {
    this.routeRestrictions = routeRestrictions;
    return this;
  }

  /**
   * More details about the above `routeRestrictions`.
   * @return value or {@code null} for none
   */
  public LocalizedString getRouteRestrictionsDetails() {
    return routeRestrictionsDetails;
  }

  /**
   * More details about the above `routeRestrictions`.
   * @param routeRestrictionsDetails routeRestrictionsDetails or {@code null} for none
   */
  public TicketRestrictions setRouteRestrictionsDetails(LocalizedString routeRestrictionsDetails) {
    this.routeRestrictionsDetails = routeRestrictionsDetails;
    return this;
  }

  /**
   * Restrictions about times this ticket may be used.
   * @return value or {@code null} for none
   */
  public LocalizedString getTimeRestrictions() {
    return timeRestrictions;
  }

  /**
   * Restrictions about times this ticket may be used.
   * @param timeRestrictions timeRestrictions or {@code null} for none
   */
  public TicketRestrictions setTimeRestrictions(LocalizedString timeRestrictions) {
    this.timeRestrictions = timeRestrictions;
    return this;
  }

  @Override
  public TicketRestrictions set(String fieldName, Object value) {
    return (TicketRestrictions) super.set(fieldName, value);
  }

  @Override
  public TicketRestrictions clone() {
    return (TicketRestrictions) super.clone();
  }

}
