/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TicketLeg.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TicketLeg extends com.google.api.client.json.GenericJson {

  /**
   * The date/time of arrival. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the destination station. For example, if the event occurs at the 20th hour
   * of June 5th, 2018 at the destination station, the local date/time portion should be
   * `2018-06-05T20:00:00`. If the local date/time at the destination station is 4 hours before UTC,
   * an offset of `-04:00` may be appended. Without offset information, some rich features may not
   * be available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String arrivalDateTime;

  /**
   * The train or ship name/number that the passsenger needs to board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carriage;

  /**
   * The date/time of departure. This is required if there is no validity time interval set on the
   * transit object. This is an ISO 8601 extended format date/time, with or without an offset. Time
   * may be specified up to nanosecond precision. Offsets may be specified with seconds precision
   * (even though offset seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z`
   * would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC.
   * `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of
   * April 12th, 1985, 4 hours before UTC (same instant in time as the above example). If the event
   * were in New York, this would be the equivalent of Eastern Daylight Time (EDT). Remember that
   * offset varies in regions that observe Daylight Saving Time (or Summer Time), depending on the
   * time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th
   * hour of April 12th, 1985 with no offset information. The portion of the date/time without the
   * offset is considered the "local date/time". This should be the local date/time at the origin
   * station. For example, if the departure occurs at the 20th hour of June 5th, 2018 at the origin
   * station, the local date/time portion should be `2018-06-05T20:00:00`. If the local date/time at
   * the origin station is 4 hours before UTC, an offset of `-04:00` may be appended. Without offset
   * information, some rich features may not be available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String departureDateTime;

  /**
   * The destination name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString destinationName;

  /**
   * The destination station code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationStationCode;

  /**
   * Short description/name of the fare for this leg of travel. Eg "Anytime Single Use".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString fareName;

  /**
   * The name of the origin station. This is required if `desinationName` is present or if
   * `originStationCode` is not present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString originName;

  /**
   * The origin station code. This is required if `destinationStationCode` is present or if
   * `originName` is not present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originStationCode;

  /**
   * The platform or gate where the passenger can board the carriage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * The reserved seat for the passenger(s). If more than one seat is to be specified then use the
   * `ticketSeats` field instead. Both `ticketSeat` and `ticketSeats` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TicketSeat ticketSeat;

  /**
   * The reserved seat for the passenger(s). If only one seat is to be specified then use the
   * `ticketSeat` field instead. Both `ticketSeat` and `ticketSeats` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TicketSeat> ticketSeats;

  /**
   * The name of the transit operator that is operating this leg of a trip.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString transitOperatorName;

  /**
   * Terminus station or destination of the train/bus/etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString transitTerminusName;

  /**
   * The zone of boarding within the platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * The date/time of arrival. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the destination station. For example, if the event occurs at the 20th hour
   * of June 5th, 2018 at the destination station, the local date/time portion should be
   * `2018-06-05T20:00:00`. If the local date/time at the destination station is 4 hours before UTC,
   * an offset of `-04:00` may be appended. Without offset information, some rich features may not
   * be available.
   * @return value or {@code null} for none
   */
  public java.lang.String getArrivalDateTime() {
    return arrivalDateTime;
  }

  /**
   * The date/time of arrival. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the destination station. For example, if the event occurs at the 20th hour
   * of June 5th, 2018 at the destination station, the local date/time portion should be
   * `2018-06-05T20:00:00`. If the local date/time at the destination station is 4 hours before UTC,
   * an offset of `-04:00` may be appended. Without offset information, some rich features may not
   * be available.
   * @param arrivalDateTime arrivalDateTime or {@code null} for none
   */
  public TicketLeg setArrivalDateTime(java.lang.String arrivalDateTime) {
    this.arrivalDateTime = arrivalDateTime;
    return this;
  }

  /**
   * The train or ship name/number that the passsenger needs to board.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarriage() {
    return carriage;
  }

  /**
   * The train or ship name/number that the passsenger needs to board.
   * @param carriage carriage or {@code null} for none
   */
  public TicketLeg setCarriage(java.lang.String carriage) {
    this.carriage = carriage;
    return this;
  }

  /**
   * The date/time of departure. This is required if there is no validity time interval set on the
   * transit object. This is an ISO 8601 extended format date/time, with or without an offset. Time
   * may be specified up to nanosecond precision. Offsets may be specified with seconds precision
   * (even though offset seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z`
   * would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC.
   * `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of
   * April 12th, 1985, 4 hours before UTC (same instant in time as the above example). If the event
   * were in New York, this would be the equivalent of Eastern Daylight Time (EDT). Remember that
   * offset varies in regions that observe Daylight Saving Time (or Summer Time), depending on the
   * time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th
   * hour of April 12th, 1985 with no offset information. The portion of the date/time without the
   * offset is considered the "local date/time". This should be the local date/time at the origin
   * station. For example, if the departure occurs at the 20th hour of June 5th, 2018 at the origin
   * station, the local date/time portion should be `2018-06-05T20:00:00`. If the local date/time at
   * the origin station is 4 hours before UTC, an offset of `-04:00` may be appended. Without offset
   * information, some rich features may not be available.
   * @return value or {@code null} for none
   */
  public java.lang.String getDepartureDateTime() {
    return departureDateTime;
  }

  /**
   * The date/time of departure. This is required if there is no validity time interval set on the
   * transit object. This is an ISO 8601 extended format date/time, with or without an offset. Time
   * may be specified up to nanosecond precision. Offsets may be specified with seconds precision
   * (even though offset seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z`
   * would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC.
   * `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of
   * April 12th, 1985, 4 hours before UTC (same instant in time as the above example). If the event
   * were in New York, this would be the equivalent of Eastern Daylight Time (EDT). Remember that
   * offset varies in regions that observe Daylight Saving Time (or Summer Time), depending on the
   * time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th
   * hour of April 12th, 1985 with no offset information. The portion of the date/time without the
   * offset is considered the "local date/time". This should be the local date/time at the origin
   * station. For example, if the departure occurs at the 20th hour of June 5th, 2018 at the origin
   * station, the local date/time portion should be `2018-06-05T20:00:00`. If the local date/time at
   * the origin station is 4 hours before UTC, an offset of `-04:00` may be appended. Without offset
   * information, some rich features may not be available.
   * @param departureDateTime departureDateTime or {@code null} for none
   */
  public TicketLeg setDepartureDateTime(java.lang.String departureDateTime) {
    this.departureDateTime = departureDateTime;
    return this;
  }

  /**
   * The destination name.
   * @return value or {@code null} for none
   */
  public LocalizedString getDestinationName() {
    return destinationName;
  }

  /**
   * The destination name.
   * @param destinationName destinationName or {@code null} for none
   */
  public TicketLeg setDestinationName(LocalizedString destinationName) {
    this.destinationName = destinationName;
    return this;
  }

  /**
   * The destination station code.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationStationCode() {
    return destinationStationCode;
  }

  /**
   * The destination station code.
   * @param destinationStationCode destinationStationCode or {@code null} for none
   */
  public TicketLeg setDestinationStationCode(java.lang.String destinationStationCode) {
    this.destinationStationCode = destinationStationCode;
    return this;
  }

  /**
   * Short description/name of the fare for this leg of travel. Eg "Anytime Single Use".
   * @return value or {@code null} for none
   */
  public LocalizedString getFareName() {
    return fareName;
  }

  /**
   * Short description/name of the fare for this leg of travel. Eg "Anytime Single Use".
   * @param fareName fareName or {@code null} for none
   */
  public TicketLeg setFareName(LocalizedString fareName) {
    this.fareName = fareName;
    return this;
  }

  /**
   * The name of the origin station. This is required if `desinationName` is present or if
   * `originStationCode` is not present.
   * @return value or {@code null} for none
   */
  public LocalizedString getOriginName() {
    return originName;
  }

  /**
   * The name of the origin station. This is required if `desinationName` is present or if
   * `originStationCode` is not present.
   * @param originName originName or {@code null} for none
   */
  public TicketLeg setOriginName(LocalizedString originName) {
    this.originName = originName;
    return this;
  }

  /**
   * The origin station code. This is required if `destinationStationCode` is present or if
   * `originName` is not present.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginStationCode() {
    return originStationCode;
  }

  /**
   * The origin station code. This is required if `destinationStationCode` is present or if
   * `originName` is not present.
   * @param originStationCode originStationCode or {@code null} for none
   */
  public TicketLeg setOriginStationCode(java.lang.String originStationCode) {
    this.originStationCode = originStationCode;
    return this;
  }

  /**
   * The platform or gate where the passenger can board the carriage.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * The platform or gate where the passenger can board the carriage.
   * @param platform platform or {@code null} for none
   */
  public TicketLeg setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  /**
   * The reserved seat for the passenger(s). If more than one seat is to be specified then use the
   * `ticketSeats` field instead. Both `ticketSeat` and `ticketSeats` may not be set.
   * @return value or {@code null} for none
   */
  public TicketSeat getTicketSeat() {
    return ticketSeat;
  }

  /**
   * The reserved seat for the passenger(s). If more than one seat is to be specified then use the
   * `ticketSeats` field instead. Both `ticketSeat` and `ticketSeats` may not be set.
   * @param ticketSeat ticketSeat or {@code null} for none
   */
  public TicketLeg setTicketSeat(TicketSeat ticketSeat) {
    this.ticketSeat = ticketSeat;
    return this;
  }

  /**
   * The reserved seat for the passenger(s). If only one seat is to be specified then use the
   * `ticketSeat` field instead. Both `ticketSeat` and `ticketSeats` may not be set.
   * @return value or {@code null} for none
   */
  public java.util.List<TicketSeat> getTicketSeats() {
    return ticketSeats;
  }

  /**
   * The reserved seat for the passenger(s). If only one seat is to be specified then use the
   * `ticketSeat` field instead. Both `ticketSeat` and `ticketSeats` may not be set.
   * @param ticketSeats ticketSeats or {@code null} for none
   */
  public TicketLeg setTicketSeats(java.util.List<TicketSeat> ticketSeats) {
    this.ticketSeats = ticketSeats;
    return this;
  }

  /**
   * The name of the transit operator that is operating this leg of a trip.
   * @return value or {@code null} for none
   */
  public LocalizedString getTransitOperatorName() {
    return transitOperatorName;
  }

  /**
   * The name of the transit operator that is operating this leg of a trip.
   * @param transitOperatorName transitOperatorName or {@code null} for none
   */
  public TicketLeg setTransitOperatorName(LocalizedString transitOperatorName) {
    this.transitOperatorName = transitOperatorName;
    return this;
  }

  /**
   * Terminus station or destination of the train/bus/etc.
   * @return value or {@code null} for none
   */
  public LocalizedString getTransitTerminusName() {
    return transitTerminusName;
  }

  /**
   * Terminus station or destination of the train/bus/etc.
   * @param transitTerminusName transitTerminusName or {@code null} for none
   */
  public TicketLeg setTransitTerminusName(LocalizedString transitTerminusName) {
    this.transitTerminusName = transitTerminusName;
    return this;
  }

  /**
   * The zone of boarding within the platform.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * The zone of boarding within the platform.
   * @param zone zone or {@code null} for none
   */
  public TicketLeg setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public TicketLeg set(String fieldName, Object value) {
    return (TicketLeg) super.set(fieldName, value);
  }

  @Override
  public TicketLeg clone() {
    return (TicketLeg) super.clone();
  }

}
