/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Data for Text module. All fields are optional. Header will be displayed if available, different
 * types of bodies will be concatenated if they are defined.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextModuleData extends com.google.api.client.json.GenericJson {

  /**
   * The body of the Text Module, which is defined as an uninterrupted string. Recommended maximum
   * length is 500 characters to ensure full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String body;

  /**
   * The header of the Text Module. Recommended maximum length is 35 characters to ensure full
   * string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String header;

  /**
   * The ID associated with a text module. This field is here to enable ease of management of text
   * modules and referencing them in template overrides. The ID should only include alphanumeric
   * characters, '_', or '-'. It can not include dots, as dots are used to separate fields within
   * FieldReference.fieldPaths in template overrides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Translated strings for the body. Recommended maximum length is 500 characters to ensure full
   * string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedBody;

  /**
   * Translated strings for the header. Recommended maximum length is 35 characters to ensure full
   * string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedHeader;

  /**
   * The body of the Text Module, which is defined as an uninterrupted string. Recommended maximum
   * length is 500 characters to ensure full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getBody() {
    return body;
  }

  /**
   * The body of the Text Module, which is defined as an uninterrupted string. Recommended maximum
   * length is 500 characters to ensure full string is displayed on smaller screens.
   * @param body body or {@code null} for none
   */
  public TextModuleData setBody(java.lang.String body) {
    this.body = body;
    return this;
  }

  /**
   * The header of the Text Module. Recommended maximum length is 35 characters to ensure full
   * string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeader() {
    return header;
  }

  /**
   * The header of the Text Module. Recommended maximum length is 35 characters to ensure full
   * string is displayed on smaller screens.
   * @param header header or {@code null} for none
   */
  public TextModuleData setHeader(java.lang.String header) {
    this.header = header;
    return this;
  }

  /**
   * The ID associated with a text module. This field is here to enable ease of management of text
   * modules and referencing them in template overrides. The ID should only include alphanumeric
   * characters, '_', or '-'. It can not include dots, as dots are used to separate fields within
   * FieldReference.fieldPaths in template overrides.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID associated with a text module. This field is here to enable ease of management of text
   * modules and referencing them in template overrides. The ID should only include alphanumeric
   * characters, '_', or '-'. It can not include dots, as dots are used to separate fields within
   * FieldReference.fieldPaths in template overrides.
   * @param id id or {@code null} for none
   */
  public TextModuleData setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Translated strings for the body. Recommended maximum length is 500 characters to ensure full
   * string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedBody() {
    return localizedBody;
  }

  /**
   * Translated strings for the body. Recommended maximum length is 500 characters to ensure full
   * string is displayed on smaller screens.
   * @param localizedBody localizedBody or {@code null} for none
   */
  public TextModuleData setLocalizedBody(LocalizedString localizedBody) {
    this.localizedBody = localizedBody;
    return this;
  }

  /**
   * Translated strings for the header. Recommended maximum length is 35 characters to ensure full
   * string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedHeader() {
    return localizedHeader;
  }

  /**
   * Translated strings for the header. Recommended maximum length is 35 characters to ensure full
   * string is displayed on smaller screens.
   * @param localizedHeader localizedHeader or {@code null} for none
   */
  public TextModuleData setLocalizedHeader(LocalizedString localizedHeader) {
    this.localizedHeader = localizedHeader;
    return this;
  }

  @Override
  public TextModuleData set(String fieldName, Object value) {
    return (TextModuleData) super.set(fieldName, value);
  }

  @Override
  public TextModuleData clone() {
    return (TextModuleData) super.clone();
  }

}
