/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for Resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Resources extends com.google.api.client.json.GenericJson {

  /**
   * A list of event ticket classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventTicketClass> eventTicketClasses;

  static {
    // hack to force ProGuard to consider EventTicketClass used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(EventTicketClass.class);
  }

  /**
   * A list of event ticket objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventTicketObject> eventTicketObjects;

  static {
    // hack to force ProGuard to consider EventTicketObject used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(EventTicketObject.class);
  }

  /**
   * A list of flight classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FlightClass> flightClasses;

  static {
    // hack to force ProGuard to consider FlightClass used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FlightClass.class);
  }

  /**
   * A list of flight objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FlightObject> flightObjects;

  static {
    // hack to force ProGuard to consider FlightObject used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FlightObject.class);
  }

  /**
   * A list of generic classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GenericClass> genericClasses;

  static {
    // hack to force ProGuard to consider GenericClass used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GenericClass.class);
  }

  /**
   * A list of generic objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GenericObject> genericObjects;

  static {
    // hack to force ProGuard to consider GenericObject used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GenericObject.class);
  }

  /**
   * A list of gift card classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GiftCardClass> giftCardClasses;

  static {
    // hack to force ProGuard to consider GiftCardClass used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GiftCardClass.class);
  }

  /**
   * A list of gift card objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GiftCardObject> giftCardObjects;

  static {
    // hack to force ProGuard to consider GiftCardObject used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GiftCardObject.class);
  }

  /**
   * A list of loyalty classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LoyaltyClass> loyaltyClasses;

  static {
    // hack to force ProGuard to consider LoyaltyClass used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LoyaltyClass.class);
  }

  /**
   * A list of loyalty objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LoyaltyObject> loyaltyObjects;

  static {
    // hack to force ProGuard to consider LoyaltyObject used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LoyaltyObject.class);
  }

  /**
   * A list of offer classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OfferClass> offerClasses;

  static {
    // hack to force ProGuard to consider OfferClass used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(OfferClass.class);
  }

  /**
   * A list of offer objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OfferObject> offerObjects;

  static {
    // hack to force ProGuard to consider OfferObject used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(OfferObject.class);
  }

  /**
   * A list of transit classes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TransitClass> transitClasses;

  /**
   * A list of transit objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TransitObject> transitObjects;

  /**
   * A list of event ticket classes.
   * @return value or {@code null} for none
   */
  public java.util.List<EventTicketClass> getEventTicketClasses() {
    return eventTicketClasses;
  }

  /**
   * A list of event ticket classes.
   * @param eventTicketClasses eventTicketClasses or {@code null} for none
   */
  public Resources setEventTicketClasses(java.util.List<EventTicketClass> eventTicketClasses) {
    this.eventTicketClasses = eventTicketClasses;
    return this;
  }

  /**
   * A list of event ticket objects.
   * @return value or {@code null} for none
   */
  public java.util.List<EventTicketObject> getEventTicketObjects() {
    return eventTicketObjects;
  }

  /**
   * A list of event ticket objects.
   * @param eventTicketObjects eventTicketObjects or {@code null} for none
   */
  public Resources setEventTicketObjects(java.util.List<EventTicketObject> eventTicketObjects) {
    this.eventTicketObjects = eventTicketObjects;
    return this;
  }

  /**
   * A list of flight classes.
   * @return value or {@code null} for none
   */
  public java.util.List<FlightClass> getFlightClasses() {
    return flightClasses;
  }

  /**
   * A list of flight classes.
   * @param flightClasses flightClasses or {@code null} for none
   */
  public Resources setFlightClasses(java.util.List<FlightClass> flightClasses) {
    this.flightClasses = flightClasses;
    return this;
  }

  /**
   * A list of flight objects.
   * @return value or {@code null} for none
   */
  public java.util.List<FlightObject> getFlightObjects() {
    return flightObjects;
  }

  /**
   * A list of flight objects.
   * @param flightObjects flightObjects or {@code null} for none
   */
  public Resources setFlightObjects(java.util.List<FlightObject> flightObjects) {
    this.flightObjects = flightObjects;
    return this;
  }

  /**
   * A list of generic classes.
   * @return value or {@code null} for none
   */
  public java.util.List<GenericClass> getGenericClasses() {
    return genericClasses;
  }

  /**
   * A list of generic classes.
   * @param genericClasses genericClasses or {@code null} for none
   */
  public Resources setGenericClasses(java.util.List<GenericClass> genericClasses) {
    this.genericClasses = genericClasses;
    return this;
  }

  /**
   * A list of generic objects.
   * @return value or {@code null} for none
   */
  public java.util.List<GenericObject> getGenericObjects() {
    return genericObjects;
  }

  /**
   * A list of generic objects.
   * @param genericObjects genericObjects or {@code null} for none
   */
  public Resources setGenericObjects(java.util.List<GenericObject> genericObjects) {
    this.genericObjects = genericObjects;
    return this;
  }

  /**
   * A list of gift card classes.
   * @return value or {@code null} for none
   */
  public java.util.List<GiftCardClass> getGiftCardClasses() {
    return giftCardClasses;
  }

  /**
   * A list of gift card classes.
   * @param giftCardClasses giftCardClasses or {@code null} for none
   */
  public Resources setGiftCardClasses(java.util.List<GiftCardClass> giftCardClasses) {
    this.giftCardClasses = giftCardClasses;
    return this;
  }

  /**
   * A list of gift card objects.
   * @return value or {@code null} for none
   */
  public java.util.List<GiftCardObject> getGiftCardObjects() {
    return giftCardObjects;
  }

  /**
   * A list of gift card objects.
   * @param giftCardObjects giftCardObjects or {@code null} for none
   */
  public Resources setGiftCardObjects(java.util.List<GiftCardObject> giftCardObjects) {
    this.giftCardObjects = giftCardObjects;
    return this;
  }

  /**
   * A list of loyalty classes.
   * @return value or {@code null} for none
   */
  public java.util.List<LoyaltyClass> getLoyaltyClasses() {
    return loyaltyClasses;
  }

  /**
   * A list of loyalty classes.
   * @param loyaltyClasses loyaltyClasses or {@code null} for none
   */
  public Resources setLoyaltyClasses(java.util.List<LoyaltyClass> loyaltyClasses) {
    this.loyaltyClasses = loyaltyClasses;
    return this;
  }

  /**
   * A list of loyalty objects.
   * @return value or {@code null} for none
   */
  public java.util.List<LoyaltyObject> getLoyaltyObjects() {
    return loyaltyObjects;
  }

  /**
   * A list of loyalty objects.
   * @param loyaltyObjects loyaltyObjects or {@code null} for none
   */
  public Resources setLoyaltyObjects(java.util.List<LoyaltyObject> loyaltyObjects) {
    this.loyaltyObjects = loyaltyObjects;
    return this;
  }

  /**
   * A list of offer classes.
   * @return value or {@code null} for none
   */
  public java.util.List<OfferClass> getOfferClasses() {
    return offerClasses;
  }

  /**
   * A list of offer classes.
   * @param offerClasses offerClasses or {@code null} for none
   */
  public Resources setOfferClasses(java.util.List<OfferClass> offerClasses) {
    this.offerClasses = offerClasses;
    return this;
  }

  /**
   * A list of offer objects.
   * @return value or {@code null} for none
   */
  public java.util.List<OfferObject> getOfferObjects() {
    return offerObjects;
  }

  /**
   * A list of offer objects.
   * @param offerObjects offerObjects or {@code null} for none
   */
  public Resources setOfferObjects(java.util.List<OfferObject> offerObjects) {
    this.offerObjects = offerObjects;
    return this;
  }

  /**
   * A list of transit classes.
   * @return value or {@code null} for none
   */
  public java.util.List<TransitClass> getTransitClasses() {
    return transitClasses;
  }

  /**
   * A list of transit classes.
   * @param transitClasses transitClasses or {@code null} for none
   */
  public Resources setTransitClasses(java.util.List<TransitClass> transitClasses) {
    this.transitClasses = transitClasses;
    return this;
  }

  /**
   * A list of transit objects.
   * @return value or {@code null} for none
   */
  public java.util.List<TransitObject> getTransitObjects() {
    return transitObjects;
  }

  /**
   * A list of transit objects.
   * @param transitObjects transitObjects or {@code null} for none
   */
  public Resources setTransitObjects(java.util.List<TransitObject> transitObjects) {
    this.transitObjects = transitObjects;
    return this;
  }

  @Override
  public Resources set(String fieldName, Object value) {
    return (Resources) super.set(fieldName, value);
  }

  @Override
  public Resources clone() {
    return (Resources) super.clone();
  }

}
