/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for ReservationInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReservationInfo extends com.google.api.client.json.GenericJson {

  /**
   * Confirmation code needed to check into this flight. This is the number that the passenger would
   * enter into a kiosk at the airport to look up the flight and print a boarding pass.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String confirmationCode;

  /**
   * E-ticket number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eticketNumber;

  /**
   * Frequent flyer membership information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FrequentFlyerInfo frequentFlyerInfo;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#reservationInfo"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Confirmation code needed to check into this flight. This is the number that the passenger would
   * enter into a kiosk at the airport to look up the flight and print a boarding pass.
   * @return value or {@code null} for none
   */
  public java.lang.String getConfirmationCode() {
    return confirmationCode;
  }

  /**
   * Confirmation code needed to check into this flight. This is the number that the passenger would
   * enter into a kiosk at the airport to look up the flight and print a boarding pass.
   * @param confirmationCode confirmationCode or {@code null} for none
   */
  public ReservationInfo setConfirmationCode(java.lang.String confirmationCode) {
    this.confirmationCode = confirmationCode;
    return this;
  }

  /**
   * E-ticket number.
   * @return value or {@code null} for none
   */
  public java.lang.String getEticketNumber() {
    return eticketNumber;
  }

  /**
   * E-ticket number.
   * @param eticketNumber eticketNumber or {@code null} for none
   */
  public ReservationInfo setEticketNumber(java.lang.String eticketNumber) {
    this.eticketNumber = eticketNumber;
    return this;
  }

  /**
   * Frequent flyer membership information.
   * @return value or {@code null} for none
   */
  public FrequentFlyerInfo getFrequentFlyerInfo() {
    return frequentFlyerInfo;
  }

  /**
   * Frequent flyer membership information.
   * @param frequentFlyerInfo frequentFlyerInfo or {@code null} for none
   */
  public ReservationInfo setFrequentFlyerInfo(FrequentFlyerInfo frequentFlyerInfo) {
    this.frequentFlyerInfo = frequentFlyerInfo;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#reservationInfo"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#reservationInfo"`.
   * @param kind kind or {@code null} for none
   */
  public ReservationInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public ReservationInfo set(String fieldName, Object value) {
    return (ReservationInfo) super.set(fieldName, value);
  }

  @Override
  public ReservationInfo clone() {
    return (ReservationInfo) super.clone();
  }

}
