/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for PurchaseDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PurchaseDetails extends com.google.api.client.json.GenericJson {

  /**
   * ID of the account used to purchase the ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * The confirmation code for the purchase. This may be the same for multiple different tickets and
   * is used to group tickets together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String confirmationCode;

  /**
   * The purchase date/time of the ticket. This is an ISO 8601 extended format date/time, with or
   * without an offset. Time may be specified up to nanosecond precision. Offsets may be specified
   * with seconds precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. Without
   * offset information, some rich features may not be available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purchaseDateTime;

  /**
   * Receipt number/identifier for tracking the ticket purchase via the body that sold the ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purchaseReceiptNumber;

  /**
   * The cost of the ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TicketCost ticketCost;

  /**
   * ID of the account used to purchase the ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * ID of the account used to purchase the ticket.
   * @param accountId accountId or {@code null} for none
   */
  public PurchaseDetails setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The confirmation code for the purchase. This may be the same for multiple different tickets and
   * is used to group tickets together.
   * @return value or {@code null} for none
   */
  public java.lang.String getConfirmationCode() {
    return confirmationCode;
  }

  /**
   * The confirmation code for the purchase. This may be the same for multiple different tickets and
   * is used to group tickets together.
   * @param confirmationCode confirmationCode or {@code null} for none
   */
  public PurchaseDetails setConfirmationCode(java.lang.String confirmationCode) {
    this.confirmationCode = confirmationCode;
    return this;
  }

  /**
   * The purchase date/time of the ticket. This is an ISO 8601 extended format date/time, with or
   * without an offset. Time may be specified up to nanosecond precision. Offsets may be specified
   * with seconds precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. Without
   * offset information, some rich features may not be available.
   * @return value or {@code null} for none
   */
  public java.lang.String getPurchaseDateTime() {
    return purchaseDateTime;
  }

  /**
   * The purchase date/time of the ticket. This is an ISO 8601 extended format date/time, with or
   * without an offset. Time may be specified up to nanosecond precision. Offsets may be specified
   * with seconds precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. Without
   * offset information, some rich features may not be available.
   * @param purchaseDateTime purchaseDateTime or {@code null} for none
   */
  public PurchaseDetails setPurchaseDateTime(java.lang.String purchaseDateTime) {
    this.purchaseDateTime = purchaseDateTime;
    return this;
  }

  /**
   * Receipt number/identifier for tracking the ticket purchase via the body that sold the ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getPurchaseReceiptNumber() {
    return purchaseReceiptNumber;
  }

  /**
   * Receipt number/identifier for tracking the ticket purchase via the body that sold the ticket.
   * @param purchaseReceiptNumber purchaseReceiptNumber or {@code null} for none
   */
  public PurchaseDetails setPurchaseReceiptNumber(java.lang.String purchaseReceiptNumber) {
    this.purchaseReceiptNumber = purchaseReceiptNumber;
    return this;
  }

  /**
   * The cost of the ticket.
   * @return value or {@code null} for none
   */
  public TicketCost getTicketCost() {
    return ticketCost;
  }

  /**
   * The cost of the ticket.
   * @param ticketCost ticketCost or {@code null} for none
   */
  public PurchaseDetails setTicketCost(TicketCost ticketCost) {
    this.ticketCost = ticketCost;
    return this;
  }

  @Override
  public PurchaseDetails set(String fieldName, Object value) {
    return (PurchaseDetails) super.set(fieldName, value);
  }

  @Override
  public PurchaseDetails clone() {
    return (PurchaseDetails) super.clone();
  }

}
